/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.websocket;

import com.google.common.eventbus.EventBus;
import java.util.Timer;
import java.util.TimerTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.messaging.WebSocketStompClient;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.commons.message.ServerStatusNotification;
import rs.tetrabyte.pezar.commons.message.UserStatusNotification;
import rs.tetrabyte.pezar.websocket.StompSessionHandlerImpl;
import rs.tetrabyte.pezar.websocket.WebSocketEndpointPathBuilder;

public class WebSocketService {
    @Autowired
    private UICommands uiCommands;
    @Autowired
    private EventBus eventBus;
    private WebSocketStompClient stompClient;
    private StompSessionHandlerImpl notificationHandler;
    private static /* synthetic */ int[] $SWITCH_TABLE$rs$tetrabyte$pezar$commons$message$ServerStatusNotification$Status;
    private static /* synthetic */ int[] $SWITCH_TABLE$rs$tetrabyte$pezar$commons$message$UserStatusNotification$Status;

    public WebSocketService() {
        StandardWebSocketClient client = new StandardWebSocketClient();
        this.stompClient = new WebSocketStompClient((WebSocketClient)client);
        this.stompClient.setMessageConverter((MessageConverter)new MappingJackson2MessageConverter());
    }

    public void connect(String serverUrl, Runnable onConnected) {
        if (this.notificationHandler != null) {
            this.notificationHandler.disconnectSession();
        }
        WebSocketEndpointPathBuilder endPointPathBuilder = new WebSocketEndpointPathBuilder(serverUrl);
        this.notificationHandler = new StompSessionHandlerImpl(endPointPathBuilder.notifications().get());
        this.notificationHandler.registerDestination("/topic/notifications-serverstatus", ServerStatusNotification.class).createSubscription().onPayloadRecieved(notif -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        this.notificationHandler.registerDestination("/topic/notifications-userstatus", UserStatusNotification.class).createSubscription().onPayloadRecieved(notif -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        this.notificationHandler.setOnConnected(onConnected);
        this.notificationHandler.setOnConnectionLost(() -> {
            this.uiCommands.lockUI().withMessage("%msg.server.offline", new Object[0]).execute();
            Timer timer = new Timer();
            timer.schedule((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 35000L);
        });
        this.stompClient.connect(endPointPathBuilder.notifications().get(), (StompSessionHandler)this.notificationHandler, new Object[0]);
    }

    public void disconnectSessions() {
        if (this.notificationHandler != null) {
            this.notificationHandler.disconnectSession();
        }
    }

    public void sendUserStatus(UserStatusNotification notification) {
        if (this.notificationHandler != null && this.notificationHandler.isConnected()) {
            this.notificationHandler.send("/topic/notifications-userstatus", (Object)notification);
        }
    }

    public void sendUserStatus(String userName, UserStatusNotification.Status status) {
        if (this.notificationHandler != null && this.notificationHandler.isConnected()) {
            this.notificationHandler.send("/topic/notifications-userstatus", (Object)new UserStatusNotification(userName, status));
        }
    }

    public StompSessionHandlerImpl getNotificationHandler() {
        return this.notificationHandler;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$rs$tetrabyte$pezar$commons$message$ServerStatusNotification$Status() {
        if ($SWITCH_TABLE$rs$tetrabyte$pezar$commons$message$ServerStatusNotification$Status != null) {
            return $SWITCH_TABLE$rs$tetrabyte$pezar$commons$message$ServerStatusNotification$Status;
        }
        int[] nArray = new int[ServerStatusNotification.Status.values().length];
        try {
            nArray[ServerStatusNotification.Status.BUSSY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ServerStatusNotification.Status.READY.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$rs$tetrabyte$pezar$commons$message$ServerStatusNotification$Status = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$rs$tetrabyte$pezar$commons$message$UserStatusNotification$Status() {
        if ($SWITCH_TABLE$rs$tetrabyte$pezar$commons$message$UserStatusNotification$Status != null) {
            return $SWITCH_TABLE$rs$tetrabyte$pezar$commons$message$UserStatusNotification$Status;
        }
        int[] nArray = new int[UserStatusNotification.Status.values().length];
        try {
            nArray[UserStatusNotification.Status.ACTIVE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[UserStatusNotification.Status.IDLE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[UserStatusNotification.Status.LOG_IN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[UserStatusNotification.Status.LOG_OUT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$rs$tetrabyte$pezar$commons$message$UserStatusNotification$Status = nArray;
        return nArray;
    }

    static /* synthetic */ StompSessionHandlerImpl access$2(WebSocketService webSocketService) {
        return webSocketService.notificationHandler;
    }

    static /* synthetic */ UICommands access$3(WebSocketService webSocketService) {
        return webSocketService.uiCommands;
    }

    static /* synthetic */ WebSocketStompClient access$4(WebSocketService webSocketService) {
        return webSocketService.stompClient;
    }
}

