/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.fxml.factory;

import java.util.Optional;
import javafx.util.Builder;
import org.apache.commons.lang3.StringUtils;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.custom.accelerable.PFXMenuItem;
import rs.tetrabyte.pezar.factory.field.util.ControlUtil;
import rs.tetrabyte.pezar.fxml.factory.PFXButtonType;

public class MenuItemBuilder
extends PFXMenuItem
implements Builder<PFXMenuItem> {
    private LocaleContext localeContext;
    private String label;
    private String accelerator;

    public MenuItemBuilder(LocaleContext localeContext) {
        this.localeContext = localeContext;
    }

    public PFXMenuItem build() {
        Optional btnType;
        if (this.getId() != null && (btnType = PFXButtonType.getButtonType((String)this.getId().replaceFirst("mitm-", ""))).isPresent()) {
            if (!StringUtils.isEmpty((CharSequence)((PFXButtonType)btnType.get()).getTextKey())) {
                this.handleButtonText(this.localeContext.getResources().getString(((PFXButtonType)btnType.get()).getTextKey()));
            }
            this.setGlyph(((PFXButtonType)btnType.get()).getGlyph());
            this.setText(null);
            return this;
        }
        this.handleButtonText(this.getText());
        return this;
    }

    private void handleButtonText(String text) {
        this.parseText(text);
        this.setButtonText(this.label);
        if (!StringUtils.isEmpty((CharSequence)this.accelerator)) {
            this.setAcceleratorString(this.accelerator);
        }
        this.setText(null);
    }

    private void parseText(String text) {
        if (!StringUtils.isEmpty((CharSequence)text)) {
            String[] parsed = ControlUtil.parseAcceleratedLabel((String)text);
            this.label = parsed[0];
            if (parsed.length > 1) {
                this.accelerator = parsed[1];
            }
        }
    }
}

