/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.fxml.factory;

import java.util.Optional;
import javafx.util.Builder;
import org.apache.commons.lang3.StringUtils;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.custom.accelerable.PFXButton;
import rs.tetrabyte.pezar.factory.field.util.ControlUtil;
import rs.tetrabyte.pezar.fxml.factory.PFXButtonType;

public class ButtonBuilder
extends PFXButton
implements Builder<PFXButton> {
    private LocaleContext localeContext;
    private String label;
    private String accelerator;
    private String glyph;

    public ButtonBuilder(LocaleContext localeContext) {
        this.localeContext = localeContext;
    }

    public PFXButton build() {
        Optional btnType;
        if (this.getId() != null && (btnType = PFXButtonType.getButtonType((String)this.getId().replaceFirst("btn-", ""))).isPresent()) {
            if (!StringUtils.isEmpty((CharSequence)((PFXButtonType)btnType.get()).getTextKey())) {
                this.handleButtonText(this.localeContext.getResources().getString(((PFXButtonType)btnType.get()).getTextKey()));
            }
            this.setGlyph(((PFXButtonType)btnType.get()).getGlyph());
            this.setText(null);
            return this;
        }
        this.handleButtonText(this.getText());
        return this;
    }

    private void handleButtonText(String text) {
        this.parseText(text);
        this.setButtonText(this.label);
        if (!StringUtils.isEmpty((CharSequence)this.accelerator)) {
            this.setAcceleratorString(this.accelerator);
        }
        if (!StringUtils.isEmpty((CharSequence)this.glyph)) {
            this.setGlyph(this.glyph);
        }
        this.setText(null);
    }

    private void parseText(String text) {
        if (!StringUtils.isEmpty((CharSequence)text)) {
            String[] parsed = ControlUtil.parseAcceleratedLabel((String)text);
            this.label = parsed[0];
            if (parsed[1] != null) {
                this.accelerator = parsed[1];
            }
            if (parsed[2] != null) {
                this.glyph = parsed[2];
            }
        }
    }
}

