/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.features;

import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datamodel.uidescriptors.Directive;
import rs.tetrabyte.datamodel.uidescriptors.features.UIFeatureDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.features.UIFeatureType;
import rs.tetrabyte.datarest.repository.RepositorySearch;
import rs.tetrabyte.fxml.Output;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.EBrowserContext;
import rs.tetrabyte.pezar.context.InventoryPickerService;
import rs.tetrabyte.pezar.context.MessageService;
import rs.tetrabyte.pezar.factory.GlyphFactory;
import rs.tetrabyte.pezar.factory.field.util.ReferenceDescriptor;
import rs.tetrabyte.pezar.features.UIFeature;
import rs.tetrabyte.pezar.features.UIFeatureDefault;

public class UIFeatureFactory {
    @Autowired
    private UICommands commands;
    @Autowired
    private InventoryPickerService pickerService;
    @Autowired
    private EBrowserContext browserCtx;
    @Autowired
    private MessageService messages;

    public UIFeature createFeature(UIFeatureDescriptor d, String parentId) {
        String label = this.messages.getMessage(d.getLabel(), new Object[0]).split(",")[0];
        UIFeatureDefault feature = new UIFeatureDefault(d.getFeatureId(), label, parentId, () -> GlyphFactory.createGlyph((String)d.getGlyph()));
        if (d.getType() == UIFeatureType.BROWSER) {
            String browserId = ReferenceDescriptor.of((String)d.getFeatureId()).getRepoDiscriminated();
            feature.setOnAction(e -> {
                ReferenceDescriptor refDesc = ReferenceDescriptor.of((String)d.getFeatureId());
                if (refDesc.getRepository().equals("items")) {
                    this.browserCtx.getBrowserDescriptor(browserId, browser -> {
                        Optional dir = browser.getDirective("inventory");
                        if (dir.isPresent()) {
                            String discriminator = ((Directive)dir.get()).getValue().replace(',', '+');
                            this.pickerService.getInventory(discriminator, inventory -> {
                                RepositorySearch search = RepositorySearch.builder().withRel("discriminator").withParam("inv", inventory.parseId()).build();
                                this.commands.openBrowser(browserId).withOutput(Output.values((Object[])new Object[]{inventory, search})).onOpen(controller -> controller.onOpened()).execute();
                            });
                        } else {
                            this.commands.openBrowser(browserId).execute();
                        }
                    });
                } else {
                    this.commands.openBrowser(browserId).execute();
                }
            });
        }
        return feature;
    }
}

