/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.features;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javafx.event.EventHandler;
import javafx.scene.Node;
import rs.tetrabyte.pezar.factory.GlyphFactory;
import rs.tetrabyte.pezar.features.UIFeature;
import rs.tetrabyte.pezar.features.event.UIEvent;

public class UIFeatureDefault
implements UIFeature {
    private String id;
    private String label;
    private Supplier<Node> graphic;
    private List<UIFeature> children = new ArrayList();
    private EventHandler<UIEvent> eventHandler;
    private String parentId;

    public UIFeatureDefault() {
    }

    public UIFeatureDefault(String id, String label, String parentId, Supplier<Node> graphic) {
        this.id = id;
        this.label = label;
        this.parentId = parentId;
        this.graphic = graphic;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Node getGraphic() {
        return this.graphic != null ? (Node)this.graphic.get() : null;
    }

    public void setGraphic(Supplier<Node> graphic) {
        this.graphic = graphic;
    }

    public void setGlyph(String code) {
        this.setGraphic(() -> GlyphFactory.createGlyph((String)code));
    }

    public void setGlyph(FontAwesomeIcon icon) {
        this.setGraphic(() -> new FontAwesomeIconView(icon));
    }

    public List<UIFeature> getChildren() {
        return this.children;
    }

    public EventHandler<UIEvent> getOnAction() {
        return this.eventHandler;
    }

    public void setOnAction(EventHandler<UIEvent> eventHandler) {
        this.eventHandler = eventHandler;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + String.format("[ id: %s, parenId: %s ]", this.getId(), this.getParentId());
    }
}

