/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.factory.field.search;

import java.math.BigDecimal;
import java.text.ParseException;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Pos;
import javafx.scene.control.Control;
import javafx.util.StringConverter;
import jidefx.scene.control.field.NumberField;
import rs.tetrabyte.datamodel.uidescriptors.entity.ESearchDescriptor;
import rs.tetrabyte.pezar.controller.FormFieldController;
import rs.tetrabyte.pezar.factory.field.search.SearchFieldFactory;

public class SearchDecimalFieldFactory
implements SearchFieldFactory {
    private ChangeListener<Number> changeListener;

    public boolean supportsType(String type) {
        if (type == null) {
            return false;
        }
        return "decimal".equals(type);
    }

    public FormFieldController createControl(ESearchDescriptor.ESearchFieldDescriptor d) {
        NumberField nf = new NumberField();
        nf.setNumberType(NumberField.NumberType.Normal);
        nf.setValue((Object)new BigDecimal(0));
        nf.setAlignment(Pos.BASELINE_RIGHT);
        nf.setSpinnersVisible(false);
        nf.getPatternVerifiers().put((Object)"n", (Object)new /* Unavailable Anonymous Inner Class!! */);
        nf.getPatternVerifiers().put((Object)"f", (Object)new /* Unavailable Anonymous Inner Class!! */);
        FormFieldController c = new FormFieldController((Control)nf);
        c.setBind(p -> this.bind(nf, p));
        c.setUnBind(p -> this.unBind(nf));
        return c;
    }

    private void bind(NumberField nf, StringProperty prop) {
        nf.setStringConverter((StringConverter)new /* Unavailable Anonymous Inner Class!! */);
        String value = prop.getValue();
        if (value != null) {
            try {
                nf.setValue((Object)nf.getDecimalFormat().parse(value));
            }
            catch (ParseException e) {
                nf.setValue((Object)BigDecimal.ZERO);
            }
        }
        this.changeListener = new /* Unavailable Anonymous Inner Class!! */;
        nf.valueProperty().addListener(this.changeListener);
    }

    private void unBind(NumberField nf) {
        nf.valueProperty().removeListener(this.changeListener);
    }
}

