/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom.validator;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.util.Callback;
import jidefx.scene.control.decoration.DecorationUtils;
import jidefx.scene.control.decoration.Decorator;
import jidefx.scene.control.validation.ValidationEvent;
import jidefx.scene.control.validation.ValidationMode;
import jidefx.scene.control.validation.ValidationObject;
import jidefx.scene.control.validation.ValidationUtils;
import rs.tetrabyte.pezar.custom.validator.CustomValidator;
import rs.tetrabyte.pezar.custom.validator.RegexValidator;
import rs.tetrabyte.pezar.custom.validator.RequiredValidator;
import rs.tetrabyte.pezar.custom.validator.Validator;

public class Validators
implements jidefx.scene.control.validation.Validator {
    private List<Validator> validators = new ArrayList();
    private Control control;

    public Validators() {
    }

    public Validators(Control control) {
        this();
        this.install(control);
        this.control = control;
    }

    public Validators required() {
        this.validators.add(new RequiredValidator());
        FontAwesomeIconView lblRequired = new FontAwesomeIconView(FontAwesomeIcon.ASTERISK);
        Decorator decRequired = new Decorator((Node)lblRequired, Pos.CENTER_RIGHT);
        DecorationUtils.install((Node)this.control, (Decorator)decRequired);
        return this;
    }

    public Validators regex(String regex) {
        this.validators.add(new RegexValidator(regex));
        return this;
    }

    public Validators email() {
        return this.regex("^[\\w-\\+]+(\\.[\\w]+)*@[\\w-]+(\\.[\\w]+)*(\\.[a-z]{2,})$");
    }

    public Validators userName() {
        return this.regex("[\\w-\\+]+(\\.[\\w]+)*");
    }

    public Validators word() {
        return this.regex("\\w+");
    }

    public Validators numeric() {
        return this.regex("\\d+");
    }

    public Validators alphaNumeric() {
        return this.regex("[a-zA-Z0-9]+");
    }

    public Validators custom(Callback<ValidationObject, ValidationEvent> value) {
        this.validators.add(new CustomValidator(value));
        return this;
    }

    public ValidationEvent call(ValidationObject param) {
        ValidationEvent event = ValidationEvent.OK;
        Iterator iterator = this.validators.iterator();
        while (iterator.hasNext() && !event.getEventType().equals(ValidationEvent.VALIDATION_ERROR)) {
            Validator validator = (Validator)iterator.next();
            event = validator.call(param);
        }
        return event;
    }

    private void install(Control control) {
        ValidationUtils.install((Node)control, (jidefx.scene.control.validation.Validator)this, (ValidationMode)ValidationMode.ON_FLY);
        ValidationUtils.install((Node)control, (jidefx.scene.control.validation.Validator)this, (ValidationMode)ValidationMode.ON_DEMAND);
    }

    public static Validators create(Control control) {
        return new Validators(control);
    }

    public static void uninstall(Control control) {
        ValidationUtils.uninstall((Node)control, (ValidationMode)ValidationMode.ON_DEMAND);
        ValidationUtils.uninstall((Node)control, (ValidationMode)ValidationMode.ON_FLY);
        DecorationUtils.uninstall((Node)control);
    }
}

