/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.custom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import rs.tetrabyte.pezar.custom.FormFieldContainer;
import rs.tetrabyte.pezar.custom.FormFieldGroup;
import rs.tetrabyte.pezar.custom.FormView;
import rs.tetrabyte.pezar.custom.event.FormEvent;
import rs.tetrabyte.pezar.custom.factory.form.reader.ObjectReader;

public class FormView<T>
extends VBox {
    private VBox content;
    private EventHandler<FormEvent<T>> stateChangedEventHandler;
    private ObjectProperty<FormMode> formMode = new SimpleObjectProperty();
    private List<FormFieldGroup> groupList = new ArrayList();
    private ObjectReader<T> objectReader;
    private Callback<ObjectReader.Field, FormFieldContainer> fieldFactory;
    private T model;
    private Callable<List<FormFieldGroup>> fieldGroupFactory;
    private Predicate<FormFieldGroup> fieldGroupFilter = g -> true;

    public FormView(ObjectReader<T> objectReader) {
        this.objectReader = objectReader;
        this.getStyleClass().add((Object)"form-view");
        this.content = new VBox();
        this.content.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.content.setSpacing(5.0);
        this.getChildren().add((Object)this.content);
        this.formMode.set((Object)FormMode.NONE);
        this.formMode.addListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setFieldContainerFactory(Callback<ObjectReader.Field, FormFieldContainer> fieldFactory) {
        this.fieldFactory = fieldFactory;
    }

    public void setFieldGroupFactory(Callable<List<FormFieldGroup>> fieldGroupFactory) {
        this.fieldGroupFactory = fieldGroupFactory;
        this.createGroups();
    }

    private void createGroups() {
        this.groupList.clear();
        try {
            ((List)this.fieldGroupFactory.call()).stream().forEach(g -> this.groupList.add(g));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFormMode(FormMode formMode) {
        this.formMode.set((Object)formMode);
        this.setDisable(formMode == FormMode.NONE);
    }

    public FormMode getFormMode() {
        return (FormMode)this.formMode.get();
    }

    public ObjectProperty<FormMode> formModeProperty() {
        return this.formMode;
    }

    public void setModel(T object) {
        this.content.getChildren().clear();
        this.createGroups();
        this.objectReader.readFields(object).forEach(f -> {
            FormFieldContainer c = (FormFieldContainer)this.fieldFactory.call(f);
            if (c != null) {
                FormFieldGroup g = this.getGroup(c.getGroupId());
                if (g != null) {
                    g.addFieldContainer(c);
                } else {
                    FormFieldGroup propGrp = this.getGroup("properties-group");
                    if (propGrp == null) {
                        propGrp = new FormFieldGroup("properties-group", "", null, true);
                        this.groupList.add(0, propGrp);
                    }
                    propGrp.addFieldContainer(c);
                }
            }
        });
        List<FormFieldGroup> filteredGroupList = this.groupList.stream().filter(this.fieldGroupFilter::test).collect(Collectors.toList());
        if (filteredGroupList.size() == 1) {
            ((FormFieldGroup)filteredGroupList.get(0)).getFieldContainers().forEach(container -> this.content.getChildren().add(container));
        } else {
            filteredGroupList.forEach(g -> {
                if (g.getFields().size() > 0) {
                    this.content.getChildren().add(g);
                }
            });
        }
        this.model = object;
    }

    public T getModel() {
        return (T)this.model;
    }

    public void findField(Predicate<FormFieldContainer> p, Consumer<FormFieldContainer> fieldContainer) {
        this.groupList.stream().map(FormFieldGroup::getFieldContainers).forEach(containerList -> containerList.forEach(container -> {
            if (p.test((FormFieldContainer)container)) {
                fieldContainer.accept((FormFieldContainer)container);
            }
        }));
    }

    public <C> void findControl(String fieldId, Class<C> controlClass, Consumer<C> control) {
        this.findField(c -> c.getFieldId().equals(fieldId), c -> control.accept(controlClass.cast(c.getControl())));
    }

    public void findControl(String fieldId, Consumer<Control> control) {
        this.findField(c -> c.getFieldId().equals(fieldId), c -> control.accept(c.getControl()));
    }

    private FormFieldGroup getGroup(String groupId) {
        FormFieldGroup g = null;
        Iterator iterator = this.groupList.iterator();
        while (iterator.hasNext() && g == null) {
            FormFieldGroup tmp = (FormFieldGroup)iterator.next();
            if (!tmp.getGroupId().equals(groupId)) continue;
            g = tmp;
        }
        return g;
    }

    public void setFieldGroupFilter(Predicate<FormFieldGroup> group) {
        this.fieldGroupFilter = group;
    }

    public void requestFocus() {
        if (this.groupList.size() == 0) {
            return;
        }
        if (((FormFieldGroup)this.groupList.get(0)).getFields().size() == 0) {
            return;
        }
        ((FormFieldGroup)this.groupList.get(0)).getFields().stream().filter(f -> !f.isDisable()).findFirst().ifPresent(c -> c.requestFocus());
        Control c2 = null;
        Iterator iterator = this.groupList.iterator();
        while (iterator.hasNext() && c2 == null) {
            FormFieldGroup g = (FormFieldGroup)iterator.next();
            Iterator iterator2 = g.getFields().iterator();
            while (iterator2.hasNext() && c2 == null) {
                Control f2 = (Control)iterator2.next();
                if (f2.isDisable()) continue;
                c2 = f2;
            }
        }
        if (c2 != null) {
            c2.requestFocus();
        }
    }

    static /* synthetic */ EventHandler access$0(FormView formView) {
        return formView.stateChangedEventHandler;
    }
}

