/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.user;

import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.datarest.repository.RepositorySearch;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.fxml.annotation.Output;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.controller.RepoNavigationViewController;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;
import rs.tetrabyte.pezar.rest.RepoSearchBuilder;

@FXMLView(value="/fxml/user/UsersRolesView.fxml", wrappers={LockablePaneWrapper.class})
public class UsersRolesViewController
extends FXMLController {
    @FXML
    BorderPane perspectiveContainer;
    @FXML
    BorderPane navigationBox;
    @Autowired
    UICommands uiCommands;
    @Input
    Class<? extends FXMLController> tableControllerClass;
    @Input
    Class<? extends FXMLController> formControllerClass;
    @Input
    RepositoryFX<ResourceEntity> repository;
    @Input
    RepositorySearch initialSearch;
    @Output
    ObjectProperty<ResourceEntity> selectedResource = new SimpleObjectProperty();
    Node formView;
    Node focused;
    private Map<String, Object> params;

    @FXML
    void onNew(ActionEvent event) {
        this.repository.readTemplate(null);
        this.showForm();
    }

    @FXML
    void onEdit(ActionEvent event) {
        if (this.selectedResource.get() != null) {
            this.showForm();
            this.repository.readOne(((ResourceEntity)this.selectedResource.get()).getId());
        }
    }

    @FXML
    void onDelete(ActionEvent event) {
        this.uiCommands.showAlert().confirm().withMessage("%alert.delete.msg", new Object[0]).withTitle("%alert.delete.title", new Object[0]).onConfirmed(e -> {
            if (this.selectedResource.get() != null) {
                this.repository.delete((ResourceEntity)this.selectedResource.get());
            }
        }).execute();
    }

    @FXML
    void onRefresh(ActionEvent event) {
        this.repository.search(this.repository.getLastSearch());
    }

    @FXML
    void onPrevious(ActionEvent event) {
    }

    @FXML
    void onNext(ActionEvent event) {
    }

    public void initialize(URL location, ResourceBundle resources) {
        if (this.initialSearch == null) {
            this.initialSearch = RepoSearchBuilder.findAll();
        }
    }

    @PostConstruct
    private void setComponents() {
        ((LockablePane)this.getRootNode(LockablePane.class)).lockedProperty().bind((ObservableValue)this.repository.runningProperty());
        this.loadView(RepoNavigationViewController.class).prepare(arg_0 -> ((BorderPane)this.navigationBox).setCenter(arg_0)).loadView(this.tableControllerClass).output(new Object[]{this}).prepare(arg_0 -> ((BorderPane)this.perspectiveContainer).setCenter(arg_0)).loadView(this.formControllerClass).output(new Object[]{this}).prepare(view -> {
            Node node = this.formView = view;
        }).whenDone(() -> this.repository.search(this.initialSearch)).load();
    }

    @PostConstruct
    private void setRepository() {
        this.repository.addEventFilter(RepositoryFXEvent.SAVE_OK, e -> {
            this.hideForm();
            this.uiCommands.showNotification().success().withText("%msg.save-success", new Object[0]).withDuration(1).withPosition(Pos.CENTER).execute();
        });
        this.repository.addEventFilter(RepositoryFXEvent.READ_MANY_OK, e -> {
            if (!this.repository.containsLink("new")) {
                this.findNodeById("btn-new", Button.class).ifPresent(b -> b.setDisable(true));
            }
        });
    }

    private void showForm() {
        this.perspectiveContainer.setDisable(true);
        ((LockablePane)this.getRootNode(LockablePane.class)).addNodeOnTop(this.formView);
    }

    public void hideForm() {
        this.perspectiveContainer.setDisable(false);
        if (this.formView != null) {
            ((LockablePane)this.getRootNode(LockablePane.class)).popNode();
        }
    }

    public Map<String, Object> getParams() {
        return this.params;
    }
}

