/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.document;

import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resources;
import rs.tetrabyte.datamodel.uidescriptors.entity.DDetailDescriptor;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.Document;
import rs.tetrabyte.pezar.beans.DocumentSum;
import rs.tetrabyte.pezar.browser.DSummaryView;
import rs.tetrabyte.pezar.context.MessageService;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;
import rs.tetrabyte.task.UIAccessor;

@FXMLView(value="/fxml/browser/document/DSummaryView.fxml", wrappers={LockablePaneWrapper.class})
public class DTotalsController
extends FXMLController {
    @FXML
    private BorderPane content;
    @Input
    private RepositoryFX<Document> documentRepo;
    @Input(value="globalSummary")
    private List<DocumentSum> summary;
    @Autowired
    private RestTaskFactory restTaskFactory;
    @Autowired
    private MessageService messages;
    private DSummaryView summaryView;

    @PostConstruct
    private void initView(DDetailDescriptor descriptor) {
        this.summaryView = new DSummaryView(descriptor.getSummaryDescriptor(), this.messages);
        this.content.setCenter((Node)this.summaryView);
    }

    @PostConstruct
    private void configureReadMany() {
        this.documentRepo.addEventFilter(RepositoryFXEvent.READ_MANY_OK, e -> {
            Resources resources = (Resources)e.getValue();
            Link summaryLink = resources.getLink("summary");
            this.restTaskFactory.createTask(client -> client.getList(summaryLink, DocumentSum.class)).uiAccessor((UIAccessor)this.getRootNode(LockablePane.class)).whenDone(summary -> {
                this.summary.clear();
                this.summary.addAll(summary);
                this.summaryView.setModel(summary);
            }).execute();
        });
    }
}

