/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.document;

import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Resources;
import rs.tetrabyte.datamodel.uidescriptors.entity.DDetailDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.EBrowserDescriptor;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.AbstractEntity;
import rs.tetrabyte.pezar.beans.Document;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.rest.RepoSearchBuilder;

@FXMLView(value="/fxml/browser/document/DTablePerspective.fxml")
public class DTablePerspectiveController
extends FXMLController {
    @FXML
    private HBox container;
    @FXML
    private TreeTableView<Document> tableView;
    @FXML
    private BorderPane attributeSearchPane;
    @FXML
    private TextField txtSearch;
    @FXML
    private Button btnSearch;
    @Autowired
    private ControlsFactoryService cfs;
    @Input
    private RepositoryFX<AbstractEntity> repository;
    @Input
    private ObjectProperty<Document> selectedDocument;
    @Input
    private EBrowserDescriptor browserDescriptor;
    @Input
    private EventHandler<Event> onAction;
    @Input
    private DDetailDescriptor detailDescriptor;

    @FXML
    public void onKeywordSearch(ActionEvent event) {
        this.searchByKeywords();
    }

    public void initialize(URL location, ResourceBundle resources) {
        String tableId = String.format("browser-table-%s-%s", this.browserDescriptor.getRepository(), this.browserDescriptor.getDiscriminator());
        this.tableView.setId(tableId);
        this.tableView.setRoot(new TreeItem());
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ENTER && this.tableView.getEditingCell() == null) {
                this.onAction.handle(e);
            } else if (e.getCode() == KeyCode.UP && (this.tableView.getSelectionModel().getSelectedIndex() == 0 || this.tableView.getSelectionModel().getSelectedIndex() == -1)) {
                this.txtSearch.requestFocus();
            }
        });
        this.tableView.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getClickCount() == 2 && this.tableView.getSelectionModel().getSelectedItem() != null) {
                this.onAction.handle(e);
            }
        });
        this.txtSearch.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.DOWN) {
                this.tableView.requestFocus();
            }
            if (e.getCode() == KeyCode.ENTER) {
                this.searchByKeywords();
            }
        });
        this.tableView.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            if (nv != null) {
                this.selectedDocument.set((Object)((Document)nv.getValue()));
            }
        });
    }

    @PostConstruct
    protected void createColumns() {
        this.tableView.getColumns().addAll((Collection)this.cfs.createTreeTableColumns(this.browserDescriptor.getTable()));
        this.tableView.getColumns().addAll((Collection)this.cfs.createTreeTableColumns(this.detailDescriptor.getSummaryDescriptor()));
    }

    @PostConstruct
    protected void requestFocus() {
        if (!this.txtSearch.isDisabled()) {
            this.txtSearch.requestFocus();
        } else {
            this.tableView.requestFocus();
        }
    }

    @PostConstruct
    protected void configureReadMany() {
        this.repository.addEventFilter(RepositoryFXEvent.READ_MANY_OK, e -> {
            Resources resources = (Resources)e.getValue();
            this.tableView.getRoot().getChildren().clear();
            if (resources != null && resources.getContent().size() > 0) {
                this.tableView.getRoot().getChildren().addAll((Collection)resources.getContent().stream().map(TreeItem::new).collect(Collectors.toList()));
                this.tableView.getSelectionModel().select(0);
                this.tableView.requestFocus();
            }
        });
    }

    @PostConstruct
    protected void configureReadOne() {
        this.repository.addEventFilter(RepositoryFXEvent.READ_ONE_OK, e -> {
            Document document = (Document)e.getValue();
            this.tableView.getRoot().getChildren().stream().filter(item -> ((Document)item.getValue()).getId().equals((Object)document.getId())).findFirst().ifPresent(item -> item.setValue((Object)document));
        });
    }

    @PostConstruct
    protected void configureInsert() {
        this.repository.addEventFilter(RepositoryFXEvent.INSERT_OK, e -> {
            TreeItem newItem = new TreeItem((Object)((Document)e.getValue()));
            this.tableView.getRoot().getChildren().add((Object)newItem);
            this.tableView.getSelectionModel().select((Object)newItem);
        });
    }

    @PostConstruct
    protected void configureUpdate() {
        this.repository.addEventFilter(RepositoryFXEvent.UPDATE_OK, e -> ((TreeItem)this.tableView.getSelectionModel().getSelectedItem()).setValue((Object)((Document)e.getValue())));
    }

    @PostConstruct
    protected void configureRefresh() {
        this.repository.addEventFilter(RepositoryFXEvent.REFRESH, e -> {
            TreeItem item = this.findItem((Document)e.getValue(), (Collection)this.tableView.getRoot().getChildren());
            if (item != null) {
                item.setValue((Object)((Document)e.getValue()));
            }
        });
    }

    @PostConstruct
    protected void configureDelete() {
        this.repository.addEventFilter(RepositoryFXEvent.DELETE_OK, e -> {
            TreeItem item = this.findItem((Document)e.getValue(), (Collection)this.tableView.getRoot().getChildren());
            this.tableView.getRoot().getChildren().remove((Object)item);
        });
    }

    @PostConstruct
    private void configureRepositorySearchUI() {
        if (!this.repository.supportsSearch("keywords")) {
            this.txtSearch.setDisable(true);
            this.btnSearch.setDisable(true);
        }
    }

    protected TreeItem<Document> findItem(Document entity, Collection<TreeItem<Document>> collection) {
        TreeItem result = null;
        for (TreeItem treeItem : collection) {
            TreeItem treeItem1;
            if (((Document)treeItem.getValue()).getId().equals((Object)entity.getId())) {
                result = treeItem;
                break;
            }
            if (treeItem.getChildren().size() <= 0 || (treeItem1 = this.findItem(entity, (Collection)treeItem.getChildren())) == null) continue;
            result = treeItem1;
        }
        return result;
    }

    private void searchByKeywords() {
        this.repository.search(RepoSearchBuilder.byKeywords((String)StringUtils.join((Object[])this.txtSearch.getText().split("\\s+"), (String)",")));
    }

    protected TreeTableView<Document> getTableView() {
        return this.tableView;
    }
}

