/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser.document;

import java.util.ArrayList;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datamodel.uidescriptors.entity.DLineDescriptor;
import rs.tetrabyte.datamodel.uidescriptors.entity.EFormDescriptor;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.fx.RepositoryFXEvent;
import rs.tetrabyte.fxml.Output;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.Document;
import rs.tetrabyte.pezar.beans.DocumentLine;
import rs.tetrabyte.pezar.beans.Inventory;
import rs.tetrabyte.pezar.context.ControlsFactoryService;
import rs.tetrabyte.pezar.context.MessageService;
import rs.tetrabyte.pezar.controller.browser.document.DLinesTableViewController;
import rs.tetrabyte.pezar.controller.extension.ExtensibleViewController;
import rs.tetrabyte.pezar.custom.FormView;
import rs.tetrabyte.pezar.custom.FormWrapper;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;
import rs.tetrabyte.pezar.custom.ReferenceFieldBrowserSupport;
import rs.tetrabyte.pezar.factory.GlyphFactory;

@FXMLView(value="/fxml/browser/document/DLineFormView.fxml", wrappers={FormWrapper.class, LockablePaneWrapper.class})
public class DLineFormViewController
extends ExtensibleViewController {
    @FXML
    private ScrollPane content;
    @FXML
    private ScrollPane extension;
    @FXML
    private Label lblEntity;
    @Autowired
    private ControlsFactoryService cfs;
    @Autowired
    private MessageService messages;
    @Input(value="lineRepository")
    private ObjectProperty<RepositoryFX<DocumentLine>> repository;
    @Input
    private DLinesTableViewController parentController;
    @Input
    private DLineDescriptor lineDescriptor;
    @Input
    private ObjectProperty<Document> selectedDocument;
    private FormView<DocumentLine> formView;
    private int modelHashCode;

    @FXML
    public void onSave(ActionEvent event) {
        if (this.formView != null && this.cfs.validateOnDemand((Node)this.formView)) {
            DocumentLine model = (DocumentLine)this.formView.getModel();
            if (this.formView.getFormMode() == FormView.FormMode.INSERT) {
                ((RepositoryFX)this.repository.get()).insert((ResourceEntity)model);
            } else if (this.formView.getFormMode() == FormView.FormMode.UPDATE) {
                if (this.modelHashCode != ((DocumentLine)this.formView.getModel()).hashCode()) {
                    ((RepositoryFX)this.repository.get()).update((ResourceEntity)model);
                } else {
                    this.parentController.hideForm();
                }
            }
        }
    }

    @FXML
    public void onCancel(ActionEvent event) {
        this.parentController.hideForm();
    }

    @PostConstruct
    private void initView() {
        this.lblEntity.setGraphic(GlyphFactory.createGlyph((String)this.lineDescriptor.getGlyph()));
        this.lblEntity.setText(this.messages.getMessage(this.lineDescriptor.getLabel(), new Object[0]));
    }

    @PostConstruct
    private void configureRepository() {
        this.repository.addListener((o, ov, nv) -> {
            ChangeListener changeListener = (o1, ov1, nv1) -> ((LockablePane)this.getRootNode(LockablePane.class)).setLocked(nv1.booleanValue());
            nv.runningProperty().addListener(changeListener);
            nv.addEventFilter(RepositoryFXEvent.READ_TEMPLATE_OK, e -> {
                DocumentLine value = (DocumentLine)e.getValue();
                this.createForm(FormView.FormMode.INSERT, value);
            });
            nv.addEventFilter(RepositoryFXEvent.READ_ONE_OK, e -> {
                DocumentLine value = (DocumentLine)e.getValue();
                this.createForm(FormView.FormMode.UPDATE, value);
                if (this.formView != null) {
                    Platform.runLater(() -> {
                        boolean bl = this.cfs.validateOnDemand((Node)this.formView);
                    });
                }
            });
        });
    }

    private void createForm(FormView.FormMode formMode, DocumentLine resource) {
        EFormDescriptor formDescriptor = this.lineDescriptor.getForm();
        this.formView = this.cfs.createFormView(formDescriptor);
        this.formView.setFormMode(formMode);
        this.formView.setModel((Object)resource);
        Document selectedDocument = (Document)this.selectedDocument.get();
        Output out = new Output();
        ArrayList inventories = new ArrayList();
        selectedDocument.getInventories().forEach(link -> {
            boolean bl = inventories.add((Inventory)link.getRelatedEntity("reference", Inventory.class));
        });
        out.and("inventories", inventories);
        if (inventories.size() > 0) {
            out.and("inventory", inventories.get(0));
        }
        this.formView.findField(container -> container.getControl() instanceof ReferenceFieldBrowserSupport, container -> ((ReferenceFieldBrowserSupport)container.getControl()).setOutput(out));
        this.modelHashCode = resource.hashCode();
        this.content.setContent((Node)this.formView);
        this.loadExtension(formDescriptor.getFormId()).ifPresent(ext -> ext.output(new Object[]{this.formView}).output("parentView", (Object)this.getRootNode(LockablePane.class)).output(out).get(view -> {
            if (this.extension != null) {
                this.extension.setContent(view);
            }
        }));
    }
}

