/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller.browser;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javax.annotation.PostConstruct;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.repository.RepositorySearch;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;
import rs.tetrabyte.pezar.beans.Inventory;
import rs.tetrabyte.pezar.beans.Item;
import rs.tetrabyte.pezar.controller.browser.EBrowserController;
import rs.tetrabyte.pezar.controller.browser.ItemBrowserTablePerspectiveController;
import rs.tetrabyte.pezar.custom.LockablePaneWrapper;

@FXMLView(value="/fxml/browser/ItemBrowserView.fxml", wrappers={LockablePaneWrapper.class})
public class ItemBrowserController
extends EBrowserController {
    @Input
    private RepositoryFX<Item> repository;
    @Input
    private Inventory inventory;

    public void initialize(URL location, ResourceBundle resources) {
        super.initialize(location, resources);
        this.setPerspectiveControllerClass(ItemBrowserTablePerspectiveController.class);
    }

    @FXML
    public void onAnalytics(ActionEvent event) {
    }

    @FXML
    public void onAsc(ActionEvent event) {
    }

    @FXML
    public void onDesc(ActionEvent event) {
    }

    @PostConstruct
    private void setRepositoryParam() {
        if (this.inventory != null) {
            this.repository.staticParam("inv", (Object)this.inventory.parseId());
        }
    }

    public void onOpened() {
        if (this.inventory == null) {
            return;
        }
        String inventoryId = (String)this.repository.getStaticParams().asMap().get("inv");
        if (!this.inventory.parseId().equals(inventoryId)) {
            this.repository.staticParam("inv", (Object)this.inventory.parseId());
            RepositorySearch search = null;
            if (this.repository.getLastSearch() != null) {
                search = this.repository.getLastSearch();
                search.getParams().param("inv", (Object)this.inventory.parseId());
            }
            this.repository.search(search);
        }
        super.onOpened();
    }
}

