/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.controller;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javax.annotation.PostConstruct;
import rs.tetrabyte.datarest.client.ResourceEntity;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.annotation.FXMLView;
import rs.tetrabyte.fxml.annotation.Input;

@FXMLView(value="/fxml/RepoNavigationView.fxml")
public class RepoNavigationViewController
extends FXMLController {
    @FXML
    private Label lblTotalResults;
    @FXML
    private HBox paginationBox;
    @FXML
    private Label lblTotalPages;
    @FXML
    private Button btnPrevious;
    @FXML
    private Button btnNext;
    @FXML
    private ComboBox<String> cbResultsPerPage;
    @Input
    private RepositoryFX<ResourceEntity> repository;

    public void initialize(URL location, ResourceBundle resources) {
        if (!this.repository.isPaged()) {
            this.paginationBox.setVisible(false);
            this.lblTotalResults.textProperty().bind((ObservableValue)this.repository.getResponseCollection().resultListProperty().sizeProperty().asString());
        } else {
            this.btnPrevious.disableProperty().bind((ObservableValue)this.repository.getResponseCollection().hasPreviousPageProperty().not());
            this.btnNext.disableProperty().bind((ObservableValue)this.repository.getResponseCollection().hasNextPageProperty().not());
            this.lblTotalPages.textProperty().bind((ObservableValue)this.repository.getResponseCollection().totalPagesProperty().asString());
            this.lblTotalResults.textProperty().bind((ObservableValue)this.repository.getResponseCollection().totalElementsProperty().asString());
        }
        this.cbResultsPerPage.getItems().addAll((Object[])new String[]{"50", "100"});
        this.cbResultsPerPage.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            this.repository.staticParam("size", nv);
            this.repository.search(this.repository.getLastSearch());
        });
    }

    @PostConstruct
    private void postconstruct() {
        this.cbResultsPerPage.getSelectionModel().select(0);
    }

    @FXML
    public void onPrevious(ActionEvent event) {
        this.repository.followLink(this.repository.getResponseCollection().getLinkToPrevPage());
    }

    @FXML
    public void onNext(ActionEvent event) {
        this.repository.followLink(this.repository.getResponseCollection().getLinkToNextPage());
    }
}

