/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Resources;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.beans.Role;
import rs.tetrabyte.pezar.beans.User;
import rs.tetrabyte.pezar.context.TenantContext;

public class UserService {
    @Autowired
    private TenantContext tenantContext;
    @Autowired
    private RestClient client;
    private String username;
    private User userInfo;
    private List<Role> roles;

    public void refreshUserData(String username) {
        User user = (User)this.client.getSingle(this.client.pathBuilder().root().slash("users").slash(username).get(), User.class);
        this.username = username;
        this.setUser(user);
    }

    private void setUser(User user) {
        this.userInfo = user;
        Resources resources = this.client.getResources(user.getLink("roles"), Role.class);
        this.roles = resources.getContent().stream().map(resource -> resource).collect(Collectors.toList());
    }

    public Role getActiveRole() {
        if (this.isSuperUser()) {
            return (Role)this.roles.get(0);
        }
        return this.roles.stream().filter(role -> role.getResidentId().equals(((Resident)this.tenantContext.getActiveResident().get()).getResidentId())).findFirst().get();
    }

    public String getUsername() {
        return this.username;
    }

    public User getLoggedUser() {
        return this.userInfo;
    }

    public boolean isSuperUser() {
        return this.roles.stream().filter(role -> role.getLevel().equals("ROLE_SUPERUSER")).findFirst().isPresent();
    }

    public boolean isAdmin() {
        return this.roles.stream().filter(role -> role.getLevel().equals("ROLE_ADMIN") && role.getResidentId().equals(((Resident)this.tenantContext.getActiveResident().get()).getResidentId())).findFirst().isPresent();
    }
}

