/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import com.google.common.eventbus.EventBus;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datarest.client.RestClient;
import rs.tetrabyte.datarest.context.DataRestContext;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.commons.constant.TenantParams;
import rs.tetrabyte.pezar.context.data.Server;
import rs.tetrabyte.pezar.event.ServerChanged;
import rs.tetrabyte.pezar.event.TenantChanged;

public class TenantContext {
    private static Logger logger = LoggerFactory.getLogger(TenantContext.class);
    @Autowired
    private EventBus eventBus;
    @Autowired
    private RestClient client;
    @Autowired
    private DataRestContext datarestContext;
    private String residentId;
    private String year;
    private ObservableList<Resident> residents = FXCollections.observableArrayList();
    private Server server;

    public String getActiveYear() {
        return this.year;
    }

    public void setTenant(String residentId, String year) {
        if (!residentId.equals(this.residentId) || !year.equals(this.year)) {
            TenantChanged tenant = new TenantChanged(residentId, year);
            tenant.setOldValue(new TenantChanged(this.residentId, this.year));
            logger.info("Tenant changed: " + tenant);
            if (!residentId.equals(this.residentId)) {
                this.residentId = residentId;
                tenant.setResidentId(residentId);
                tenant.setYear(year);
            }
            if (!year.equals(this.year)) {
                this.year = year;
                tenant.setYear(year);
            }
            this.client.putTrailingParam(TenantParams.RESIDENT, (Object)tenant.getResidentId());
            this.client.putTrailingParam(TenantParams.YEAR, (Object)tenant.getYear());
            this.client.putTrailingParam("lang", (Object)this.server.getLocale());
            this.eventBus.post((Object)tenant);
        }
    }

    public void reset() {
        this.residentId = null;
        this.year = null;
    }

    public void setResidents(Collection<Resident> residents) {
        this.residents.clear();
        this.residents.setAll(residents);
    }

    public ObservableList<Resident> getResidents() {
        return this.residents;
    }

    public Optional<Resident> getActiveResident() {
        return this.residents.stream().filter(r -> this.residentId.equals(r.getResidentId())).findFirst();
    }

    public void setActiveServer(Server server) {
        this.server = server;
        try {
            this.datarestContext.init(new URI(server.getUrl()), "core");
        }
        catch (URISyntaxException e) {
            logger.error("Could not set base URI", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        logger.info("Server changed: " + server);
        this.eventBus.post((Object)new ServerChanged(server));
    }

    public Optional<Server> getActiveServer() {
        return Optional.ofNullable(this.server);
    }
}

