/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import com.google.common.eventbus.Subscribe;
import org.controlsfx.control.Notifications;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.commands.ShowNotification;
import rs.tetrabyte.pezar.custom.screen.Screen;

public class NotificationService {
    private Screen screen;
    private LocaleContext localeContext;

    public NotificationService(Screen screen, LocaleContext localeContext) {
        this.screen = screen;
        this.localeContext = localeContext;
    }

    @Subscribe
    private void showNotification(ShowNotification ntf) {
        String text = ntf.getText();
        String title = ntf.getTitle();
        if (text != null && text.startsWith("%")) {
            text = this.localeContext.getMessage(text.substring(1, text.length()), ntf.getTextArgs());
        }
        if (title != null && title.startsWith("%")) {
            title = this.localeContext.getMessage(title.substring(1, title.length()), ntf.getTitleArgs());
        }
        Notifications n = Notifications.create().graphic(ntf.getGraphic()).hideAfter(ntf.getHideAfterDuration()).owner((Object)this.screen).position(ntf.getPosition()).text(text).title(title);
        if (!ntf.isClosable()) {
            n.hideCloseButton();
        }
        n.show();
    }
}

