/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import com.google.common.eventbus.EventBus;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import rs.tetrabyte.datarest.client.RestContext;
import rs.tetrabyte.datarest.task.RestTaskFactory;
import rs.tetrabyte.pezar.beans.Resident;
import rs.tetrabyte.pezar.commons.message.AccountChangeNotification;
import rs.tetrabyte.pezar.commons.message.UserStatusNotification;
import rs.tetrabyte.pezar.context.LogInService;
import rs.tetrabyte.pezar.context.TenantContext;
import rs.tetrabyte.pezar.context.UserService;
import rs.tetrabyte.pezar.context.data.Server;
import rs.tetrabyte.pezar.event.TenantChanged;
import rs.tetrabyte.pezar.event.UserLoggedIn;
import rs.tetrabyte.pezar.event.UserLoggedOut;
import rs.tetrabyte.pezar.exception.ExceptionHandlerImpl;
import rs.tetrabyte.pezar.websocket.WebSocketService;

public class LogInService {
    private static Logger logger = LoggerFactory.getLogger(UserService.class);
    @Autowired
    private TenantContext tenantContext;
    @Autowired
    private RestContext restTemplateContext;
    @Autowired
    private ExceptionHandlerImpl exceptionHandler;
    @Autowired
    private RestTaskFactory restTaskFactory;
    @Autowired
    private UserService userService;
    @Autowired
    private EventBus eventBus;
    @Autowired
    private WebSocketService webSocketService;
    private String username;

    public void login(String username, String password, LoginHandler handler) {
        this.username = username;
        1 t = new /* Unavailable Anonymous Inner Class!! */;
        if (handler != null) {
            t.setOnSucceeded(e -> {
                logger.info("User logged in: " + username);
                this.restTaskFactory.createTask(client -> client.getResources(client.pathBuilder().base().slash("account/residents").get(), Resident.class).getContent()).whenDone(residents -> {
                    this.configureWebSocket(((Server)this.tenantContext.getActiveServer().get()).getUrl());
                    this.handleResidents(residents);
                    handler.onSuccess();
                    this.eventBus.post((Object)new UserLoggedIn(username));
                }).execute();
            });
            t.setOnFailed(arg_0 -> this.lambda$1((Task)t, username, handler, arg_0));
        }
        Thread t1 = new Thread((Runnable)t);
        t1.setDaemon(false);
        t1.start();
    }

    private void handleResidents(Collection<Resident> residents) {
        residents.stream().filter(r -> r.isDefaultResident()).findFirst().ifPresent(r -> {
            r.getYears().sort((o1, o2) -> -o1.compareTo((String)o2));
            this.tenantContext.setResidents((Collection)residents.stream().collect(Collectors.toList()));
            this.tenantContext.setTenant(r.getResidentId(), (String)r.getYears().get(0));
        });
    }

    private void configureWebSocket(String serverUrl) {
        this.webSocketService.connect(serverUrl, () -> {
            this.webSocketService.sendUserStatus(new UserStatusNotification(this.username, UserStatusNotification.Status.LOG_IN));
            this.webSocketService.getNotificationHandler().registerDestination("/topic/notifications-account-changed", AccountChangeNotification.class).createSubscription().onPayloadRecieved(notif -> {
                if (notif.getChange() == AccountChangeNotification.Change.USER) {
                    if (this.username.equals(notif.getId())) {
                        this.userService.refreshUserData(this.username);
                    }
                } else if (notif.getChange() == AccountChangeNotification.Change.ROLE && this.userService.getActiveRole().getRoleId() == Long.parseLong(notif.getId())) {
                    TenantChanged evt = new TenantChanged();
                    evt.setResidentId(((Resident)this.tenantContext.getActiveResident().get()).getResidentId());
                    evt.setYear(this.tenantContext.getActiveYear());
                    this.eventBus.post((Object)evt);
                }
            });
        });
    }

    public void logout() {
        if (this.username == null) {
            return;
        }
        this.restTemplateContext.resetTemplate();
        logger.info("User logged out: " + this.username);
        this.webSocketService.sendUserStatus(new UserStatusNotification(this.username, UserStatusNotification.Status.LOG_OUT));
        this.webSocketService.getNotificationHandler().unregisterDestination("/topic/notifications-account-changed");
        this.webSocketService.disconnectSessions();
        this.eventBus.post((Object)new UserLoggedOut(this.username));
        this.username = null;
    }

    static /* synthetic */ RestContext access$0(LogInService logInService) {
        return logInService.restTemplateContext;
    }

    static /* synthetic */ UserService access$1(LogInService logInService) {
        return logInService.userService;
    }

    private /* synthetic */ void lambda$1(Task task, String string, LoginHandler loginHandler, WorkerStateEvent e) {
        if (task.getException() instanceof OAuth2AccessDeniedException) {
            logger.info(String.format("Login failed for user '%s'. Access denided.", string));
            loginHandler.onFail();
        } else {
            logger.info(String.format("Login failed for user '%s' because of an unexpected error.", string));
            this.exceptionHandler.handle(task.getException());
        }
    }
}

