/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.task.TaskFactory;

public class FocusService {
    private static final Logger logger = LoggerFactory.getLogger(FocusService.class);
    private Scene scene;
    @Autowired
    private TaskFactory taskFactory;

    public void setScene(Scene scene) {
        this.scene = scene;
        this.scene.focusOwnerProperty().addListener((o, ov, nv) -> logger.debug("Focus: " + nv));
    }

    public Node getFocusedNode() {
        return this.scene.getFocusOwner();
    }

    private void setFocus(Node node, long delay) {
        if (node == null) {
            return;
        }
        this.taskFactory.createTask(() -> {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (node instanceof Parent) {
                return this.findFirstControl((Parent)node);
            }
            return Optional.of(node);
        }).whenDone(ctrl -> ctrl.ifPresent(c -> {
            logger.debug("Setting focus on: " + c);
            Platform.runLater(() -> c.requestFocus());
        })).execute();
    }

    public void setFocus(Node node) {
        this.setFocus(node, 100L);
    }

    private Optional<Node> findFirstControl(Parent parent) {
        if (parent == null) {
            return Optional.empty();
        }
        for (Node node : parent.getChildrenUnmodifiable()) {
            Optional c;
            if (node.isFocusTraversable() && !node.isDisabled()) {
                return Optional.of(node);
            }
            if (!(node instanceof Parent) || !(c = this.findFirstControl((Parent)node)).isPresent()) continue;
            return c;
        }
        return Optional.empty();
    }
}

