/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.context;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.tetrabyte.pezar.custom.LockablePane;
import rs.tetrabyte.pezar.custom.accelerable.Accelerable;
import rs.tetrabyte.pezar.custom.screen.Screen;

/*
 * Exception performing whole class analysis ignored.
 */
public class AcceleratorService {
    private static Logger logger = LoggerFactory.getLogger(AcceleratorService.class);
    private static final double JAVA_VERSION = Double.parseDouble(System.getProperty("java.specification.version"));
    private Scene scene;
    private Screen screen;
    private Map<KeyCombination, Runnable> active = new ConcurrentHashMap();

    public void setScene(Scene scene) {
        this.scene = scene;
        this.screen = (Screen)scene.getRoot();
        this.applyWorkaround();
    }

    private void applyWorkaround() {
        EventHandler eventHandler1 = this.createEventHandler1();
        this.scene.focusOwnerProperty().addListener((o, ov, nv) -> {
            if (nv instanceof TableView || nv instanceof TreeTableView || nv instanceof ListView) {
                nv.addEventFilter(KeyEvent.KEY_PRESSED, eventHandler1);
            }
            if (ov instanceof TableView || ov instanceof TreeTableView || ov instanceof ListView) {
                ov.removeEventFilter(KeyEvent.KEY_PRESSED, eventHandler1);
            }
        });
        if (JAVA_VERSION < 9.0) {
            EventHandler eventHandler2 = this.createEventHandler2();
            this.scene.focusOwnerProperty().addListener((o, ov, nv) -> {
                if (nv instanceof TextField) {
                    nv.addEventFilter(KeyEvent.KEY_PRESSED, eventHandler2);
                }
                if (ov instanceof TextField) {
                    ov.removeEventFilter(KeyEvent.KEY_PRESSED, eventHandler2);
                }
            });
        }
    }

    private EventHandler<KeyEvent> createEventHandler1() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private EventHandler<KeyEvent> createEventHandler2() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void refresh() {
        this.screen.getFrontLayer().ifPresent(frontLayer -> {
            this.clear();
            this.activate(AcceleratorService.findAccelerators((Node)frontLayer));
        });
    }

    public void set(Node node) {
        this.clear();
        this.activate(AcceleratorService.findAccelerators((Node)node));
    }

    private void clear() {
        try {
            this.active.clear();
            Platform.runLater(() -> this.scene.getAccelerators().clear());
            logger.debug("All accelerators removed");
        }
        catch (ConcurrentModificationException e) {
            try {
                Thread.sleep(100L);
                this.clear();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private void activate(Map<KeyCombination, Runnable> accelerators) {
        if (accelerators.isEmpty()) {
            return;
        }
        String activeAccelerators = String.join((CharSequence)", ", accelerators.entrySet().stream().map(e -> ((KeyCombination)e.getKey()).toString()).collect(Collectors.toList()));
        logger.debug("Active accelerators: " + activeAccelerators);
        this.active.putAll(accelerators);
        Platform.runLater(() -> this.scene.getAccelerators().putAll(this.active));
    }

    private static List<Accelerable> findAccelerables(Object node) {
        ArrayList<Accelerable> accelerables = new ArrayList<Accelerable>();
        if (node instanceof Accelerable) {
            accelerables.add((Accelerable)node);
            if (node instanceof Parent) {
                ((Parent)node).getChildrenUnmodifiable().forEach(childNode -> accelerables.addAll(AcceleratorService.findAccelerables((Object)childNode)));
            }
        } else if (node instanceof Parent) {
            accelerables.addAll(AcceleratorService.findAccelerables((Parent)((Parent)node)));
        }
        return accelerables;
    }

    private static List<Accelerable> findAccelerables(Parent node) {
        ArrayList<Accelerable> accelerables = new ArrayList<Accelerable>();
        if (node instanceof LockablePane) {
            LockablePane lockable = (LockablePane)node;
            lockable.getFrontLayer().ifPresent(frontLayer -> {
                boolean bl = accelerables.addAll(AcceleratorService.findAccelerables((Object)frontLayer));
            });
        } else if (node instanceof StackPane) {
            StackPane stackPane = (StackPane)node;
            if (stackPane.getChildren().size() > 0) {
                accelerables.addAll(AcceleratorService.findAccelerables((Object)stackPane.getChildren().get(stackPane.getChildren().size() - 1)));
            }
        } else if (node instanceof ToolBar) {
            ToolBar toolbar = (ToolBar)node;
            toolbar.getItems().forEach(items -> accelerables.addAll(AcceleratorService.findAccelerables((Object)items)));
        } else if (node instanceof ButtonBar) {
            ButtonBar buttonBar = (ButtonBar)node;
            buttonBar.getButtons().forEach(button -> {
                boolean bl = accelerables.addAll(AcceleratorService.findAccelerables((Object)button));
            });
        } else if (node instanceof TitledPane) {
            TitledPane titledPane = (TitledPane)node;
            accelerables.addAll(AcceleratorService.findAccelerables((Object)titledPane.getContent()));
        } else if (node instanceof TabPane) {
            TabPane tabPane = (TabPane)node;
            tabPane.getTabs().forEach(tab -> {
                boolean bl = accelerables.addAll(AcceleratorService.findAccelerables((Object)tab));
            });
            accelerables.addAll(AcceleratorService.findAccelerables((Object)((Tab)tabPane.getSelectionModel().getSelectedItem()).getContent()));
        } else {
            node.getChildrenUnmodifiable().forEach(child -> accelerables.addAll(AcceleratorService.findAccelerables((Object)child)));
        }
        return accelerables;
    }

    private static Map<KeyCombination, Runnable> findAccelerators(Node node) {
        List accelerables = AcceleratorService.findAccelerables((Object)node);
        HashMap<KeyCombination, Runnable> accelerators = new HashMap<KeyCombination, Runnable>();
        accelerables.forEach(accelerable -> {
            if (StringUtils.isEmpty((CharSequence)accelerable.getAcceleratorString())) {
                return;
            }
            accelerators.put(KeyCombination.keyCombination((String)accelerable.getAcceleratorString()), () -> {
                logger.debug("Accelerator triggered: " + accelerable.getAcceleratorString());
                if (accelerable instanceof Button) {
                    Button b = (Button)accelerable;
                    if (b.isFocusTraversable()) {
                        b.requestFocus();
                    }
                    b.fire();
                } else if (accelerable instanceof MenuItem) {
                    ((MenuItem)accelerable).fire();
                } else if (accelerable instanceof Label) {
                    if (((Label)accelerable).getLabelFor() != null) {
                        ((Label)accelerable).getLabelFor().requestFocus();
                    }
                } else if (accelerable instanceof Tab) {
                    ((Tab)accelerable).getTabPane().getSelectionModel().select((Object)((Tab)accelerable));
                }
            });
        });
        return accelerators;
    }

    static /* synthetic */ Map access$0(AcceleratorService acceleratorService) {
        return acceleratorService.active;
    }
}

