/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.commands;

import com.google.common.eventbus.EventBus;
import javafx.scene.Node;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import rs.tetrabyte.pezar.commands.AddFeature;
import rs.tetrabyte.pezar.commands.ClearFeatures;
import rs.tetrabyte.pezar.commands.ClearScreen;
import rs.tetrabyte.pezar.commands.DisplayContent;
import rs.tetrabyte.pezar.commands.LockUI;
import rs.tetrabyte.pezar.commands.OpenBrowser;
import rs.tetrabyte.pezar.commands.PopContent;
import rs.tetrabyte.pezar.commands.RemoveView;
import rs.tetrabyte.pezar.commands.ShowAlert;
import rs.tetrabyte.pezar.commands.ShowDialog;
import rs.tetrabyte.pezar.commands.ShowNotification;
import rs.tetrabyte.pezar.commands.UICommandFactory;
import rs.tetrabyte.pezar.commands.UnlockUI;
import rs.tetrabyte.pezar.features.UIFeature;

public class UICommands {
    private UICommandFactory factory;

    public UICommands(EventBus eventBus, AutowireCapableBeanFactory beanFactory) {
        this.factory = new UICommandFactory(eventBus, beanFactory);
    }

    public AddFeature addFeature(UIFeature feature) {
        return ((AddFeature)this.factory.createCommand(AddFeature.class)).feature(feature);
    }

    public DisplayContent displayContent(Node content) {
        return ((DisplayContent)this.factory.createCommand(DisplayContent.class)).content(content);
    }

    public PopContent popContent() {
        return (PopContent)this.factory.createCommand(PopContent.class);
    }

    public ClearFeatures clearFeatures() {
        return (ClearFeatures)this.factory.createCommand(ClearFeatures.class);
    }

    public LockUI lockUI() {
        return (LockUI)this.factory.createCommand(LockUI.class);
    }

    public UnlockUI unLockUI() {
        return (UnlockUI)this.factory.createCommand(UnlockUI.class);
    }

    public OpenBrowser openBrowser(String browserId) {
        return ((OpenBrowser)this.factory.createCommand(OpenBrowser.class)).withBrowserId(browserId);
    }

    public ClearScreen clearScreen() {
        return (ClearScreen)this.factory.createCommand(ClearScreen.class);
    }

    public ShowNotification showNotification() {
        return (ShowNotification)this.factory.createCommand(ShowNotification.class);
    }

    public ShowAlert showAlert() {
        return (ShowAlert)this.factory.createCommand(ShowAlert.class);
    }

    public <T> ShowDialog<T> showDialog(Class<T> valueClass) {
        return ((ShowDialog)this.factory.createCommand(ShowDialog.class)).withValueClass(valueClass);
    }

    public RemoveView removeView(Node view) {
        return ((RemoveView)this.factory.createCommand(RemoveView.class)).withView(view);
    }
}

