/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.fxml.LocaleContext;
import rs.tetrabyte.pezar.commands.RemoveView;
import rs.tetrabyte.pezar.commands.UICommand;
import rs.tetrabyte.pezar.custom.dialog.PFXDialog;
import rs.tetrabyte.pezar.custom.screen.Screen;
import rs.tetrabyte.pezar.factory.ButtonFactory;
import rs.tetrabyte.pezar.fxml.factory.PFXButtonBuilder;

public class ShowDialog<T>
extends UICommand {
    private static final String NAME = "show-dialog";
    @Autowired
    private ButtonFactory buttonFactory;
    @Autowired
    private LocaleContext localeContext;
    @Autowired
    private Screen screen;
    private String title;
    private Node graphic;
    private Node content;
    private int width;
    private int height;
    private List<Button> buttons = new ArrayList();
    private PFXDialog<T> dialog;
    Class<T> valueClass;
    private Consumer<PFXDialog<T>> onValueSet;
    private Consumer<PFXDialog<T>> onOpened;
    private Object[] titleArgs;

    void validate() {
    }

    String getName() {
        return NAME;
    }

    ShowDialog<T> withValueClass(Class<T> valueClass) {
        this.valueClass = valueClass;
        return this;
    }

    public ShowDialog<T> withTitle(String title, Object ... args) {
        this.title = title;
        this.titleArgs = args;
        return this;
    }

    public ShowDialog<T> withGraphic(Node graphic) {
        this.graphic = graphic;
        return this;
    }

    public ShowDialog<T> withContent(Node content) {
        this.content = content;
        return this;
    }

    public ShowDialog<T> withButton(Button btn, Consumer<PFXDialog<T>> value) {
        EventHandler handler = e -> value.accept(this.dialog);
        btn.setOnAction(handler);
        this.buttons.add(btn);
        return this;
    }

    public ShowDialog<T> withWidth(int width) {
        this.width = width;
        return this;
    }

    public ShowDialog<T> withHeight(int height) {
        this.height = height;
        return this;
    }

    public ShowDialog<T> onValueSet(Consumer<PFXDialog<T>> onValueSet) {
        this.onValueSet = onValueSet;
        return this;
    }

    public ShowDialog<T> onOpened(Consumer<PFXDialog<T>> onOpened) {
        this.onOpened = onOpened;
        return this;
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    public Node getContent() {
        return this.content;
    }

    public Node getGraphic() {
        return this.graphic;
    }

    public int getHeight() {
        return this.height;
    }

    public String getTitle() {
        return this.title;
    }

    public int getWidth() {
        return this.width;
    }

    public PFXDialog<T> getDialog() {
        return this.dialog;
    }

    public Consumer<PFXDialog<T>> getOnValueSet() {
        return this.onValueSet;
    }

    public Consumer<PFXDialog<T>> getOnOpened() {
        return this.onOpened;
    }

    public void execute() {
        if (this.title != null && this.title.startsWith("%")) {
            this.title = this.localeContext.getMessage(this.title.substring(1), this.titleArgs);
        }
        this.dialog = new PFXDialog(this, (RemoveView)this.getCommandFactory().createCommand(RemoveView.class));
        Button cancelBtn = this.buttonFactory.createButton(PFXButtonBuilder.PFXButtonType.Cancel);
        cancelBtn.setOnAction(e -> this.dialog.close());
        this.dialog.getButtons().add((Object)cancelBtn);
        super.execute(false);
        this.screen.showDialog(this);
    }
}

