/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.commands;

import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import rs.tetrabyte.datarest.context.RepositoryFXContext;
import rs.tetrabyte.datarest.fx.RepositoryFX;
import rs.tetrabyte.datarest.repository.RepositorySearch;
import rs.tetrabyte.fxml.FXMLController;
import rs.tetrabyte.fxml.FXMLTaskFactory;
import rs.tetrabyte.fxml.FXMLValuePair;
import rs.tetrabyte.fxml.Output;
import rs.tetrabyte.pezar.browser.EBrowser;
import rs.tetrabyte.pezar.commands.DisplayContent;
import rs.tetrabyte.pezar.commands.UICommand;
import rs.tetrabyte.pezar.commands.UICommands;
import rs.tetrabyte.pezar.context.EBrowserContext;
import rs.tetrabyte.pezar.controller.browser.EBrowserController;
import rs.tetrabyte.pezar.controller.browser.ItemBrowserController;
import rs.tetrabyte.pezar.controller.browser.PartyBrowserController;

public class OpenBrowser
extends UICommand {
    private static Logger logger = LoggerFactory.getLogger(OpenBrowser.class);
    @Autowired
    private EBrowserContext browserCtx;
    @Autowired
    private UICommands commands;
    @Autowired
    private RepositoryFXContext repoCtx;
    @Autowired
    private FXMLTaskFactory fxmlTaskFactory;
    public static final String NAME = "open-browser";
    private String browserId;
    private Consumer<EBrowser> onOpen;
    private Consumer<EBrowser> onClose;
    private Consumer<EBrowser> onCommit;
    private Output output = new Output();
    private Class<? extends EBrowser> browserController;
    private Class<? extends FXMLController> formController;

    void validate() {
        if (StringUtils.isEmpty((CharSequence)this.browserId)) {
            throw new IllegalArgumentException("Browser ID can't be empty");
        }
    }

    public String getName() {
        return NAME;
    }

    public OpenBrowser onOpen(Consumer<EBrowser> consumer) {
        this.onOpen = consumer;
        return this;
    }

    public OpenBrowser onClose(Consumer<EBrowser> consumer) {
        this.onClose = consumer;
        return this;
    }

    public OpenBrowser onCommit(Consumer<EBrowser> consumer) {
        this.onCommit = consumer;
        return this;
    }

    public OpenBrowser withBrowserId(String browserId) {
        this.browserId = browserId;
        return this;
    }

    public OpenBrowser withOutput(Output output) {
        this.output.and(output);
        return this;
    }

    public OpenBrowser withController(Class<? extends EBrowserController> controller) {
        this.browserController = controller;
        return this;
    }

    public OpenBrowser withFormController(Class<? extends FXMLController> controller) {
        this.formController = controller;
        return this;
    }

    public void execute() {
        this.execute(false);
        FXMLValuePair grp = this.browserCtx.getBrowser(this.browserId);
        if (grp == null) {
            logger.debug("Browser not found [ {} ]", (Object)this.browserId);
            this.commands.lockUI().execute();
            this.browserCtx.getBrowserDescriptor(this.browserId, d -> {
                RepositoryFX repo = this.repoCtx.getRepositoryFX(this.browserId);
                Class browserController = null;
                RepositorySearch initialSearch = null;
                browserController = this.browserController != null ? this.browserController : (d.getBrowserId().startsWith("items") ? ItemBrowserController.class : (d.getBrowserId().startsWith("parties") ? PartyBrowserController.class : EBrowserController.class));
                if (d.getBrowserId().startsWith("categories")) {
                    initialSearch = RepositorySearch.builder().withRel("roots").build();
                }
                this.output.and(Output.values((Object[])new Object[]{repo, d, initialSearch})).and("formControllerClass", (Object)this.formController);
                this.fxmlTaskFactory.createTask(browserController).output(this.output).whenDone(v -> {
                    logger.debug("Browser loaded " + d);
                    this.browserCtx.putBrowser(this.browserId, v);
                    this.commands.unLockUI().execute();
                    this.openBrowser((Parent)v.getView(), (EBrowser)v.getController(), this.onOpen, this.onClose, this.onCommit);
                }).ifFailed(e -> {
                    logger.error("Error opening browser: " + this.browserId, e);
                    this.commands.unLockUI().execute();
                }).lockUI(false).execute();
            });
        } else {
            logger.debug("Browser found [ {} ]", (Object)this.browserId);
            this.output.inject(grp.getController());
            this.openBrowser((Parent)grp.getView(), (EBrowser)grp.getController(), this.onOpen, this.onClose, this.onCommit);
        }
    }

    private void openBrowser(Parent browser, EBrowser controller, Consumer<EBrowser> onOpened, Consumer<EBrowser> onClosed, Consumer<EBrowser> onCommit) {
        if (onCommit != null) {
            controller.setOnCommit(e -> {
                onCommit.accept(controller);
                controller.setOnCommit(null);
            });
        }
        this.commands.displayContent((Node)browser).asSingleton().closable(true).in(DisplayContent.TargetContainer.Screen).withCallback(a -> {
            if (onClosed != null) {
                onClosed.accept(controller);
            }
            return null;
        }).execute();
        if (onOpened != null) {
            onOpened.accept(controller);
        }
    }

    public String toString() {
        return String.format("OpenBrowser [ %s ]", this.browserId);
    }
}

