/*
 * Decompiled with CFR 0.152.
 */
package rs.tetrabyte.pezar.browser;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import rs.tetrabyte.datamodel.uidescriptors.entity.DSummaryDescriptor;
import rs.tetrabyte.pezar.beans.DocumentSum;
import rs.tetrabyte.pezar.context.MessageService;

public class DSummaryView
extends VBox {
    private static final DecimalFormat DEFAULT_FORMAT = new DecimalFormat("###,###.00");
    private final Map<String, Label> sumValues = new HashMap();
    private final MessageService messages;

    public DSummaryView(DSummaryDescriptor summaryDescriptor, MessageService messages) {
        this.messages = messages;
        this.getStyleClass().add((Object)"document-summary-view");
        summaryDescriptor.getLines().forEach(item -> {
            this.getChildren().add((Object)new Separator(Orientation.HORIZONTAL));
            this.getChildren().add((Object)this.createSumTitleLabel(item.getLabel()));
            item.getSumList().forEach(sum -> this.getChildren().add((Object)new HBox(new Node[]{this.createSumNameLabel(sum.getLabel()), this.createSumValueLabel(sum.getName())})));
        });
        this.getChildren().add((Object)new Separator(Orientation.HORIZONTAL));
        this.getChildren().add((Object)this.createSumTitleLabel(summaryDescriptor.getLabel()));
        summaryDescriptor.getSumList().forEach(sum -> this.getChildren().add((Object)new HBox(new Node[]{this.createSumNameLabel(sum.getLabel()), this.createSumValueLabel(sum.getName())})));
    }

    private Label createSumTitleLabel(String text) {
        Label label = new Label(this.messages.getMessage(text, new Object[0]));
        label.getStyleClass().add((Object)"document-sum-title");
        return label;
    }

    private Label createSumNameLabel(String text) {
        Label label = new Label(this.messages.getMessage(text, new Object[0]));
        label.setAlignment(Pos.BASELINE_LEFT);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        label.getStyleClass().add((Object)"document-sum-label");
        HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        return label;
    }

    private Label createSumValueLabel(String sumName) {
        Label label = new Label(DEFAULT_FORMAT.format(BigDecimal.ZERO));
        label.setAlignment(Pos.BASELINE_RIGHT);
        label.getStyleClass().add((Object)"document-sum-value");
        this.sumValues.put(sumName, label);
        return label;
    }

    public void setModel(List<DocumentSum> summary) {
        if (summary == null) {
            return;
        }
        this.sumValues.entrySet().forEach(e -> summary.stream().filter(sum -> sum.getName().equals(e.getKey())).findAny().map(sum -> {
            ((Label)e.getValue()).textProperty().unbind();
            ((Label)e.getValue()).textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> DEFAULT_FORMAT.format(sum.getValue()), (Observable[])new Observable[]{sum.valueProperty()}));
            return sum;
        }).orElseGet(() -> {
            ((Label)e.getValue()).textProperty().unbind();
            ((Label)e.getValue()).textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> DEFAULT_FORMAT.format(BigDecimal.ZERO), (Observable[])new Observable[]{new SimpleStringProperty()}));
            return null;
        }));
    }
}

