/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import javax.management.ObjectInstance;
import javax.management.openmbean.OpenType;

public class CommandProcessorUtil {
    private static final DateFormat[] allFormats = new DateFormat[]{DateFormat.getDateInstance(), DateFormat.getTimeInstance(), DateFormat.getDateTimeInstance(), DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1), DateFormat.getDateInstance(0), DateFormat.getTimeInstance(3), DateFormat.getTimeInstance(2), DateFormat.getTimeInstance(1), DateFormat.getTimeInstance(0), DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateTimeInstance(3, 2), DateFormat.getDateTimeInstance(3, 1), DateFormat.getDateTimeInstance(3, 0), DateFormat.getDateTimeInstance(2, 3), DateFormat.getDateTimeInstance(2, 2), DateFormat.getDateTimeInstance(2, 1), DateFormat.getDateTimeInstance(2, 0), DateFormat.getDateTimeInstance(1, 3), DateFormat.getDateTimeInstance(1, 2), DateFormat.getDateTimeInstance(1, 1), DateFormat.getDateTimeInstance(1, 0), DateFormat.getDateTimeInstance(0, 3), DateFormat.getDateTimeInstance(0, 2), DateFormat.getDateTimeInstance(0, 1), DateFormat.getDateTimeInstance(0, 0)};
    private static final String[] BASIC_TYPES = new String[]{"int", "long", "short", "byte", "float", "double", "boolean"};
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object createParameterValue(String parameterType, String parameterValue) throws Exception {
        if (parameterType.equals("java.lang.String")) {
            return parameterValue;
        }
        if (parameterType.equals("java.lang.Integer") || parameterType.equals("int")) {
            return Integer.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Long") || parameterType.equals("long")) {
            return Long.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Short") || parameterType.equals("short")) {
            return Short.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Byte") || parameterType.equals("byte")) {
            return Byte.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Float") || parameterType.equals("float")) {
            return Float.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Double") || parameterType.equals("double")) {
            return Double.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Boolean") || parameterType.equals("boolean")) {
            return Boolean.valueOf(parameterValue);
        }
        if (parameterType.equals("java.lang.Void")) {
            return Void.TYPE;
        }
        if (parameterType.equals("java.util.Date")) {
            Date value = null;
            for (int i = 0; i < allFormats.length; ++i) {
                DateFormat dateFormat = allFormats[i];
                synchronized (dateFormat) {
                    try {
                        System.out.println(parameterValue + " " + allFormats[i]);
                        value = allFormats[i].parse(parameterValue);
                        break;
                    }
                    catch (ParseException e) {
                        continue;
                    }
                }
            }
            if (value == null) {
                throw new ParseException("Not possible to parse", 0);
            }
            return value;
        }
        if (parameterType.equals("java.lang.Number")) {
            Number value = null;
            try {
                value = Long.valueOf(parameterValue);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (value == null) {
                try {
                    value = Double.valueOf(parameterValue);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (value == null) {
                throw new NumberFormatException("Not possible to parse");
            }
            return value;
        }
        if (parameterType.equals("java.lang.Character") || parameterType.equals("char")) {
            if (parameterValue.length() > 0) {
                return new Character(parameterValue.charAt(0));
            }
            throw new NumberFormatException("Can not initialize Character from empty String");
        }
        Class<?> cls = null;
        Constructor<?> ctor = null;
        try {
            cls = Class.forName(parameterType);
            ctor = cls.getConstructor(class$java$lang$String == null ? (class$java$lang$String = CommandProcessorUtil.class$("java.lang.String")) : class$java$lang$String);
            return ctor.newInstance(parameterValue);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("Invalid parameter type: " + parameterType);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Invalid parameter type: " + parameterType);
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    protected static boolean canCreateParameterValue(String parameterType) {
        int i;
        int count = OpenType.ALLOWED_CLASSNAMES.length;
        for (i = 0; i < count; ++i) {
            if (!OpenType.ALLOWED_CLASSNAMES[i].equals(parameterType)) continue;
            return true;
        }
        count = BASIC_TYPES.length;
        for (i = 0; i < count; ++i) {
            if (!BASIC_TYPES[i].equals(parameterType)) continue;
            return true;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(parameterType);
            cls.getConstructor(class$java$lang$String == null ? (class$java$lang$String = CommandProcessorUtil.class$("java.lang.String")) : class$java$lang$String);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Comparator createObjectNameComparator() {
        return new ToStringComparator();
    }

    public static Comparator createObjectInstanceComparator() {
        return new ObjectInstanceComparator();
    }

    public static Comparator createConstructorComparator() {
        return new ConstructorComparator();
    }

    public static Comparator createClassComparator() {
        return new ToStringComparator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ConstructorComparator
    implements Comparator {
        private ConstructorComparator() {
        }

        public int compare(Object o1, Object o2) {
            Class<?>[] params2;
            Constructor c1 = (Constructor)o1;
            Constructor c2 = (Constructor)o2;
            Class<?>[] params1 = c1.getParameterTypes();
            if (params1.length == (params2 = c2.getParameterTypes()).length) {
                for (int i = 0; i < params1.length; ++i) {
                    if (params1[i].equals(params2[i])) continue;
                    return params2[i].toString().compareTo(params1[i].toString());
                }
                return 0;
            }
            return params1.length - params2.length;
        }
    }

    private static class ObjectInstanceComparator
    implements Comparator {
        private ToStringComparator comp = new ToStringComparator();

        private ObjectInstanceComparator() {
        }

        public int compare(Object o1, Object o2) {
            ObjectInstance oi1 = (ObjectInstance)o1;
            ObjectInstance oi2 = (ObjectInstance)o2;
            return this.comp.compare(oi1.getObjectName(), oi2.getObjectName());
        }
    }

    private static class ToStringComparator
    implements Comparator {
        private ToStringComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

