/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MeteredOutputStream
extends FilterOutputStream {
    private long maxBps;
    private long bytesSent;
    private long startTime;
    private boolean started = false;
    private long threshold = 8192L;
    private long checkPoint = 1024L;
    private static final long DEFFAULT_THRESHOLD = 8192L;
    private static final long DEFAULT_CHECK_POINT = 1024L;

    public MeteredOutputStream(OutputStream out, long maxBps, long threshold) {
        super(out);
        this.maxBps = maxBps;
        this.bytesSent = 0L;
        this.threshold = threshold <= 8192L ? 8192L : threshold;
        this.checkPoint = 1024L;
    }

    public MeteredOutputStream(OutputStream out, long maxBps, long threshold, long checkPoint) {
        super(out);
        this.maxBps = maxBps;
        this.bytesSent = 0L;
        this.threshold = threshold <= 8192L ? 8192L : threshold;
        this.checkPoint = checkPoint;
    }

    public MeteredOutputStream(OutputStream out, long maxBps) {
        super(out);
        this.maxBps = maxBps;
        this.bytesSent = 0L;
        this.threshold = 8192L;
        this.checkPoint = 1024L;
    }

    public void write(int b) throws IOException {
        long elapsed;
        long currentBps;
        ++this.bytesSent;
        if (!this.started) {
            this.started = true;
            this.startTime = System.currentTimeMillis();
        }
        if (this.bytesSent >= this.threshold && this.bytesSent % this.checkPoint == 0L && (currentBps = this.bytesSent * 1000L / (elapsed = System.currentTimeMillis() - this.startTime + 1L)) > this.maxBps) {
            long expected = this.bytesSent * 1000L / this.maxBps;
            try {
                Thread.sleep(expected - elapsed);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.out.write(b);
    }
}

