/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.jumpmind.symmetric.Version;

public class JarBuilder {
    private File baseDir;
    private File[] sourceFiles;
    private File outputFile;

    public JarBuilder(File baseDir, File outputFile, File[] sourceFiles) {
        this.sourceFiles = sourceFiles;
        this.outputFile = outputFile;
        this.baseDir = baseDir;
    }

    public void build() throws IOException {
        this.outputFile.delete();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, Version.version());
        this.outputFile.getParentFile().mkdirs();
        JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(this.outputFile), manifest);
        for (File file : this.sourceFiles) {
            this.add(file, target);
        }
        target.close();
    }

    private String massageJarEntryName(File source) {
        String name = source.getPath();
        if (this.baseDir != null && name.startsWith(this.baseDir.getPath()) && name.length() > this.baseDir.getPath().length()) {
            name = name.substring(this.baseDir.getPath().length() + 1);
        }
        return name.replace("\\", "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(File source, JarOutputStream target) throws IOException {
        BufferedInputStream in = null;
        try {
            if (source.isDirectory()) {
                String name = this.massageJarEntryName(source);
                if (name.trim().length() != 0) {
                    if (!name.endsWith("/")) {
                        name = name + "/";
                    }
                    JarEntry entry = new JarEntry(name);
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                for (File nestedFile : source.listFiles()) {
                    this.add(nestedFile, target);
                }
            } else {
                int count;
                JarEntry entry = new JarEntry(this.massageJarEntryName(source));
                entry.setTime(source.lastModified());
                target.putNextEntry(entry);
                in = new BufferedInputStream(new FileInputStream(source));
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer)) != -1) {
                    target.write(buffer, 0, count);
                }
                target.closeEntry();
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }
}

