/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.File;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppUtils {
    private static boolean alreadyCleaned = false;
    private static String UNKNOWN = "unknown";
    private static ILog log = LogFactory.getLog(AppUtils.class);
    private static final String SYM_TEMP_SUFFIX = "sym.tmp";
    private static String serverId;
    private static FastDateFormat timezoneFormatter;
    private static Pattern pattern;

    public static String getServerId() {
        if (StringUtils.isBlank((String)serverId) && StringUtils.isBlank((String)(serverId = System.getProperty("runtime.symmetric.cluster.server.id", null))) && StringUtils.isBlank((String)(serverId = System.getProperty("bind.address", null)))) {
            try {
                serverId = AppUtils.getHostName();
            }
            catch (Exception ex) {
                serverId = "unknown";
            }
        }
        return serverId;
    }

    public static String getHostName() {
        String hostName = System.getProperty("host.name", UNKNOWN);
        if (UNKNOWN.equals(hostName)) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                log.warn(ex);
            }
        }
        return hostName;
    }

    public static String getIpAddress() {
        String ipAddress = System.getProperty("ip.address", UNKNOWN);
        if (UNKNOWN.equals(ipAddress)) {
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception ex) {
                log.warn(ex);
            }
        }
        return ipAddress;
    }

    public static String replace(String prop, String replaceWith, String sourceString) {
        return StringUtils.replace((String)sourceString, (String)("$(" + prop + ")"), (String)replaceWith);
    }

    public static String replaceTokens(String text, Map<String, String> replacements, boolean matchUsingPrefixSuffix) {
        if (replacements != null && replacements.size() > 0) {
            if (matchUsingPrefixSuffix) {
                Matcher matcher = pattern.matcher(text);
                StringBuffer buffer = new StringBuffer();
                while (matcher.find()) {
                    String[] match = matcher.group(1).split("\\|");
                    String replacement = replacements.get(match[0]);
                    if (replacement == null) continue;
                    matcher.appendReplacement(buffer, "");
                    if (match.length == 2) {
                        replacement = AppUtils.formatString(match[1], replacement);
                    }
                    buffer.append(replacement);
                }
                matcher.appendTail(buffer);
                text = buffer.toString();
            } else {
                for (String key : replacements.keySet()) {
                    text = text.replaceAll(key.toString(), replacements.get(key));
                }
            }
        }
        return text;
    }

    public static String formatString(String format, String arg) {
        if (format.indexOf("d") >= 0 || format.indexOf("u") >= 0 || format.indexOf("i") >= 0) {
            return String.format(format, Long.parseLong(arg));
        }
        if (format.indexOf("e") >= 0 || format.indexOf("f") >= 0) {
            return String.format(format, Double.valueOf(arg));
        }
        return String.format(format, arg);
    }

    public static String getTimezoneOffset() {
        String tz = timezoneFormatter.format(new Date());
        if (tz != null && tz.length() == 5) {
            return tz.substring(0, 3) + ":" + tz.substring(3, 5);
        }
        return null;
    }

    public static <T> T find(String name, ISymmetricEngine engine) {
        return (T)engine.getApplicationContext().getBean(name);
    }

    public static File createTempFile(String token) throws IOException {
        return File.createTempFile(token + ".", ".sym.tmp");
    }

    public static synchronized void cleanupTempFiles() {
        if (!alreadyCleaned) {
            alreadyCleaned = true;
            try {
                File tmp = File.createTempFile("temp.", ".sym.tmp");
                Iterator it = FileUtils.iterateFiles((File)tmp.getParentFile(), (String[])new String[]{SYM_TEMP_SUFFIX}, (boolean)true);
                int deletedCount = 0;
                while (it.hasNext()) {
                    try {
                        FileUtils.forceDelete((File)((File)it.next()));
                        ++deletedCount;
                    }
                    catch (Exception ex) {
                        log.error("Message", ex.getMessage());
                    }
                }
                if (deletedCount > 1) {
                    log.warn("CleanStrandedTempFiles", deletedCount);
                }
            }
            catch (Exception ex) {
                log.error(ex);
            }
        }
    }

    public static Date getLocalDateForOffset(String timezoneOffset) {
        long currentTime = System.currentTimeMillis();
        int myOffset = TimeZone.getDefault().getOffset(currentTime);
        int theirOffset = TimeZone.getTimeZone("GMT" + timezoneOffset).getOffset(currentTime);
        return new Date(currentTime - (long)myOffset + (long)theirOffset);
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            log.warn("Message", e.getMessage());
        }
    }

    public static void resetDataSource(DataSource ds) {
        if (ds instanceof BasicDataSource) {
            BasicDataSource bds = (BasicDataSource)ds;
            try {
                bds.close();
            }
            catch (Exception ex) {
                log.warn(ex);
            }
        }
    }

    public static boolean isSystemPropertySet(String propName, boolean defaultValue) {
        return "true".equalsIgnoreCase(System.getProperty(propName, Boolean.toString(defaultValue)));
    }

    public static void runBsh(Map<String, Object> variables, String script) {
        try {
            Interpreter interpreter = new Interpreter();
            if (variables != null) {
                for (String variableName : variables.keySet()) {
                    interpreter.set(variableName, variables.get(variableName));
                }
            }
            log.info("Message", "About to run: \n" + script);
            interpreter.eval(script);
        }
        catch (EvalError e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Map<String, T> toMap(String[] keyNames, T[] values) {
        if (values != null && keyNames != null && values.length >= keyNames.length) {
            HashMap<String, T> map = new HashMap<String, T>(keyNames.length);
            for (int i = 0; i < keyNames.length; ++i) {
                map.put(keyNames[i], values[i]);
            }
            return map;
        }
        return new HashMap(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortAvailable(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    static {
        timezoneFormatter = FastDateFormat.getInstance((String)"Z");
        pattern = Pattern.compile("\\$\\((.+?)\\)");
    }
}

