/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.http;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.RegistrationRequiredException;
import org.jumpmind.symmetric.transport.AuthenticationException;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.IOutgoingWithResponseTransport;
import org.jumpmind.symmetric.transport.SyncDisabledException;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;

public class HttpOutgoingTransport
implements IOutgoingWithResponseTransport {
    private URL url;
    private BufferedWriter writer;
    private BufferedReader reader;
    private HttpURLConnection connection;
    private int httpTimeout;
    private boolean useCompression;
    private int compressionStrategy;
    private int compressionLevel;
    private String basicAuthUsername;
    private String basicAuthPassword;
    private boolean streamOutputEnabled = false;
    private int streamOutputChunkSize = 30720;

    public HttpOutgoingTransport(URL url, int httpTimeout, boolean useCompression, int compressionStrategy, int compressionLevel, String basicAuthUsername, String basicAuthPassword, boolean streamOutputEnabled, int streamOutputSize) {
        this.url = url;
        this.httpTimeout = httpTimeout;
        this.useCompression = useCompression;
        this.compressionLevel = compressionLevel;
        this.compressionStrategy = compressionStrategy;
        this.basicAuthUsername = basicAuthUsername;
        this.basicAuthPassword = basicAuthPassword;
        this.streamOutputChunkSize = streamOutputSize;
        this.streamOutputEnabled = streamOutputEnabled;
    }

    public void close() throws IOException {
        this.closeWriter(true);
        this.closeReader();
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
    }

    private void closeReader() throws IOException {
        if (this.reader != null) {
            IOUtils.closeQuietly((Reader)this.reader);
            this.reader = null;
        }
    }

    private void closeWriter(boolean closeQuietly) throws IOException {
        if (this.writer != null) {
            this.writer.flush();
            if (closeQuietly) {
                IOUtils.closeQuietly((Writer)this.writer);
            } else {
                this.writer.close();
            }
            this.writer = null;
        }
    }

    private HttpURLConnection requestReservation() throws IOException {
        this.connection = HttpTransportManager.openConnection(this.url, this.basicAuthUsername, this.basicAuthPassword);
        this.connection.setUseCaches(false);
        this.connection.setConnectTimeout(this.httpTimeout);
        this.connection.setReadTimeout(this.httpTimeout);
        this.connection.setRequestMethod("HEAD");
        this.analyzeResponseCode(this.connection.getResponseCode());
        return this.connection;
    }

    public BufferedWriter open() throws IOException {
        this.connection = HttpTransportManager.openConnection(this.url, this.basicAuthUsername, this.basicAuthPassword);
        if (this.streamOutputEnabled) {
            this.connection.setChunkedStreamingMode(this.streamOutputChunkSize);
        }
        this.connection.setDoInput(true);
        this.connection.setDoOutput(true);
        this.connection.setUseCaches(false);
        this.connection.setConnectTimeout(this.httpTimeout);
        this.connection.setReadTimeout(this.httpTimeout);
        this.connection.setRequestMethod("PUT");
        this.connection.setRequestProperty("accept-encoding", "gzip");
        if (this.useCompression) {
            this.connection.addRequestProperty("Content-Type", "gzip");
        }
        OutputStream out = this.connection.getOutputStream();
        if (this.useCompression) {
            out = new GZIPOutputStream(out){
                {
                    this.def.setLevel(HttpOutgoingTransport.this.compressionLevel);
                    this.def.setStrategy(HttpOutgoingTransport.this.compressionStrategy);
                }
            };
        }
        OutputStreamWriter wout = new OutputStreamWriter(out, "UTF-8");
        this.writer = new BufferedWriter(wout);
        return this.writer;
    }

    private void analyzeResponseCode(int code) throws IOException {
        if (503 == code) {
            throw new ConnectionRejectedException();
        }
        if (403 == code) {
            throw new AuthenticationException();
        }
        if (658 == code) {
            throw new SyncDisabledException();
        }
        if (657 == code) {
            throw new RegistrationRequiredException();
        }
    }

    public BufferedReader readResponse() throws IOException {
        this.closeWriter(false);
        this.analyzeResponseCode(this.connection.getResponseCode());
        this.reader = HttpTransportManager.getReaderFrom(this.connection);
        return this.reader;
    }

    public boolean isOpen() {
        return this.connection != null;
    }

    public ChannelMap getSuspendIgnoreChannelLists(IConfigurationService configurationService) throws IOException {
        HttpURLConnection connection = this.requestReservation();
        ChannelMap suspendIgnoreChannelsList = new ChannelMap();
        String suspends = connection.getHeaderField("Suspended-Channels");
        String ignores = connection.getHeaderField("Ignored-Channels");
        suspendIgnoreChannelsList.addSuspendChannels(suspends);
        suspendIgnoreChannelsList.addIgnoreChannels(ignores);
        return suspendIgnoreChannelsList;
    }
}

