/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.RegistrationNotOpenException;
import org.jumpmind.symmetric.service.RegistrationRequiredException;
import org.jumpmind.symmetric.transport.AuthenticationException;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.SyncDisabledException;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;

public class HttpIncomingTransport
implements IIncomingTransport {
    private HttpURLConnection connection;
    private BufferedReader reader;
    private IParameterService parameterService;
    private String redirectionUrl;

    public HttpIncomingTransport(HttpURLConnection connection, IParameterService parameterService) {
        this.connection = connection;
        this.parameterService = parameterService;
    }

    public String getUrl() {
        return this.connection.getURL().toExternalForm();
    }

    public void close() throws IOException {
        IOUtils.closeQuietly((Reader)this.reader);
    }

    public boolean isOpen() {
        return this.reader != null;
    }

    public String getRedirectionUrl() {
        return this.redirectionUrl;
    }

    public BufferedReader open() throws IOException {
        boolean manualRedirects = this.parameterService.is("http.manual.redirects.enabled", true);
        if (manualRedirects) {
            this.connection = this.openConnectionCheckRedirects(this.connection);
        }
        switch (this.connection.getResponseCode()) {
            case 656: {
                throw new RegistrationNotOpenException();
            }
            case 657: {
                throw new RegistrationRequiredException();
            }
            case 658: {
                throw new SyncDisabledException();
            }
            case 503: {
                throw new ConnectionRejectedException();
            }
            case 403: {
                throw new AuthenticationException();
            }
        }
        this.reader = HttpTransportManager.getReaderFrom(this.connection);
        return this.reader;
    }

    private HttpURLConnection openConnectionCheckRedirects(HttpURLConnection connection) throws IOException {
        boolean redir;
        int redirects = 0;
        do {
            HttpURLConnection http;
            int stat;
            if (connection instanceof HttpURLConnection) {
                connection.setInstanceFollowRedirects(false);
            }
            redir = false;
            if (!(connection instanceof HttpURLConnection) || (stat = (http = connection).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            this.redirectionUrl = http.getHeaderField("Location");
            URL target = null;
            if (this.redirectionUrl != null) {
                target = new URL(base, this.redirectionUrl);
            }
            http.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            connection = HttpTransportManager.openConnection(target, this.getBasicAuthUsername(), this.getBasicAuthPassword());
            ++redirects;
        } while (redir);
        return connection;
    }

    protected String getBasicAuthUsername() {
        return this.parameterService.getString("http.basic.auth.username");
    }

    protected String getBasicAuthPassword() {
        return this.parameterService.getString("http.basic.auth.password");
    }
}

