/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.jumpmind.symmetric.io.ThresholdFileWriter;
import org.jumpmind.symmetric.transport.IIncomingTransport;

public class FileIncomingTransport
implements IIncomingTransport {
    ThresholdFileWriter fileWriter;
    BufferedReader reader;

    public FileIncomingTransport(ThresholdFileWriter fileWriter) {
        this.fileWriter = fileWriter;
    }

    public void close() throws IOException {
        IOUtils.closeQuietly((Reader)this.reader);
        if (this.fileWriter != null) {
            this.fileWriter.delete();
        }
    }

    public String getUrl() {
        File file = this.getFile();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public boolean isOpen() {
        return this.reader != null;
    }

    public BufferedReader open() throws IOException {
        this.reader = this.fileWriter.getReader();
        return this.reader;
    }

    public String getRedirectionUrl() {
        return null;
    }

    public File getFile() {
        if (this.fileWriter != null) {
            return this.fileWriter.getFile();
        }
        return null;
    }
}

