/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.IConcurrentConnectionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentConnectionManager
implements IConcurrentConnectionManager {
    protected IParameterService parameterService;
    protected IStatisticManager statisticManager;
    protected Map<String, Map<String, Reservation>> activeReservationsByNodeByPool = new HashMap<String, Map<String, Reservation>>();
    protected Map<String, Map<String, NodeConnectionStatistics>> nodeConnectionStatistics = new HashMap<String, Map<String, NodeConnectionStatistics>>();
    protected Set<String> whiteList = new HashSet<String>();

    protected void logTooBusyRejection(String nodeId, String poolId) {
        ++this.getNodeConnectionStatistics((String)nodeId, (String)poolId).numOfRejections;
    }

    protected void logConnectedTimePeriod(String nodeId, long startMs, long endMs, String poolId) {
        NodeConnectionStatistics stats = this.getNodeConnectionStatistics(nodeId, poolId);
        ++stats.totalConnectionCount;
        stats.totalConnectionTimeMs += endMs - startMs;
        stats.lastConnectionTimeMs = startMs;
    }

    private synchronized NodeConnectionStatistics getNodeConnectionStatistics(String nodeId, String poolId) {
        NodeConnectionStatistics stats;
        Map<String, NodeConnectionStatistics> statsMap = this.nodeConnectionStatistics.get(poolId);
        if (statsMap == null) {
            statsMap = new HashMap<String, NodeConnectionStatistics>();
            this.nodeConnectionStatistics.put(poolId, statsMap);
        }
        if ((stats = statsMap.get(nodeId)) == null) {
            stats = new NodeConnectionStatistics();
            statsMap.put(nodeId, stats);
        }
        return stats;
    }

    @Override
    public synchronized boolean releaseConnection(String nodeId, String poolId) {
        Map<String, Reservation> reservations = this.getReservationMap(poolId);
        Reservation reservation = reservations.remove(nodeId);
        if (reservation != null) {
            this.logConnectedTimePeriod(nodeId, reservation.createTime, System.currentTimeMillis(), poolId);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void addToWhitelist(String nodeId) {
        this.whiteList.add(nodeId);
    }

    @Override
    public synchronized void removeFromWhiteList(String nodeId) {
        this.whiteList.remove(nodeId);
    }

    @Override
    public synchronized String[] getWhiteList() {
        return this.whiteList.toArray(new String[this.whiteList.size()]);
    }

    @Override
    public synchronized int getReservationCount(String poolId) {
        return this.getReservationMap(poolId).size();
    }

    @Override
    public synchronized boolean reserveConnection(String nodeId, String poolId, IConcurrentConnectionManager.ReservationType reservationRequest) {
        Map<String, Reservation> reservations = this.getReservationMap(poolId);
        int maxPoolSize = this.parameterService.getInt("http.concurrent.workers.max");
        long timeout = this.parameterService.getLong("http.concurrent.reservation.timeout.ms");
        this.removeTimedOutReservations(reservations);
        if (reservations.size() < maxPoolSize || reservations.containsKey(nodeId) || this.whiteList.contains(nodeId)) {
            reservations.put(nodeId, new Reservation(nodeId, reservationRequest == IConcurrentConnectionManager.ReservationType.SOFT ? System.currentTimeMillis() + timeout : Long.MAX_VALUE));
            return true;
        }
        return false;
    }

    protected void removeTimedOutReservations(Map<String, Reservation> reservations) {
        long currentTime = System.currentTimeMillis();
        String[] keys = reservations.keySet().toArray(new String[reservations.size()]);
        if (keys != null) {
            for (String nodeId : keys) {
                Reservation reservation = reservations.get(nodeId);
                if (reservation.timeToLiveInMs >= currentTime) continue;
                reservations.remove(nodeId);
            }
        }
    }

    private Map<String, Reservation> getReservationMap(String poolId) {
        Map<String, Reservation> reservations = this.activeReservationsByNodeByPool.get(poolId);
        if (reservations == null) {
            reservations = new HashMap<String, Reservation>();
            this.activeReservationsByNodeByPool.put(poolId, reservations);
        }
        return reservations;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }

    @Override
    public Map<String, Map<String, NodeConnectionStatistics>> getNodeConnectionStatisticsByPoolByNodeId() {
        return this.nodeConnectionStatistics;
    }

    @Override
    public Map<String, Map<String, Reservation>> getActiveReservationsByNodeByPool() {
        return this.activeReservationsByNodeByPool;
    }

    public class NodeConnectionStatistics {
        int numOfRejections;
        long totalConnectionCount;
        long totalConnectionTimeMs;
        long lastConnectionTimeMs;

        public int getNumOfRejections() {
            return this.numOfRejections;
        }

        public long getTotalConnectionCount() {
            return this.totalConnectionCount;
        }

        public long getTotalConnectionTimeMs() {
            return this.totalConnectionTimeMs;
        }

        public long getLastConnectionTimeMs() {
            return this.lastConnectionTimeMs;
        }
    }

    protected static class Reservation {
        String nodeId;
        long timeToLiveInMs;
        long createTime = System.currentTimeMillis();

        public Reservation(String nodeId, long timeToLiveInMs) {
            this.nodeId = nodeId;
            this.timeToLiveInMs = timeToLiveInMs;
        }

        public int hashCode() {
            return this.nodeId.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Reservation) {
                return this.nodeId.equals(((Reservation)obj).nodeId);
            }
            return false;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public long getTimeToLiveInMs() {
            return this.timeToLiveInMs;
        }

        public long getCreateTime() {
            return this.createTime;
        }
    }
}

