/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transform;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.IDataLoaderFilter;
import org.jumpmind.symmetric.load.IMissingTableHandler;
import org.jumpmind.symmetric.load.StatementBuilder;
import org.jumpmind.symmetric.load.TableTemplate;
import org.jumpmind.symmetric.transform.AbstractTransformer;
import org.jumpmind.symmetric.transform.TransformPoint;
import org.jumpmind.symmetric.transform.TransformTable;
import org.jumpmind.symmetric.transform.TransformedData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformDataLoader
extends AbstractTransformer
implements IBuiltInExtensionPoint,
IDataLoaderFilter,
IMissingTableHandler {
    @Override
    protected TransformPoint getTransformPoint() {
        return TransformPoint.LOAD;
    }

    @Override
    public boolean filterInsert(IDataLoaderContext context, String[] columnValues) {
        List<TransformedData> transformedData;
        boolean processRow = true;
        if (this.isEligibleForTransform(context.getCatalogName(), context.getSchemaName(), context.getTableName()) && (transformedData = this.transform(StatementBuilder.DmlType.INSERT, context, context.getNodeGroupLink(), context.getCatalogName(), context.getSchemaName(), context.getTableName(), context.getColumnNames(), columnValues, null, null, null)) != null) {
            this.apply(context, transformedData);
            processRow = false;
        }
        return processRow;
    }

    @Override
    public boolean filterUpdate(IDataLoaderContext context, String[] columnValues, String[] keyValues) {
        List<TransformedData> transformedData;
        boolean processRow = true;
        if (this.isEligibleForTransform(context.getCatalogName(), context.getSchemaName(), context.getTableName()) && (transformedData = this.transform(StatementBuilder.DmlType.UPDATE, context, context.getNodeGroupLink(), context.getCatalogName(), context.getSchemaName(), context.getTableName(), context.getColumnNames(), columnValues, context.getKeyNames(), keyValues, context.getOldData())) != null) {
            this.apply(context, transformedData);
            processRow = false;
        }
        return processRow;
    }

    @Override
    public boolean filterDelete(IDataLoaderContext context, String[] keyValues) {
        List<TransformedData> transformedData;
        String[] columnNames = context.getKeyNames();
        String[] columnValues = keyValues;
        if (context.getOldData() != null) {
            columnNames = context.getColumnNames();
            columnValues = context.getOldData();
        }
        boolean processRow = true;
        if (this.isEligibleForTransform(context.getCatalogName(), context.getSchemaName(), context.getTableName()) && (transformedData = this.transform(StatementBuilder.DmlType.DELETE, context, context.getNodeGroupLink(), context.getCatalogName(), context.getSchemaName(), context.getTableName(), columnNames, columnValues, context.getKeyNames(), keyValues, context.getOldData())) != null) {
            this.apply(context, transformedData);
            processRow = false;
        }
        return processRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(IDataLoaderContext context, List<TransformedData> dataThatHasBeenTransformed) {
        block9: for (TransformedData data : dataThatHasBeenTransformed) {
            TableTemplate tableTemplate = new TableTemplate(context.getJdbcTemplate(), this.dbDialect, data.getTableName(), null, false, data.getSchemaName(), data.getCatalogName());
            tableTemplate.setColumnNames(data.getColumnNames());
            tableTemplate.setKeyNames(data.getKeyNames());
            switch (data.getTargetDmlType()) {
                case INSERT: {
                    Object var13_20;
                    Table table = tableTemplate.getTable();
                    boolean attemptFallbackUpdate = false;
                    RuntimeException insertException = null;
                    try {
                        try {
                            if (data.isGeneratedIdentityNeeded()) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("TransformEnablingGeneratedIdentity", table.getName());
                                }
                                this.dbDialect.revertAllowIdentityInserts(context.getJdbcTemplate(), table);
                            } else if (table.hasAutoIncrementColumn()) {
                                this.dbDialect.allowIdentityInserts(context.getJdbcTemplate(), table);
                            }
                            if (tableTemplate.insert(context, data.getColumnValues(), data.getKeyValues()) == 0) {
                                attemptFallbackUpdate = this.parameterService.is("dataloader.enable.fallback.update");
                            }
                        }
                        catch (RuntimeException ex) {
                            insertException = ex;
                            if (this.dbDialect.isPrimaryKeyViolation(ex) && this.parameterService.is("dataloader.enable.fallback.update")) {
                                attemptFallbackUpdate = true;
                            }
                            throw ex;
                        }
                        if (attemptFallbackUpdate) {
                            List<TransformedData> newlyTransformedDatas = this.transform(StatementBuilder.DmlType.UPDATE, context, data.getTransformation(), data.getSourceKeyValues(), data.getOldSourceValues(), data.getSourceValues());
                            for (TransformedData newlyTransformedData : newlyTransformedDatas) {
                                if (newlyTransformedData.hasSameKeyValues(data.getKeyValues()) || data.isGeneratedIdentityNeeded()) {
                                    if (newlyTransformedData.getKeyNames() != null && newlyTransformedData.getKeyNames().length > 0) {
                                        tableTemplate.setColumnNames(newlyTransformedData.getColumnNames());
                                        tableTemplate.setKeyNames(newlyTransformedData.getKeyNames());
                                        if (0 != tableTemplate.update(context, newlyTransformedData.getColumnValues(), newlyTransformedData.getKeyValues())) continue;
                                        throw new SymmetricException("LoaderFallbackUpdateFailed", (Throwable)insertException, tableTemplate.getTable().toVerboseString(), ArrayUtils.toString((Object)data.getColumnValues()), ArrayUtils.toString((Object)data.getKeyValues()));
                                    }
                                    this.log.warn("Message", insertException.getMessage());
                                    this.log.warn("TransformNoPrimaryKeyDefinedNoUpdate", newlyTransformedData.getTransformation().getTransformId());
                                    continue;
                                }
                                this.log.debug("TransformMatchingFallbackNotFound", StatementBuilder.DmlType.UPDATE.name());
                            }
                        }
                        var13_20 = null;
                    }
                    catch (Throwable throwable) {
                        var13_20 = null;
                        if (table.hasAutoIncrementColumn()) {
                            this.dbDialect.revertAllowIdentityInserts(context.getJdbcTemplate(), table);
                        }
                        throw throwable;
                    }
                    if (!table.hasAutoIncrementColumn()) continue block9;
                    this.dbDialect.revertAllowIdentityInserts(context.getJdbcTemplate(), table);
                    break;
                }
                case UPDATE: {
                    boolean enableFallbackInsert = this.parameterService.is("dataloader.enable.fallback.insert");
                    if (data.getKeyNames() != null && data.getKeyNames().length > 0) {
                        if (0 != tableTemplate.update(context, data.getColumnValues(), data.getKeyValues()) || data.getSourceDmlType() == StatementBuilder.DmlType.DELETE) break;
                        if (enableFallbackInsert) {
                            List<TransformedData> newlyTransformedDatas = this.transform(StatementBuilder.DmlType.INSERT, context, data.getTransformation(), data.getSourceKeyValues(), data.getOldSourceValues(), data.getSourceValues());
                            for (TransformedData newlyTransformedData : newlyTransformedDatas) {
                                if (newlyTransformedData.hasSameKeyValues(data.getKeyValues()) || newlyTransformedData.isGeneratedIdentityNeeded()) {
                                    if (newlyTransformedData.isGeneratedIdentityNeeded()) {
                                        if (this.log.isDebugEnabled()) {
                                            this.log.debug("TransformEnablingGeneratedIdentity", tableTemplate.getTable().getName());
                                        }
                                        this.dbDialect.revertAllowIdentityInserts(context.getJdbcTemplate(), tableTemplate.getTable());
                                    } else if (tableTemplate.getTable().hasAutoIncrementColumn()) {
                                        this.dbDialect.allowIdentityInserts(context.getJdbcTemplate(), tableTemplate.getTable());
                                    }
                                    newlyTransformedData.setTargetDmlType(StatementBuilder.DmlType.INSERT);
                                    tableTemplate.setColumnNames(newlyTransformedData.getColumnNames());
                                    tableTemplate.setKeyNames(newlyTransformedData.getKeyNames());
                                    tableTemplate.insert(context, newlyTransformedData.getColumnValues(), newlyTransformedData.getKeyValues());
                                    continue;
                                }
                                this.log.debug("TransformMatchingFallbackNotFound", StatementBuilder.DmlType.INSERT.name());
                            }
                            continue block9;
                        }
                        throw new SymmetricException("LoaderUpdatingFailed", context.getTableName(), ArrayUtils.toString((Object)data.getColumnValues()));
                    }
                    this.log.warn("TransformNoPrimaryKeyDefinedNoUpdate", data.getTransformation().getTransformId());
                    break;
                }
                case DELETE: {
                    boolean allowMissingDelete = this.parameterService.is("dataloader.allow.missing.delete");
                    int rows = tableTemplate.delete(context, data.getKeyValues());
                    if (rows != 0) break;
                    if (allowMissingDelete) {
                        this.log.warn("LoaderDeleteMissing", context.getTableName(), ArrayUtils.toString((Object)data.getColumnValues()));
                        break;
                    }
                    throw new SymmetricException("LoaderDeleteMissing", context.getTableName(), ArrayUtils.toString((Object)data.getColumnValues()));
                }
            }
        }
    }

    @Override
    public boolean isHandlingMissingTable(IDataLoaderContext context) {
        List<TransformTable> transformationsToPerform = this.findTablesToTransform(context.getNodeGroupLink(), context.getTableTemplate().getFullyQualifiedTableName(true));
        return transformationsToPerform != null && transformationsToPerform.size() > 0;
    }
}

