/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transform;

import java.util.ArrayList;
import java.util.List;
import org.jumpmind.symmetric.ext.ICacheContext;
import org.jumpmind.symmetric.extract.DataExtractorContext;
import org.jumpmind.symmetric.load.StatementBuilder;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.transform.AbstractTransformer;
import org.jumpmind.symmetric.transform.IgnoreRowException;
import org.jumpmind.symmetric.transform.TransformPoint;
import org.jumpmind.symmetric.transform.TransformedData;
import org.jumpmind.symmetric.util.CsvUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformDataExtractor
extends AbstractTransformer {
    private ITriggerRouterService triggerRouterService;

    public List<Data> transformData(Data data, String routerId, DataExtractorContext context) throws IgnoreRowException {
        DataEventType eventType = data.getEventType();
        StatementBuilder.DmlType dmlType = this.toDmlType(eventType);
        if (dmlType != null) {
            List<TransformedData> transformedData;
            TriggerHistory triggerHistory = data.getTriggerHistory();
            Router router = this.triggerRouterService.getRouterById(routerId, false);
            if (router != null && (transformedData = this.transform(dmlType, context, router.getNodeGroupLink(), triggerHistory.getSourceCatalogName(), triggerHistory.getSourceSchemaName(), data.getTableName(), triggerHistory.getParsedColumnNames(), data.toParsedRowData(), dmlType == StatementBuilder.DmlType.INSERT ? null : triggerHistory.getParsedPkColumnNames(), dmlType == StatementBuilder.DmlType.INSERT ? null : data.toParsedPkData(), data.toParsedOldData())) != null) {
                return this.apply(context, transformedData);
            }
        }
        return null;
    }

    @Override
    protected TransformPoint getTransformPoint() {
        return TransformPoint.EXTRACT;
    }

    protected List<Data> apply(ICacheContext context, List<TransformedData> dataThatHasBeenTransformed) {
        ArrayList<Data> datas = new ArrayList<Data>(dataThatHasBeenTransformed.size());
        for (TransformedData transformedData : dataThatHasBeenTransformed) {
            StatementBuilder.DmlType targetDmlType = transformedData.getTargetDmlType();
            if (targetDmlType == null) continue;
            Data data = new Data();
            TriggerHistory triggerHistory = new TriggerHistory(transformedData.getTableName(), CsvUtils.escapeCsvData(transformedData.getKeyNames()), CsvUtils.escapeCsvData(transformedData.getColumnNames()));
            triggerHistory.setTriggerHistoryId(triggerHistory.toVirtualTriggerHistId());
            triggerHistory.setSourceCatalogName(transformedData.getCatalogName());
            triggerHistory.setSourceSchemaName(transformedData.getSchemaName());
            data.setTriggerHistory(triggerHistory);
            data.setEventType(this.toDataEventType(transformedData.getTargetDmlType()));
            data.setTableName(transformedData.getTableName());
            data.setRowData(CsvUtils.escapeCsvData(transformedData.getColumnValues()));
            data.setPkData(CsvUtils.escapeCsvData(transformedData.getKeyValues()));
            data.setOldData(null);
            datas.add(data);
        }
        return datas;
    }

    protected StatementBuilder.DmlType toDmlType(DataEventType eventType) {
        switch (eventType) {
            case INSERT: {
                return StatementBuilder.DmlType.INSERT;
            }
            case UPDATE: {
                return StatementBuilder.DmlType.UPDATE;
            }
            case DELETE: {
                return StatementBuilder.DmlType.DELETE;
            }
        }
        return null;
    }

    protected DataEventType toDataEventType(StatementBuilder.DmlType dmlType) {
        switch (dmlType) {
            case INSERT: {
                return DataEventType.INSERT;
            }
            case UPDATE: {
                return DataEventType.UPDATE;
            }
            case DELETE: {
                return DataEventType.DELETE;
            }
        }
        return null;
    }

    public void setTriggerRouterService(ITriggerRouterService triggerRouterService) {
        this.triggerRouterService = triggerRouterService;
    }
}

