/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transform;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ext.ICacheContext;
import org.jumpmind.symmetric.transform.ISingleValueColumnTransform;
import org.jumpmind.symmetric.transform.IgnoreColumnException;
import org.jumpmind.symmetric.transform.IgnoreRowException;
import org.jumpmind.symmetric.transform.TransformColumn;
import org.jumpmind.symmetric.transform.TransformedData;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupColumnTransform
implements ISingleValueColumnTransform,
IBuiltInExtensionPoint {
    protected final ILog log = LogFactory.getLog(this.getClass());
    protected SimpleJdbcTemplate jdbcTemplate;
    public static final String NAME = "lookup";
    protected static final LookupColumnRowMapper lookupColumnRowMapper = new LookupColumnRowMapper();

    @Override
    public boolean isAutoRegister() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String transform(ICacheContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String value, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        String sql = column.getTransformExpression();
        String lookupValue = null;
        if (StringUtils.isNotBlank((String)sql)) {
            List values = this.jdbcTemplate.query(sql, (RowMapper)lookupColumnRowMapper, sourceValues);
            int rowCount = values.size();
            if (rowCount == 1) {
                lookupValue = (String)values.get(0);
            } else if (rowCount > 1) {
                lookupValue = (String)values.get(0);
                this.log.warn("LookupColumnTransform.multipleRows", column.getTargetColumnName(), column.getTransformId());
            } else if (values.size() == 0) {
                this.log.warn("LookupColumnTransform.noRows", column.getTargetColumnName(), column.getTransformId());
            }
        } else {
            this.log.warn("LookupColumnTransform.noSql", column.getTargetColumnName(), column.getTransformId());
        }
        return lookupValue;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = new SimpleJdbcTemplate((JdbcOperations)jdbcTemplate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LookupColumnRowMapper
    implements RowMapper<String> {
        LookupColumnRowMapper() {
        }

        public String mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getString(1);
        }
    }
}

