/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transform;

import bsh.Interpreter;
import bsh.TargetError;
import java.util.Map;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.ext.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ext.ICacheContext;
import org.jumpmind.symmetric.transform.ISingleValueColumnTransform;
import org.jumpmind.symmetric.transform.IgnoreColumnException;
import org.jumpmind.symmetric.transform.IgnoreRowException;
import org.jumpmind.symmetric.transform.TransformColumn;
import org.jumpmind.symmetric.transform.TransformColumnException;
import org.jumpmind.symmetric.transform.TransformedData;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BshColumnTransform
implements ISingleValueColumnTransform,
IBuiltInExtensionPoint {
    protected final ILog log = LogFactory.getLog(this.getClass());
    final String INTERPRETER_KEY = String.format("%d.BshInterpreter", this.hashCode());
    public static final String NAME = "bsh";
    protected JdbcTemplate jdbcTemplate;

    @Override
    public boolean isAutoRegister() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String transform(ICacheContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String value, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        try {
            Interpreter interpreter = this.getInterpreter(context);
            interpreter.set("jdbcTemplate", (Object)this.jdbcTemplate);
            interpreter.set("currentValue", (Object)value);
            interpreter.set("oldValue", (Object)oldValue);
            for (String columnName : sourceValues.keySet()) {
                interpreter.set(columnName.toUpperCase(), (Object)sourceValues.get(columnName));
            }
            Object result = interpreter.eval(column.getTransformExpression());
            if (result != null) {
                return result.toString();
            }
            return null;
        }
        catch (TargetError evalEx) {
            Throwable ex = evalEx.getTarget();
            if (ex instanceof IgnoreColumnException) {
                throw (IgnoreColumnException)ex;
            }
            if (ex instanceof IgnoreRowException) {
                throw (IgnoreRowException)ex;
            }
            throw new TransformColumnException(ex);
        }
        catch (Exception ex) {
            if (ex instanceof IgnoreColumnException) {
                throw (IgnoreColumnException)ex;
            }
            if (ex instanceof IgnoreRowException) {
                throw (IgnoreRowException)ex;
            }
            this.log.error("BshColumnTransform.exception", column.getTargetColumnName(), column.getTransformId());
            throw new TransformColumnException(ex);
        }
    }

    protected Interpreter getInterpreter(ICacheContext context) {
        Interpreter interpreter = (Interpreter)context.getContextCache().get(this.INTERPRETER_KEY);
        if (interpreter == null) {
            interpreter = new Interpreter();
            context.getContextCache().put(this.INTERPRETER_KEY, interpreter);
        }
        return interpreter;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

