/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.statistic;

import java.util.Date;
import org.jumpmind.symmetric.statistic.AbstractNodeHostStats;

public class HostStats
extends AbstractNodeHostStats {
    private long restarted;
    private long nodesPulled;
    private long totalNodesPullTime;
    private long nodesPushed;
    private long totalNodesPushTime;
    private long nodesRejected;
    private long nodesRegistered;
    private long nodesLoaded;
    private long nodesDisabled;
    private long purgedDataRows;
    private long purgedDataEventRows;
    private long purgedBatchOutgoingRows;
    private long purgedBatchIncomingRows;
    private long triggersCreatedCount;
    private long triggersRebuiltCount;
    private long triggersRemovedCount;

    public HostStats() {
    }

    public HostStats(String nodeId, String hostName, Date startTime, Date endTime) {
        super(nodeId, hostName, startTime, endTime);
    }

    public HostStats(HostStats source) {
        super(source.getNodeId(), source.getHostName(), source.getStartTime(), source.getEndTime());
        this.add(source);
    }

    public void add(HostStats stats) {
        this.restarted += stats.getRestarted();
        this.nodesPulled += stats.getNodesPulled();
        this.totalNodesPullTime += stats.getTotalNodesPullTime();
        this.nodesPushed += stats.getNodesPushed();
        this.totalNodesPushTime += stats.getTotalNodesPushTime();
        this.nodesRejected += stats.getNodesRejected();
        this.nodesRegistered += stats.getNodesRegistered();
        this.nodesLoaded += stats.getNodesLoaded();
        this.nodesDisabled += stats.getNodesDisabled();
        this.purgedDataRows += stats.getPurgedDataRows();
        this.purgedDataEventRows += stats.getPurgedDataEventRows();
        this.purgedBatchOutgoingRows += stats.getPurgedBatchOutgoingRows();
        this.purgedBatchIncomingRows += stats.getPurgedBatchIncomingRows();
        this.triggersCreatedCount += stats.getTriggersCreatedCount();
        this.triggersRebuiltCount += stats.getTriggersRebuiltCount();
        this.triggersRemovedCount += stats.getTriggersRemovedCount();
    }

    public long getRestarted() {
        return this.restarted;
    }

    public void incrementRestarted(long value) {
        this.restarted += value;
    }

    public long getTotalNodesPullTime() {
        return this.totalNodesPullTime;
    }

    public void setTotalNodesPullTime(long totalNodesPullTime) {
        this.totalNodesPullTime = totalNodesPullTime;
    }

    public void incrementTotalNodesPullTime(long value) {
        this.totalNodesPullTime += value;
    }

    public long getTotalNodesPushTime() {
        return this.totalNodesPushTime;
    }

    public void setTotalNodesPushTime(long totalNodesPushTime) {
        this.totalNodesPushTime = totalNodesPushTime;
    }

    public void incrementTotalNodesPushTime(long value) {
        this.totalNodesPushTime += value;
    }

    public long getNodesPulled() {
        return this.nodesPulled;
    }

    public void incrementNodesPulled(long value) {
        this.nodesPulled += value;
    }

    public long getNodesPushed() {
        return this.nodesPushed;
    }

    public void incrementNodesPushed(long value) {
        this.nodesPushed += value;
    }

    public long getNodesRejected() {
        return this.nodesRejected;
    }

    public void incrementNodesRejected(long value) {
        this.nodesRejected += value;
    }

    public long getNodesRegistered() {
        return this.nodesRegistered;
    }

    public void incrementNodesRegistered(long value) {
        this.nodesRegistered += value;
    }

    public long getNodesLoaded() {
        return this.nodesLoaded;
    }

    public void incrementNodesLoaded(long value) {
        this.nodesLoaded += value;
    }

    public long getNodesDisabled() {
        return this.nodesDisabled;
    }

    public void incrementNodesDisabled(long value) {
        this.nodesDisabled += value;
    }

    public long getPurgedDataRows() {
        return this.purgedDataRows;
    }

    public void incrementPurgedDataRows(long value) {
        this.purgedDataRows += value;
    }

    public long getPurgedDataEventRows() {
        return this.purgedDataEventRows;
    }

    public void incrementPurgedDataEventRows(long value) {
        this.purgedDataEventRows += value;
    }

    public long getPurgedBatchOutgoingRows() {
        return this.purgedBatchOutgoingRows;
    }

    public void incrementPurgedBatchOutgoingRows(long value) {
        this.purgedBatchOutgoingRows += value;
    }

    public long getPurgedBatchIncomingRows() {
        return this.purgedBatchIncomingRows;
    }

    public void incrementPurgedBatchIncomingRows(long value) {
        this.purgedBatchIncomingRows += value;
    }

    public long getTriggersCreatedCount() {
        return this.triggersCreatedCount;
    }

    public void incrementTriggersCreatedCount(long count) {
        this.triggersCreatedCount += count;
    }

    public void incrementTriggersRebuiltCount(long count) {
        this.triggersRebuiltCount += count;
    }

    public void incrementTriggersRemovedCount(long count) {
        this.triggersRemovedCount += count;
    }

    public long getTriggersRebuiltCount() {
        return this.triggersRebuiltCount;
    }

    public long getTriggersRemovedCount() {
        return this.triggersRemovedCount;
    }

    public void setRestarted(long restarted) {
        this.restarted = restarted;
    }

    public void setNodesPulled(long nodesPulled) {
        this.nodesPulled = nodesPulled;
    }

    public void setNodesPushed(long nodesPushed) {
        this.nodesPushed = nodesPushed;
    }

    public void setNodesRejected(long nodesRejected) {
        this.nodesRejected = nodesRejected;
    }

    public void setNodesRegistered(long nodesRegistered) {
        this.nodesRegistered = nodesRegistered;
    }

    public void setNodesLoaded(long nodesLoaded) {
        this.nodesLoaded = nodesLoaded;
    }

    public void setNodesDisabled(long nodesDisabled) {
        this.nodesDisabled = nodesDisabled;
    }

    public void setPurgedDataRows(long purgedDataRows) {
        this.purgedDataRows = purgedDataRows;
    }

    public void setPurgedDataEventRows(long purgedDataEventRows) {
        this.purgedDataEventRows = purgedDataEventRows;
    }

    public void setPurgedBatchOutgoingRows(long purgedBatchOutgoingRows) {
        this.purgedBatchOutgoingRows = purgedBatchOutgoingRows;
    }

    public void setPurgedBatchIncomingRows(long purgedBatchIncomingRows) {
        this.purgedBatchIncomingRows = purgedBatchIncomingRows;
    }

    public void setTriggersCreatedCount(long triggersCreatedCount) {
        this.triggersCreatedCount = triggersCreatedCount;
    }

    public void setTriggersRebuiltCount(long triggersRebuiltCount) {
        this.triggersRebuiltCount = triggersRebuiltCount;
    }

    public void setTriggersRemovedCount(long triggersRemovedCount) {
        this.triggersRemovedCount = triggersRemovedCount;
    }
}

