/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.statistic;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.jumpmind.symmetric.statistic.IStatisticManager;

abstract class AbstractStatisticsWriter
extends FilterWriter {
    protected IStatisticManager statisticManager;
    protected String channelId;
    protected long byteCount = 0L;
    protected long lineCount = 0L;
    private int notifyAfterByteCount;
    private int notifyAfterLineCount;

    public AbstractStatisticsWriter(IStatisticManager statisticManager, Writer out, int notifyAfterByteCount, int notifyAfterLineCount) {
        super(out);
        this.statisticManager = statisticManager;
        this.notifyAfterByteCount = notifyAfterByteCount;
        this.notifyAfterLineCount = notifyAfterLineCount;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
        this.flushCounts();
    }

    public void write(int c) throws IOException {
        super.write(c);
        ++this.byteCount;
        if (this.byteCount % (long)this.notifyAfterByteCount == 0L) {
            this.processNumberOfBytesSoFar(this.byteCount);
            this.byteCount = 0L;
        }
        if ((char)c == '\n') {
            ++this.lineCount;
            if (this.lineCount % (long)this.notifyAfterLineCount == 0L) {
                this.processNumberOfLinesSoFar(this.lineCount);
                this.lineCount = 0L;
            }
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        super.write(cbuf, off, len);
        this.byteCount += (long)len;
        if (this.byteCount % (long)this.notifyAfterByteCount == 0L) {
            this.processNumberOfBytesSoFar(this.byteCount);
            this.byteCount = 0L;
        }
        for (int i = 0; i < len; ++i) {
            char c = cbuf[i + off];
            if (c != '\n') continue;
            ++this.lineCount;
            if (this.lineCount % (long)this.notifyAfterLineCount != 0L) continue;
            this.processNumberOfLinesSoFar(this.lineCount);
            this.lineCount = 0L;
        }
    }

    public void write(String str, int off, int len) throws IOException {
        super.write(str, off, len);
        this.byteCount += (long)len;
        if (this.byteCount % (long)this.notifyAfterByteCount == 0L) {
            this.processNumberOfBytesSoFar(this.byteCount);
            this.byteCount = 0L;
        }
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i + off);
            if (c != '\n') continue;
            ++this.lineCount;
            if (this.lineCount % (long)this.notifyAfterLineCount != 0L) continue;
            this.processNumberOfLinesSoFar(this.lineCount);
            this.lineCount = 0L;
        }
    }

    protected void flushCounts() {
        if (this.lineCount > 0L) {
            this.processNumberOfLinesSoFar(this.lineCount);
            this.lineCount = 0L;
        }
        if (this.byteCount > 0L) {
            this.processNumberOfBytesSoFar(this.byteCount);
            this.byteCount = 0L;
        }
    }

    public void flush() throws IOException {
        super.flush();
        this.flushCounts();
    }

    public void close() throws IOException {
        super.close();
        this.flushCounts();
    }

    protected abstract void processNumberOfBytesSoFar(long var1);

    protected abstract void processNumberOfLinesSoFar(long var1);
}

