/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.jmx;

import java.io.ByteArrayOutputStream;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.internal.InternalOutgoingTransport;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="The management interface for outgoing synchronization")
public class OutgoingManagementService {
    protected IStatisticManager statisticManager;
    protected IDataExtractorService dataExtractorService;

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }

    @ManagedOperation(description="Show a batch in SymmetricDS Data Format.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="batchId", description="The batch ID to display")})
    public String showBatch(String batchId) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InternalOutgoingTransport transport = new InternalOutgoingTransport(out, null);
        this.dataExtractorService.extractBatchRange(transport, batchId, batchId);
        transport.close();
        out.close();
        return out.toString();
    }

    public void setDataExtractorService(IDataExtractorService dataExtractorService) {
        this.dataExtractorService = dataExtractorService;
    }
}

