/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.jmx;

import java.io.FileOutputStream;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IPurgeService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.ISecurityService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.ConcurrentConnectionManager;
import org.jumpmind.symmetric.transport.IConcurrentConnectionManager;
import org.jumpmind.symmetric.transport.internal.InternalOutgoingTransport;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="The management interface for a node")
public class NodeManagementService {
    final ILog log = LogFactory.getLog(this.getClass());
    private IPurgeService purgeService;
    private INodeService nodeService;
    private IDataService dataService;
    private IOutgoingBatchService outgoingBatchService;
    private IConfigurationService configurationService;
    private ITriggerRouterService triggerRouterService;
    private IRegistrationService registrationService;
    private IDataExtractorService dataExtractorService;
    private IClusterService clusterService;
    private IParameterService parameterService;
    private IConcurrentConnectionManager concurrentConnectionManager;
    private ISecurityService securityService;
    private DataSource dataSource;
    IStatisticManager statisticManager;

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }

    @ManagedAttribute(description="Checks if SymmetricDS has been started.")
    public boolean isStarted() {
        ISymmetricEngine engine = this.getEngine();
        if (engine != null) {
            return engine.isStarted();
        }
        return false;
    }

    @ManagedOperation(description="Start the SymmetricDS engine")
    public boolean start() {
        try {
            ISymmetricEngine engine = this.getEngine();
            if (engine != null) {
                return engine.start();
            }
            return false;
        }
        catch (Exception ex) {
            this.log.error(ex);
            return false;
        }
    }

    @ManagedOperation(description="Stop the SymmetricDS engine")
    public void stop() {
        try {
            ISymmetricEngine engine = this.getEngine();
            if (engine != null) {
                engine.stop();
            }
        }
        catch (Exception ex) {
            this.log.error(ex);
        }
    }

    @ManagedOperation(description="Run the purge process")
    public void purge() {
        this.purgeService.purgeOutgoing();
    }

    @ManagedOperation(description="Force the channel settings to be read from the database")
    public void clearChannelCache() {
        this.configurationService.reloadChannels();
    }

    @ManagedOperation(description="Synchronize the triggers")
    public void syncTriggers() {
        this.triggerRouterService.syncTriggers();
    }

    protected ISymmetricEngine getEngine() {
        return AbstractSymmetricEngine.findEngineByName(this.parameterService.getString("engine.name"));
    }

    @ManagedAttribute(description="Get the number of current connections allowed to this instance of the node via HTTP.  If this value is 20, then 20 concurrent push clients and 20 concurrent pull clients will be allowed")
    public int getNumfNodeConnectionsPerInstance() {
        return this.parameterService.getInt("http.concurrent.workers.max");
    }

    @ManagedAttribute(description="Get connection statistics about indivdual nodes")
    public String getNodeConcurrencyStatisticsAsText() {
        String lineFeed = "\n";
        if (this.parameterService.getString("jmx.line.feed").equals("html")) {
            lineFeed = "</br>";
        }
        Map<String, Map<String, ConcurrentConnectionManager.NodeConnectionStatistics>> stats = this.concurrentConnectionManager.getNodeConnectionStatisticsByPoolByNodeId();
        StringBuilder out = new StringBuilder();
        for (String pool : stats.keySet()) {
            out.append("-------------------------------------------------------------------------------------------------------------------------------");
            out.append(lineFeed);
            out.append("  CONNECTION TYPE: ");
            out.append(pool);
            out.append(lineFeed);
            out.append("-------------------------------------------------------------------------------------------------------------------------------");
            out.append(lineFeed);
            out.append("             NODE ID             LAST CONNECT TIME      NUMBER OF CONNECTIONS     NUMBER OF REJECTIONS       AVG CONNECTED TIME");
            out.append(lineFeed);
            out.append("-------------------------------------------------------------------------------------------------------------------------------");
            out.append(lineFeed);
            Map<String, ConcurrentConnectionManager.NodeConnectionStatistics> nodeStats = stats.get(pool);
            for (String nodeId : nodeStats.keySet()) {
                ConcurrentConnectionManager.NodeConnectionStatistics nodeStat = nodeStats.get(nodeId);
                out.append(StringUtils.leftPad((String)nodeId, (int)20));
                out.append(StringUtils.leftPad((String)DateFormat.getDateTimeInstance(2, 2).format(new Date(nodeStat.getLastConnectionTimeMs())), (int)30));
                out.append(StringUtils.leftPad((String)Long.toString(nodeStat.getTotalConnectionCount()), (int)27));
                out.append(StringUtils.leftPad((String)Integer.toString(nodeStat.getNumOfRejections()), (int)25));
                out.append(StringUtils.leftPad((String)NumberFormat.getIntegerInstance().format(nodeStat.getTotalConnectionTimeMs() / nodeStat.getTotalConnectionCount()), (int)25));
            }
            out.append(lineFeed);
        }
        return out.toString();
    }

    public String getCurrentNodeConcurrencyReservationsAsText() {
        throw new NotImplementedException();
    }

    @ManagedAttribute(description="Get a list of nodes that have been added to the white list, a list of node ids that always get through the concurrency manager.")
    public String getNodesInWhiteList() {
        String[] list;
        StringBuilder ret = new StringBuilder();
        for (String string : list = this.concurrentConnectionManager.getWhiteList()) {
            ret.append(string);
            ret.append(",");
        }
        return ret.length() > 0 ? ret.substring(0, ret.length() - 1) : "";
    }

    @ManagedOperation(description="Add a node id to the list of nodes that will always get through the concurrency manager")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id to add to the white list")})
    public void addNodeToWhiteList(String nodeId) {
        this.concurrentConnectionManager.addToWhitelist(nodeId);
    }

    @ManagedOperation(description="Remove a node id to the list of nodes that will always get through the concurrency manager")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id to remove from the white list")})
    public void removeNodeFromWhiteList(String nodeId) {
        this.concurrentConnectionManager.removeFromWhiteList(nodeId);
    }

    @ManagedAttribute(description="Configure the number of connections allowed to this node.  If the value is set to zero you are effectively disabling your transport (wihch can be useful for maintainance")
    public void setNumOfNodeConnectionsPerInstance(int value) {
        this.parameterService.saveParameter("http.concurrent.workers.max", value);
    }

    @ManagedAttribute(description="The group this node belongs to")
    public String getNodeGroupId() {
        return this.parameterService.getNodeGroupId();
    }

    @ManagedAttribute(description="An external name given to this SymmetricDS node")
    public String getExternalId() {
        return this.parameterService.getExternalId();
    }

    @ManagedAttribute(description="The node id given to this SymmetricDS node")
    public String getNodeId() {
        Node node = this.nodeService.findIdentity();
        if (node != null) {
            return node.getNodeId();
        }
        return "?";
    }

    @ManagedAttribute(description="Whether the basic DataSource is being used as the default datasource.")
    public boolean isBasicDataSource() {
        return this.dataSource instanceof BasicDataSource;
    }

    @ManagedAttribute(description="If a BasicDataSource, then show the number of active connections")
    public int getNumberOfActiveConnections() {
        if (this.isBasicDataSource()) {
            return ((BasicDataSource)this.dataSource).getNumActive();
        }
        return -1;
    }

    @ManagedOperation(description="Check to see if the external id is registered")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeGroupId", description="The node group id for a node"), @ManagedOperationParameter(name="externalId", description="The external id for a node")})
    public boolean isExternalIdRegistered(String nodeGroupdId, String externalId) {
        return this.nodeService.isExternalIdRegistered(nodeGroupdId, externalId);
    }

    @ManagedOperation(description="Emergency remove all locks (if left abandoned on a cluster)")
    public void clearAllLocks() {
        this.clusterService.clearAllLocks();
    }

    @ManagedOperation(description="Check to see if the initial load for a node id is complete.  This method will throw an exception if the load error'd out or was never started.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id")})
    public boolean areAllLoadBatchesComplete(String nodeId) {
        return this.outgoingBatchService.areAllLoadBatchesComplete(nodeId);
    }

    @ManagedOperation(description="Enable or disable synchronization completely for a node")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node to enable or disable"), @ManagedOperationParameter(name="syncEnabled", description="true is enabled, false is disabled")})
    public boolean setSyncEnabledForNode(String nodeId, boolean syncEnabled) {
        Node node = this.nodeService.findNode(nodeId);
        if (node != null) {
            node.setSyncEnabled(syncEnabled);
            this.nodeService.updateNode(node);
            return true;
        }
        return false;
    }

    @ManagedOperation(description="Enable or disable a channel for a specific external id")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="ignore", description="Set to true to enable and false to disable"), @ManagedOperationParameter(name="channelId", description="The channel id to enable or disable"), @ManagedOperationParameter(name="nodeGroupId", description="The node group id for a node"), @ManagedOperationParameter(name="externalId", description="The external id for a node")})
    public void ignoreNodeChannelForExternalId(boolean ignore, String channelId, String nodeGroupId, String externalId) {
        this.nodeService.ignoreNodeChannelForExternalId(ignore, channelId, nodeGroupId, externalId);
    }

    @ManagedOperation(description="Open the registration for a node with the specified external id")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeGroup", description="The node group id this node will belong to"), @ManagedOperationParameter(name="externalId", description="The external id for the node")})
    public void openRegistration(String nodeGroupId, String externalId) {
        Node node = this.nodeService.findNodeByExternalId(nodeGroupId, externalId);
        if (node != null) {
            this.registrationService.reOpenRegistration(node.getExternalId());
        } else {
            this.registrationService.openRegistration(nodeGroupId, externalId);
        }
    }

    @ManagedOperation(description="Send an initial load of data to a node.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id to reload.")})
    public String reloadNode(String nodeId) {
        return this.dataService.reloadNode(nodeId);
    }

    @ManagedOperation(description="Send a SQL event to a node.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id to sent the event to."), @ManagedOperationParameter(name="catalogName", description="The catalog name to reload. Can be null."), @ManagedOperationParameter(name="schemaName", description="The schema name to reload. Can be null."), @ManagedOperationParameter(name="tableName", description="The table name the SQL is for."), @ManagedOperationParameter(name="sql", description="The SQL statement to send.")})
    public String sendSQL(String nodeId, String catalogName, String schemaName, String tableName, String sql) {
        return this.dataService.sendSQL(nodeId, catalogName, schemaName, tableName, sql, false);
    }

    @ManagedOperation(description="Send a delete and reload of a table to a node.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id to reload."), @ManagedOperationParameter(name="catalogName", description="The catalog name to reload. Can be null."), @ManagedOperationParameter(name="schemaName", description="The schema name to reload. Can be null."), @ManagedOperationParameter(name="tableName", description="The table name to reload.")})
    public String reloadTable(String nodeId, String catalogName, String schemaName, String tableName) {
        return this.dataService.reloadTable(nodeId, catalogName, schemaName, tableName);
    }

    @ManagedOperation(description="Send a delete and reload of a table to a node.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeId", description="The node id to reload."), @ManagedOperationParameter(name="catalogName", description="The catalog name to reload. Can be null."), @ManagedOperationParameter(name="schemaName", description="The schema name to reload. Can be null."), @ManagedOperationParameter(name="tableName", description="The table name to reload."), @ManagedOperationParameter(name="overrideInitialLoadSelect", description="Override initial load select where-clause.")})
    public String reloadTable(String nodeId, String catalogName, String schemaName, String tableName, String overrideInitialLoadSelect) {
        return this.dataService.reloadTable(nodeId, catalogName, schemaName, tableName, overrideInitialLoadSelect);
    }

    @ManagedOperation(description="Write a range of batches to a file in SymmetricDS Data Format.")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="startBatchId", description="Starting batch ID of range"), @ManagedOperationParameter(name="endBatchId", description="Ending batch ID of range"), @ManagedOperationParameter(name="fileName", description="File name to write batches")})
    public void writeBatchRangeToFile(String startBatchId, String endBatchId, String fileName) throws Exception {
        FileOutputStream out = new FileOutputStream(fileName);
        InternalOutgoingTransport transport = new InternalOutgoingTransport(out);
        this.dataExtractorService.extractBatchRange(transport, startBatchId, endBatchId);
        transport.close();
        out.close();
    }

    @ManagedOperation(description="Encrypts plain text for use with db.user and db.password properties")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="plainText", description="Plain text to encrypt")})
    public String encryptText(String plainText) throws Exception {
        try {
            return "enc:" + this.securityService.encrypt(plainText);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setPurgeService(IPurgeService purgeService) {
        this.purgeService = purgeService;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataService(IDataService dataService) {
        this.dataService = dataService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRegistrationService(IRegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public void setOutgoingBatchService(IOutgoingBatchService outgoingBatchService) {
        this.outgoingBatchService = outgoingBatchService;
    }

    public void setDataExtractorService(IDataExtractorService dataExtractorService) {
        this.dataExtractorService = dataExtractorService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setConcurrentConnectionManager(IConcurrentConnectionManager concurrentConnectionManager) {
        this.concurrentConnectionManager = concurrentConnectionManager;
    }

    public void setSecurityService(ISecurityService securityService) {
        this.securityService = securityService;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setTriggerRouterService(ITriggerRouterService triggerService) {
        this.triggerRouterService = triggerService;
    }
}

