/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.ChannelRouterContext;
import org.jumpmind.symmetric.route.DataToRouteReaderFactory;
import org.jumpmind.symmetric.route.IBatchAlgorithm;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.IDataToRouteGapDetector;
import org.jumpmind.symmetric.route.IDataToRouteReader;
import org.jumpmind.symmetric.route.IRouterContext;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.statistic.IStatisticManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterService
extends AbstractService
implements IRouterService {
    private IClusterService clusterService;
    private IDataService dataService;
    private IConfigurationService configurationService;
    private ITriggerRouterService triggerRouterService;
    private IOutgoingBatchService outgoingBatchService;
    private INodeService nodeService;
    private Map<String, IDataRouter> routers;
    private Map<String, IBatchAlgorithm> batchAlgorithms;
    private DataToRouteReaderFactory dataToRouteReaderFactory;
    private IStatisticManager statisticManager;
    transient ExecutorService readThread = null;

    @Override
    public Map<String, IDataRouter> getRouters() {
        return this.routers;
    }

    @Override
    public boolean shouldDataBeRouted(IRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad) {
        IDataRouter router = this.getDataRouter(dataMetaData.getTriggerRouter());
        Set<String> nodeIds = router.routeToNodes(context, dataMetaData, nodes, initialLoad);
        for (Node node : nodes) {
            if (nodeIds == null || !nodeIds.contains(node.getNodeId())) continue;
            return true;
        }
        return false;
    }

    protected synchronized ExecutorService getReadService() {
        if (this.readThread == null) {
            this.readThread = Executors.newCachedThreadPool(new ThreadFactory(){
                final AtomicInteger threadNumber = new AtomicInteger(1);
                final String namePrefix;
                {
                    this.namePrefix = RouterService.this.parameterService.getString("engine.name", "").toLowerCase() + "-router-reader-";
                }

                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setName(this.namePrefix + this.threadNumber.getAndIncrement());
                    if (t.isDaemon()) {
                        t.setDaemon(false);
                    }
                    if (t.getPriority() != 5) {
                        t.setPriority(5);
                    }
                    return t;
                }
            });
        }
        return this.readThread;
    }

    @Override
    public synchronized void stop() {
        try {
            this.log.info("RouterShuttingDown");
            this.getReadService().shutdown();
            this.readThread = null;
        }
        catch (Exception ex) {
            this.log.error(ex);
        }
    }

    @Override
    public synchronized void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long routeData() {
        long dataCount = -1L;
        if (this.clusterService.lock("ROUTE")) {
            try {
                this.insertInitialLoadEvents();
                long ts = System.currentTimeMillis();
                IDataToRouteGapDetector gapDetector = this.dataToRouteReaderFactory.getDataToRouteGapDetector();
                gapDetector.beforeRouting();
                dataCount = this.routeDataForEachChannel();
                gapDetector.afterRouting();
                ts = System.currentTimeMillis() - ts;
                if (dataCount > 0L || ts > 30000L) {
                    this.log.info("RoutedDataInTime", dataCount, ts);
                }
                Object var7_4 = null;
                this.clusterService.unlock("ROUTE");
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                this.clusterService.unlock("ROUTE");
                throw throwable;
            }
        }
        return dataCount;
    }

    protected void insertInitialLoadEvents() {
        try {
            Map<String, NodeSecurity> nodeSecurities;
            Node identity = this.nodeService.findIdentity();
            if (identity != null && (nodeSecurities = this.nodeService.findAllNodeSecurity(false)) != null) {
                for (NodeSecurity security : nodeSecurities.values()) {
                    if (security.getNodeId().equals(identity.getNodeId()) || !security.isInitialLoadEnabled() || security.getRegistrationTime() == null && !security.getNodeId().equals(identity.getCreatedAtNodeId())) continue;
                    long ts = System.currentTimeMillis();
                    this.dataService.insertReloadEvents(this.nodeService.findNode(security.getNodeId()));
                    ts = System.currentTimeMillis() - ts;
                    if (ts > 30000L) {
                        this.log.warn("ReloadedNode", security.getNodeId(), ts);
                        continue;
                    }
                    this.log.info("ReloadedNode", security.getNodeId(), ts);
                }
            }
        }
        catch (Exception ex) {
            this.log.error(ex);
        }
    }

    protected int routeDataForEachChannel() {
        Node sourceNode = this.nodeService.findIdentity();
        List<NodeChannel> channels = this.configurationService.getNodeChannels(false);
        int dataCount = 0;
        for (NodeChannel nodeChannel : channels) {
            if (!nodeChannel.isSuspendEnabled() && nodeChannel.isEnabled()) {
                dataCount += this.routeDataForChannel(nodeChannel, sourceNode);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("RouterSkippingChannel", nodeChannel.getChannelId());
        }
        return dataCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int routeDataForChannel(NodeChannel nodeChannel, Node sourceNode) {
        ChannelRouterContext context = null;
        long ts = System.currentTimeMillis();
        int dataCount = -1;
        try {
            int n;
            try {
                context = new ChannelRouterContext(sourceNode.getNodeId(), nodeChannel, this.dataSource);
                n = dataCount = this.selectDataAndRoute(context);
                Object var10_8 = null;
            }
            catch (Exception ex) {
                this.log.error("RouterRoutingFailed", ex, nodeChannel.getChannelId());
                if (context != null) {
                    context.rollback();
                }
                int n2 = 0;
                Object var10_9 = null;
                try {}
                catch (Throwable throwable) {
                    Object var19_31 = null;
                    long totalTime = System.currentTimeMillis() - ts;
                    context.incrementStat(totalTime, "total.time.ms");
                    context.logStats(this.log, totalTime);
                    context.cleanup();
                    throw throwable;
                }
                try {}
                catch (Exception e) {
                    if (context != null) {
                        context.rollback();
                    }
                    this.log.error(e);
                    Object var19_30 = null;
                    long totalTime = System.currentTimeMillis() - ts;
                    context.incrementStat(totalTime, "total.time.ms");
                    context.logStats(this.log, totalTime);
                    context.cleanup();
                    return n2;
                }
                if (dataCount > 0) {
                    long insertTs = System.currentTimeMillis();
                    this.dataService.insertDataEvents(context.getJdbcTemplate(), context.getDataEventList());
                    context.clearDataEventsList();
                    this.completeBatchesAndCommit(context);
                    context.incrementStat(System.currentTimeMillis() - insertTs, "data.events.insert.time.ms");
                    if (context.getLastDataIdProcessed() > 0L) {
                        String channelId = nodeChannel.getChannelId();
                        long queryTs = System.currentTimeMillis();
                        long dataLeftToRoute = this.jdbcTemplate.queryForInt(this.getSql("selectUnroutedCountForChannelSql"), new Object[]{channelId, context.getLastDataIdProcessed()});
                        queryTs = System.currentTimeMillis() - queryTs;
                        if (queryTs > 30000L) {
                            this.log.warn("UnRoutedQueryTookLongTime", channelId, queryTs);
                        }
                        this.statisticManager.setDataUnRouted(channelId, dataLeftToRoute);
                    }
                }
                Object var19_29 = null;
                long totalTime = System.currentTimeMillis() - ts;
                context.incrementStat(totalTime, "total.time.ms");
                context.logStats(this.log, totalTime);
                context.cleanup();
                return n2;
            }
            try {
                block23: {
                    try {
                        if (dataCount <= 0) break block23;
                        long insertTs = System.currentTimeMillis();
                        this.dataService.insertDataEvents(context.getJdbcTemplate(), context.getDataEventList());
                        context.clearDataEventsList();
                        this.completeBatchesAndCommit(context);
                        context.incrementStat(System.currentTimeMillis() - insertTs, "data.events.insert.time.ms");
                        if (context.getLastDataIdProcessed() <= 0L) break block23;
                        String channelId = nodeChannel.getChannelId();
                        long queryTs = System.currentTimeMillis();
                        long dataLeftToRoute = this.jdbcTemplate.queryForInt(this.getSql("selectUnroutedCountForChannelSql"), new Object[]{channelId, context.getLastDataIdProcessed()});
                        queryTs = System.currentTimeMillis() - queryTs;
                        if (queryTs > 30000L) {
                            this.log.warn("UnRoutedQueryTookLongTime", channelId, queryTs);
                        }
                        this.statisticManager.setDataUnRouted(channelId, dataLeftToRoute);
                    }
                    catch (Exception e) {
                        if (context != null) {
                            context.rollback();
                        }
                        this.log.error(e);
                        Object var19_27 = null;
                        long totalTime = System.currentTimeMillis() - ts;
                        context.incrementStat(totalTime, "total.time.ms");
                        context.logStats(this.log, totalTime);
                        context.cleanup();
                        return n;
                    }
                }
                Object var19_26 = null;
                long totalTime = System.currentTimeMillis() - ts;
                context.incrementStat(totalTime, "total.time.ms");
                context.logStats(this.log, totalTime);
                context.cleanup();
                return n;
            }
            catch (Throwable throwable) {
                Object var19_28 = null;
                long totalTime = System.currentTimeMillis() - ts;
                context.incrementStat(totalTime, "total.time.ms");
                context.logStats(this.log, totalTime);
                context.cleanup();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {}
            catch (Throwable throwable2) {
                Object var19_34 = null;
                long totalTime = System.currentTimeMillis() - ts;
                context.incrementStat(totalTime, "total.time.ms");
                context.logStats(this.log, totalTime);
                context.cleanup();
                throw throwable2;
            }
            try {}
            catch (Exception e) {
                if (context != null) {
                    context.rollback();
                }
                this.log.error(e);
                Object var19_33 = null;
                long totalTime = System.currentTimeMillis() - ts;
                context.incrementStat(totalTime, "total.time.ms");
                context.logStats(this.log, totalTime);
                context.cleanup();
                throw throwable;
            }
            if (dataCount > 0) {
                long insertTs = System.currentTimeMillis();
                this.dataService.insertDataEvents(context.getJdbcTemplate(), context.getDataEventList());
                context.clearDataEventsList();
                this.completeBatchesAndCommit(context);
                context.incrementStat(System.currentTimeMillis() - insertTs, "data.events.insert.time.ms");
                if (context.getLastDataIdProcessed() > 0L) {
                    String channelId = nodeChannel.getChannelId();
                    long queryTs = System.currentTimeMillis();
                    long dataLeftToRoute = this.jdbcTemplate.queryForInt(this.getSql("selectUnroutedCountForChannelSql"), new Object[]{channelId, context.getLastDataIdProcessed()});
                    queryTs = System.currentTimeMillis() - queryTs;
                    if (queryTs > 30000L) {
                        this.log.warn("UnRoutedQueryTookLongTime", channelId, queryTs);
                    }
                    this.statisticManager.setDataUnRouted(channelId, dataLeftToRoute);
                }
            }
            Object var19_32 = null;
            long totalTime = System.currentTimeMillis() - ts;
            context.incrementStat(totalTime, "total.time.ms");
            context.logStats(this.log, totalTime);
            context.cleanup();
            throw throwable;
        }
    }

    protected void completeBatchesAndCommit(ChannelRouterContext context) throws SQLException {
        HashSet<IDataRouter> usedRouters = new HashSet<IDataRouter>(context.getUsedDataRouters());
        ArrayList<OutgoingBatch> batches = new ArrayList<OutgoingBatch>(context.getBatchesByNodes().values());
        context.commit();
        for (OutgoingBatch batch : batches) {
            batch.setRouterMillis(System.currentTimeMillis() - batch.getCreateTime().getTime());
            for (IDataRouter dataRouter : usedRouters) {
                dataRouter.completeBatch(context, batch);
            }
            if ("-1".equals(batch.getNodeId())) {
                batch.setStatus(OutgoingBatch.Status.OK);
            } else {
                batch.setStatus(OutgoingBatch.Status.NE);
            }
            this.outgoingBatchService.updateOutgoingBatch(batch);
            context.getBatchesByNodes().remove(batch.getNodeId());
        }
        for (IDataRouter dataRouter : usedRouters) {
            dataRouter.contextCommitted(context);
        }
        context.setNeedsCommitted(false);
    }

    protected Set<Node> findAvailableNodes(TriggerRouter triggerRouter, ChannelRouterContext context) {
        Set<Node> nodes = context.getAvailableNodes().get(triggerRouter);
        if (nodes == null) {
            nodes = new HashSet<Node>();
            Router router = triggerRouter.getRouter();
            NodeGroupLink link = this.configurationService.getNodeGroupLinkFor(router.getNodeGroupLink().getSourceNodeGroupId(), router.getNodeGroupLink().getTargetNodeGroupId());
            if (link != null) {
                nodes.addAll(this.nodeService.findEnabledNodesFromNodeGroup(router.getNodeGroupLink().getTargetNodeGroupId()));
            } else {
                this.log.error("RouterIllegalNodeGroupLink", router.getRouterId(), router.getNodeGroupLink().getSourceNodeGroupId(), router.getNodeGroupLink().getTargetNodeGroupId());
            }
            context.getAvailableNodes().put(triggerRouter, nodes);
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int selectDataAndRoute(ChannelRouterContext context) throws SQLException {
        IDataToRouteReader reader = this.dataToRouteReaderFactory.getDataToRouteReader(context);
        this.getReadService().execute(reader);
        Data data = null;
        int totalDataCount = 0;
        int totalDataEventCount = 0;
        int statsDataCount = 0;
        int statsDataEventCount = 0;
        int maxNumberOfEventsBeforeFlush = this.parameterService.getInt("routing.flush.jdbc.batch.size");
        try {
            do {
                Object var15_12;
                long insertTs;
                block12: {
                    if ((data = reader.take()) == null) continue;
                    context.setLastDataIdProcessed(data.getDataId());
                    ++statsDataCount;
                    ++totalDataCount;
                    int dataEventsInserted = this.routeData(data, context);
                    statsDataEventCount += dataEventsInserted;
                    totalDataEventCount += dataEventsInserted;
                    insertTs = System.currentTimeMillis();
                    try {
                        if (maxNumberOfEventsBeforeFlush <= context.getDataEventList().size() || context.isNeedsCommitted()) {
                            this.dataService.insertDataEvents(context.getJdbcTemplate(), context.getDataEventList());
                            context.clearDataEventsList();
                        }
                        if (!context.isNeedsCommitted()) break block12;
                        this.completeBatchesAndCommit(context);
                        long maxDataToRoute = context.getChannel().getMaxDataToRoute();
                        if (maxDataToRoute <= 0L || (long)totalDataCount <= maxDataToRoute) break block12;
                        this.log.info("RoutedMaxNumberData", totalDataCount, context.getChannel().getChannelId());
                        var15_12 = null;
                    }
                    catch (Throwable throwable) {
                        var15_12 = null;
                        context.incrementStat(System.currentTimeMillis() - insertTs, "data.events.insert.time.ms");
                        if (statsDataCount > 1024) {
                            this.statisticManager.incrementDataRouted(context.getChannel().getChannelId(), statsDataCount);
                            statsDataCount = 0;
                            this.statisticManager.incrementDataEventInserted(context.getChannel().getChannelId(), statsDataEventCount);
                            statsDataEventCount = 0;
                        }
                        throw throwable;
                    }
                    context.incrementStat(System.currentTimeMillis() - insertTs, "data.events.insert.time.ms");
                    if (statsDataCount > 1024) {
                        this.statisticManager.incrementDataRouted(context.getChannel().getChannelId(), statsDataCount);
                        statsDataCount = 0;
                        this.statisticManager.incrementDataEventInserted(context.getChannel().getChannelId(), statsDataEventCount);
                        statsDataEventCount = 0;
                    }
                    break;
                }
                var15_12 = null;
                context.incrementStat(System.currentTimeMillis() - insertTs, "data.events.insert.time.ms");
                if (statsDataCount <= 1024) continue;
                this.statisticManager.incrementDataRouted(context.getChannel().getChannelId(), statsDataCount);
                statsDataCount = 0;
                this.statisticManager.incrementDataEventInserted(context.getChannel().getChannelId(), statsDataEventCount);
                statsDataEventCount = 0;
                {
                }
            } while (data != null);
            Object var17_14 = null;
            reader.setReading(false);
            if (statsDataCount > 0) {
                this.statisticManager.incrementDataRouted(context.getChannel().getChannelId(), statsDataCount);
            }
            if (statsDataEventCount > 0) {
                this.statisticManager.incrementDataEventInserted(context.getChannel().getChannelId(), statsDataEventCount);
            }
        }
        catch (Throwable throwable) {
            Object var17_15 = null;
            reader.setReading(false);
            if (statsDataCount > 0) {
                this.statisticManager.incrementDataRouted(context.getChannel().getChannelId(), statsDataCount);
            }
            if (statsDataEventCount > 0) {
                this.statisticManager.incrementDataEventInserted(context.getChannel().getChannelId(), statsDataEventCount);
            }
            throw throwable;
        }
        context.incrementStat(totalDataCount, "data.routed.count");
        return totalDataEventCount;
    }

    protected int routeData(Data data, ChannelRouterContext context) throws SQLException {
        int numberOfDataEventsInserted = 0;
        context.recordTransactionBoundaryEncountered(data);
        List<TriggerRouter> triggerRouters = this.getTriggerRoutersForData(data);
        if (triggerRouters != null && triggerRouters.size() > 0) {
            for (TriggerRouter triggerRouter : triggerRouters) {
                Table table = this.dbDialect.getTable(triggerRouter.getTrigger(), true);
                DataMetaData dataMetaData = new DataMetaData(data, table, triggerRouter, context.getChannel());
                Set<String> nodeIds = null;
                if (!context.getChannel().isIgnoreEnabled() && triggerRouter.isRouted(data.getEventType())) {
                    IDataRouter dataRouter = this.getDataRouter(triggerRouter);
                    context.addUsedDataRouter(dataRouter);
                    long ts = System.currentTimeMillis();
                    nodeIds = dataRouter.routeToNodes(context, dataMetaData, this.findAvailableNodes(triggerRouter, context), false);
                    context.incrementStat(System.currentTimeMillis() - ts, "data.router.time.ms");
                    if (!triggerRouter.isPingBackEnabled() && data.getSourceNodeId() != null && nodeIds != null) {
                        nodeIds.remove(data.getSourceNodeId());
                    }
                }
                numberOfDataEventsInserted += this.insertDataEvents(context, dataMetaData, nodeIds, triggerRouter);
            }
        } else {
            this.log.warn("TriggerProcessingFailedMissing", data.getTriggerHistory().getTriggerId(), data.getDataId());
        }
        context.incrementStat(numberOfDataEventsInserted, "data.events.insert.count");
        return numberOfDataEventsInserted;
    }

    protected int insertDataEvents(ChannelRouterContext context, DataMetaData dataMetaData, Collection<String> nodeIds, TriggerRouter triggerRouter) {
        int numberOfDataEventsInserted = 0;
        if (nodeIds == null || nodeIds.size() == 0) {
            nodeIds = new HashSet<String>(1);
            nodeIds.add("-1");
        }
        long ts = System.currentTimeMillis();
        for (String nodeId : nodeIds) {
            Map<String, OutgoingBatch> batches = context.getBatchesByNodes();
            OutgoingBatch batch = batches.get(nodeId);
            if (batch == null) {
                batch = new OutgoingBatch(nodeId, dataMetaData.getNodeChannel().getChannelId(), OutgoingBatch.Status.RT);
                this.outgoingBatchService.insertOutgoingBatch(batch);
                context.getBatchesByNodes().put(nodeId, batch);
            }
            batch.incrementEventCount(dataMetaData.getData().getEventType());
            batch.incrementDataEventCount();
            ++numberOfDataEventsInserted;
            context.addDataEvent(dataMetaData.getData().getDataId(), batch.getBatchId(), triggerRouter.getRouter().getRouterId());
            if (!this.batchAlgorithms.get(context.getChannel().getBatchAlgorithm()).isBatchComplete(batch, dataMetaData, context)) continue;
            context.setNeedsCommitted(true);
        }
        context.incrementStat(System.currentTimeMillis() - ts, "data.events.insert.time.ms");
        return numberOfDataEventsInserted;
    }

    protected IDataRouter getDataRouter(TriggerRouter trigger) {
        IDataRouter router = null;
        if (!StringUtils.isBlank((String)trigger.getRouter().getRouterType()) && (router = this.routers.get(trigger.getRouter().getRouterType())) == null) {
            this.log.warn("RouterMissing", trigger.getRouter().getRouterType(), trigger.getTrigger().getTriggerId());
        }
        if (router == null) {
            return this.routers.get("default");
        }
        return router;
    }

    protected List<TriggerRouter> getTriggerRoutersForData(Data data) {
        List<TriggerRouter> triggerRouters = null;
        if (data != null) {
            if (data.getTriggerHistory() != null) {
                triggerRouters = this.triggerRouterService.getTriggerRoutersForCurrentNode(false).get(data.getTriggerHistory().getTriggerId());
                if (triggerRouters == null || triggerRouters.size() == 0) {
                    triggerRouters = this.triggerRouterService.getTriggerRoutersForCurrentNode(true).get(data.getTriggerHistory().getTriggerId());
                }
            } else {
                this.log.warn("TriggerHistMissing", data.getDataId());
            }
        }
        return triggerRouters;
    }

    @Override
    public void addDataRouter(String name, IDataRouter dataRouter) {
        this.routers.put(name, dataRouter);
    }

    @Override
    public void addBatchAlgorithm(String name, IBatchAlgorithm algorithm) {
        this.batchAlgorithms.put(name, algorithm);
    }

    @Override
    public long getUnroutedDataCount() {
        long maxDataIdAlreadyRouted = 0L;
        maxDataIdAlreadyRouted = this.dataToRouteReaderFactory.isUsingDataRef() ? this.jdbcTemplate.queryForLong(this.getSql("selectLastDataIdRoutedUsingDataRefSql")) : this.jdbcTemplate.queryForLong(this.getSql("selectLastDataIdRoutedUsingDataGapSql"));
        long leftToRoute = this.dataService.findMaxDataId() - maxDataIdAlreadyRouted;
        if (leftToRoute > 0L) {
            return leftToRoute;
        }
        return 0L;
    }

    @Override
    public List<String> getAvailableBatchAlgorithms() {
        return new ArrayList<String>(this.batchAlgorithms.keySet());
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setOutgoingBatchService(IOutgoingBatchService outgoingBatchService) {
        this.outgoingBatchService = outgoingBatchService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDataService(IDataService dataService) {
        this.dataService = dataService;
    }

    public void setRouters(Map<String, IDataRouter> routers) {
        this.routers = routers;
    }

    public void setBatchAlgorithms(Map<String, IBatchAlgorithm> batchAlgorithms) {
        this.batchAlgorithms = batchAlgorithms;
    }

    public void setTriggerRouterService(ITriggerRouterService triggerService) {
        this.triggerRouterService = triggerService;
    }

    public void setDataToRouteReaderFactory(DataToRouteReaderFactory dataToRouteReaderFactory) {
        this.dataToRouteReaderFactory = dataToRouteReaderFactory;
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }
}

