/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jumpmind.symmetric.model.NodeStatus;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IPurgeService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgeService
extends AbstractService
implements IPurgeService {
    private static final String PARAM_MAX = "MAX";
    private static final String PARAM_MIN = "MIN";
    private static final String PARAM_CUTOFF_TIME = "CUTOFF_TIME";
    private IClusterService clusterService;
    private INodeService nodeService;
    private IStatisticManager statisticManager;

    @Override
    public long purgeOutgoing() {
        long rowsPurged = 0L;
        if (this.nodeService.isRegistrationServer() || this.nodeService.getNodeStatus() == NodeStatus.DATA_LOAD_COMPLETED) {
            Calendar retentionCutoff = Calendar.getInstance();
            retentionCutoff.add(12, -this.parameterService.getInt("purge.retention.minutes"));
            rowsPurged += this.purgeOutgoing(retentionCutoff);
        } else {
            this.log.warn("DataPurgeSkippingNoInitialLoad");
        }
        return rowsPurged;
    }

    @Override
    public long purgeIncoming() {
        long rowsPurged = 0L;
        if (this.nodeService.isRegistrationServer() || this.nodeService.getNodeStatus() == NodeStatus.DATA_LOAD_COMPLETED) {
            Calendar retentionCutoff = Calendar.getInstance();
            retentionCutoff.add(12, -this.parameterService.getInt("purge.retention.minutes"));
            rowsPurged += this.purgeIncoming(retentionCutoff);
        } else {
            this.log.warn("DataPurgeSkippingNoInitialLoad");
        }
        return rowsPurged;
    }

    @Override
    public long purgeDataGaps() {
        long rowsPurged = 0L;
        if (this.nodeService.isRegistrationServer() || this.nodeService.getNodeStatus() == NodeStatus.DATA_LOAD_COMPLETED) {
            Calendar retentionCutoff = Calendar.getInstance();
            retentionCutoff.add(12, -this.parameterService.getInt("routing.data.reader.type.gap.retention.period.minutes"));
            rowsPurged += this.purgeDataGaps(retentionCutoff);
        } else {
            this.log.warn("DataPurgeSkippingNoInitialLoad");
        }
        return rowsPurged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long purgeDataGaps(Calendar retentionCutoff) {
        long rowsPurged;
        block5: {
            rowsPurged = -1L;
            try {
                if (this.clusterService.lock("PURGE_DATA_GAPS")) {
                    try {
                        this.log.info("DataPurgeDataGapsRunning");
                        rowsPurged = this.jdbcTemplate.update(this.getSql("deleteFromDataGapsSql"), new Object[]{retentionCutoff.getTime()});
                        this.log.info("DataPurgeDataGapsRun", rowsPurged);
                        Object var5_3 = null;
                        this.clusterService.unlock("PURGE_DATA_GAPS");
                        this.log.info("DataPurgeDataGapsCompleted");
                        break block5;
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        this.clusterService.unlock("PURGE_DATA_GAPS");
                        this.log.info("DataPurgeDataGapsCompleted");
                        throw throwable;
                    }
                }
                this.log.warn("DataPurgeDataGapsRunningFailedLock");
            }
            catch (Exception ex) {
                this.log.error(ex);
            }
        }
        return rowsPurged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long purgeOutgoing(Calendar retentionCutoff) {
        long rowsPurged;
        block5: {
            rowsPurged = 0L;
            try {
                if (this.clusterService.lock("PURGE_OUTGOING")) {
                    try {
                        this.log.info("DataPurgeOutgoingRunning", SimpleDateFormat.getDateTimeInstance().format(retentionCutoff.getTime()));
                        rowsPurged += this.purgeStrandedBatches();
                        rowsPurged += this.purgeDataRows(retentionCutoff);
                        rowsPurged += this.purgeOutgoingBatch(retentionCutoff);
                        Object var5_3 = null;
                        this.clusterService.unlock("PURGE_OUTGOING");
                        this.log.info("DataPurgeOutgoingCompleted");
                        break block5;
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        this.clusterService.unlock("PURGE_OUTGOING");
                        this.log.info("DataPurgeOutgoingCompleted");
                        throw throwable;
                    }
                }
                this.log.info("DataPurgeOutgoingRunningFailedLock");
            }
            catch (Exception ex) {
                this.log.error(ex);
            }
        }
        return rowsPurged;
    }

    private long purgeOutgoingBatch(Calendar time) {
        this.log.info("DataPurgeOutgoingRange");
        long[] minMax = this.queryForMinMax(this.getSql("selectOutgoingBatchRangeSql"), new Object[]{time.getTime()});
        int maxNumOfBatchIdsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.batches.to.delete.in.tx");
        int maxNumOfDataEventsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.data.events.to.delete.in.tx");
        int dataEventsPurgedCount = this.purgeByMinMax(minMax, this.getSql("deleteDataEventSql"), time.getTime(), maxNumOfDataEventsToPurgeInTx);
        this.statisticManager.incrementPurgedDataEventRows(dataEventsPurgedCount);
        int outgoingbatchPurgedCount = this.purgeByMinMax(minMax, this.getSql("deleteOutgoingBatchSql"), time.getTime(), maxNumOfBatchIdsToPurgeInTx);
        this.statisticManager.incrementPurgedBatchOutgoingRows(outgoingbatchPurgedCount);
        long unroutedPurgedCount = this.purgeUnroutedDataEvents(time.getTime());
        return (long)(dataEventsPurgedCount + outgoingbatchPurgedCount) + unroutedPurgedCount;
    }

    private long purgeStrandedBatches() {
        int updateStrandedBatchesCount = this.getSimpleTemplate().update(this.getSql("updateStrandedBatches"), new Object[0]);
        if (updateStrandedBatchesCount > 0) {
            this.log.info("DataPurgeUpdatedStrandedBatches", updateStrandedBatchesCount);
            this.statisticManager.incrementPurgedBatchOutgoingRows(updateStrandedBatchesCount);
        }
        return updateStrandedBatchesCount;
    }

    private long purgeUnroutedDataEvents(Date time) {
        HashMap<String, Timestamp> params = new HashMap<String, Timestamp>();
        params.put(PARAM_CUTOFF_TIME, new Timestamp(time.getTime()));
        int unroutedDataEventCount = this.getSimpleTemplate().update(this.getSql("deleteUnroutedDataEventSql"), params);
        if (unroutedDataEventCount > 0) {
            this.statisticManager.incrementPurgedDataEventRows(unroutedDataEventCount);
            this.log.info("DataPurgeTableCompleted", unroutedDataEventCount, "unrouted data_event");
        }
        return unroutedDataEventCount;
    }

    private long purgeDataRows(Calendar time) {
        this.log.info("DataPurgeRowsRange");
        long[] minMax = this.queryForMinMax(this.getSql("selectDataRangeSql"), new Object[0]);
        int maxNumOfDataIdsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.data.to.delete.in.tx");
        int dataDeletedCount = this.purgeByMinMax(minMax, this.getSql("deleteDataSql"), time.getTime(), maxNumOfDataIdsToPurgeInTx);
        this.statisticManager.incrementPurgedDataRows(dataDeletedCount);
        int strandedDeletedCount = this.purgeByMinMax(minMax, this.getSql("deleteStrandedData"), time.getTime(), maxNumOfDataIdsToPurgeInTx);
        this.statisticManager.incrementPurgedDataRows(strandedDeletedCount);
        return dataDeletedCount + strandedDeletedCount;
    }

    private long[] queryForMinMax(String sql, Object[] params) {
        long[] minMax = (long[])this.jdbcTemplate.queryForObject(sql, params, (RowMapper)new RowMapper<long[]>(){

            public long[] mapRow(ResultSet rs, int row) throws SQLException {
                return new long[]{rs.getLong(1), rs.getLong(2)};
            }
        });
        return minMax;
    }

    private int purgeByMinMax(long[] minMax, String deleteSql, Date retentionTime, int maxNumtoPurgeinTx) {
        long minId = minMax[0];
        long purgeUpToId = minMax[1];
        long ts = System.currentTimeMillis();
        int totalCount = 0;
        int totalDeleteStmts = 0;
        String tableName = deleteSql.trim().split("\\s")[2];
        this.log.info("DataPurgeTableStarting", tableName);
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.registerSqlType(PARAM_CUTOFF_TIME, 93);
        parameterSource.registerSqlType(PARAM_MIN, 4);
        parameterSource.registerSqlType(PARAM_MAX, 4);
        parameterSource.addValue(PARAM_CUTOFF_TIME, (Object)new Timestamp(retentionTime.getTime()));
        while (minId <= purgeUpToId) {
            ++totalDeleteStmts;
            long maxId = minId + (long)maxNumtoPurgeinTx;
            if (maxId > purgeUpToId) {
                maxId = purgeUpToId;
            }
            parameterSource.addValue(PARAM_MIN, (Object)minId);
            parameterSource.addValue(PARAM_MAX, (Object)maxId);
            if ((totalCount += this.getSimpleTemplate().update(deleteSql, (SqlParameterSource)parameterSource)) > 0 && System.currentTimeMillis() - ts > 300000L) {
                this.log.info("DataPurgeTableRunning", totalCount, tableName, totalDeleteStmts);
                ts = System.currentTimeMillis();
            }
            minId = maxId + 1L;
        }
        this.log.info("DataPurgeTableCompleted", totalCount, tableName);
        return totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long purgeIncoming(Calendar retentionCutoff) {
        long purgedRowCount;
        block5: {
            purgedRowCount = 0L;
            try {
                if (this.clusterService.lock("PURGE_INCOMING")) {
                    try {
                        this.log.info("DataPurgeIncomingRunning");
                        purgedRowCount = this.purgeIncomingBatch(retentionCutoff);
                        Object var5_3 = null;
                        this.clusterService.unlock("PURGE_INCOMING");
                        this.log.info("DataPurgeIncomingCompleted");
                        break block5;
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        this.clusterService.unlock("PURGE_INCOMING");
                        this.log.info("DataPurgeIncomingCompleted");
                        throw throwable;
                    }
                }
                this.log.info("DataPurgeIncomingRunningFailed");
            }
            catch (Exception ex) {
                this.log.error(ex);
            }
        }
        return purgedRowCount;
    }

    private long purgeIncomingBatch(Calendar time) {
        this.log.info("DataPurgeIncomingRange");
        List nodeBatchRangeList = this.jdbcTemplate.query(this.getSql("selectIncomingBatchRangeSql"), new Object[]{time.getTime()}, (RowMapper)new RowMapper<NodeBatchRange>(){

            public NodeBatchRange mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new NodeBatchRange(rs.getString(1), rs.getLong(2), rs.getLong(3));
            }
        });
        int incomingBatchesPurgedCount = this.purgeByNodeBatchRangeList(this.getSql("deleteIncomingBatchSql"), nodeBatchRangeList);
        this.statisticManager.incrementPurgedBatchIncomingRows(incomingBatchesPurgedCount);
        return incomingBatchesPurgedCount;
    }

    private int purgeByNodeBatchRangeList(String deleteSql, List<NodeBatchRange> nodeBatchRangeList) {
        long ts = System.currentTimeMillis();
        int totalCount = 0;
        int totalDeleteStmts = 0;
        String tableName = deleteSql.trim().split("\\s")[2];
        this.log.info("DataPurgeTableStarting", tableName);
        for (NodeBatchRange nodeBatchRange : nodeBatchRangeList) {
            int maxNumOfDataIdsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.batches.to.delete.in.tx");
            long minBatchId = nodeBatchRange.getMinBatchId();
            long purgeUpToBatchId = nodeBatchRange.getMaxBatchId();
            while (minBatchId <= purgeUpToBatchId) {
                ++totalDeleteStmts;
                long maxBatchId = minBatchId + (long)maxNumOfDataIdsToPurgeInTx;
                if (maxBatchId > purgeUpToBatchId) {
                    maxBatchId = purgeUpToBatchId;
                }
                totalCount += this.jdbcTemplate.update(deleteSql, new Object[]{minBatchId, maxBatchId, nodeBatchRange.getNodeId()});
                minBatchId = maxBatchId + 1L;
            }
            if (totalCount <= 0 || System.currentTimeMillis() - ts <= 300000L) continue;
            this.log.info("DataPurgeTableRunning", totalCount, tableName, totalDeleteStmts);
            ts = System.currentTimeMillis();
        }
        this.log.info("DataPurgeTableCompleted", totalCount, tableName);
        return totalCount;
    }

    @Override
    public void purgeAllIncomingEventsForNode(String nodeId) {
        int count = this.jdbcTemplate.update(this.getSql("deleteIncomingBatchByNodeSql"), new Object[]{nodeId});
        this.log.info("DataPurgeIncomingAllCompleted", count, nodeId);
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }

    class NodeBatchRange {
        private String nodeId;
        private long minBatchId;
        private long maxBatchId;

        public NodeBatchRange(String nodeId, long minBatchId, long maxBatchId) {
            this.nodeId = nodeId;
            this.minBatchId = minBatchId;
            this.maxBatchId = maxBatchId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public long getMaxBatchId() {
            return this.maxBatchId;
        }

        public long getMinBatchId() {
            return this.minBatchId;
        }
    }
}

