/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.OutgoingBatchSummary;
import org.jumpmind.symmetric.model.OutgoingBatches;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.util.MaxRowsStatementCreator;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutgoingBatchService
extends AbstractService
implements IOutgoingBatchService {
    private INodeService nodeService;
    private IConfigurationService configurationService;

    @Override
    @Transactional
    public void markAllAsSentForNode(Node node) {
        OutgoingBatches batches = null;
        do {
            batches = this.getOutgoingBatches(node);
            for (OutgoingBatch outgoingBatch : batches.getBatches()) {
                outgoingBatch.setStatus(OutgoingBatch.Status.OK);
                outgoingBatch.setErrorFlag(false);
                this.updateOutgoingBatch(outgoingBatch);
            }
        } while (batches.getBatches().size() > 0);
    }

    @Override
    public void updateAbandonedRoutingBatches() {
        this.jdbcTemplate.update(this.getSql("updateOutgoingBatchesStatusSql"), new Object[]{OutgoingBatch.Status.NE.name(), OutgoingBatch.Status.RT.name()});
    }

    @Override
    public void updateOutgoingBatches(List<OutgoingBatch> outgoingBatches) {
        for (OutgoingBatch batch : outgoingBatches) {
            this.updateOutgoingBatch(batch);
        }
    }

    @Override
    public void updateOutgoingBatch(OutgoingBatch outgoingBatch) {
        outgoingBatch.setLastUpdatedTime(new Date());
        outgoingBatch.setLastUpdatedHostName(AppUtils.getServerId());
        this.jdbcTemplate.update(this.getSql("updateOutgoingBatchSql"), new Object[]{outgoingBatch.getStatus().name(), outgoingBatch.isLoadFlag() ? 1 : 0, outgoingBatch.isErrorFlag() ? 1 : 0, outgoingBatch.getByteCount(), outgoingBatch.getExtractCount(), outgoingBatch.getSentCount(), outgoingBatch.getLoadCount(), outgoingBatch.getDataEventCount(), outgoingBatch.getReloadEventCount(), outgoingBatch.getInsertEventCount(), outgoingBatch.getUpdateEventCount(), outgoingBatch.getDeleteEventCount(), outgoingBatch.getOtherEventCount(), outgoingBatch.getRouterMillis(), outgoingBatch.getNetworkMillis(), outgoingBatch.getFilterMillis(), outgoingBatch.getLoadMillis(), outgoingBatch.getExtractMillis(), outgoingBatch.getSqlState(), outgoingBatch.getSqlCode(), StringUtils.abbreviate((String)outgoingBatch.getSqlMessage(), (int)1000), outgoingBatch.getFailedDataId(), outgoingBatch.getLastUpdatedHostName(), outgoingBatch.getLastUpdatedTime(), outgoingBatch.getBatchId()}, new int[]{1, 4, 4, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5, 12, 4, 12, -5, 12, 93, 4});
    }

    @Override
    public void insertOutgoingBatch(final OutgoingBatch outgoingBatch) {
        outgoingBatch.setLastUpdatedHostName(AppUtils.getServerId());
        long batchId = this.dbDialect.insertWithGeneratedKey(this.jdbcTemplate, this.getSql("insertOutgoingBatchSql"), SequenceIdentifier.OUTGOING_BATCH, new PreparedStatementCallback<Object>(){

            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                ps.setString(1, outgoingBatch.getNodeId());
                ps.setString(2, outgoingBatch.getChannelId());
                ps.setString(3, outgoingBatch.getStatus().name());
                ps.setInt(4, outgoingBatch.isLoadFlag() ? 1 : 0);
                ps.setLong(5, outgoingBatch.getReloadEventCount());
                ps.setLong(6, outgoingBatch.getOtherEventCount());
                ps.setString(7, outgoingBatch.getLastUpdatedHostName());
                return null;
            }
        });
        outgoingBatch.setBatchId(batchId);
    }

    @Override
    public OutgoingBatch findOutgoingBatch(long batchId) {
        List list = this.jdbcTemplate.query(this.getSql("selectOutgoingBatchPrefixSql", "findOutgoingBatchSql"), new Object[]{batchId}, new int[]{4}, (RowMapper)new OutgoingBatchMapper());
        if (list != null && list.size() > 0) {
            return (OutgoingBatch)list.get(0);
        }
        return null;
    }

    @Override
    public int countOutgoingBatchesInError() {
        return this.jdbcTemplate.queryForInt(this.getSql("countOutgoingBatchesErrorsSql"));
    }

    @Override
    public int countOutgoingBatches(List<String> nodeIds, List<String> channels, List<OutgoingBatch.Status> statuses) {
        if (nodeIds.size() > 0 && channels.size() > 0 && statuses.size() > 0) {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("NODES", nodeIds);
            params.put("CHANNELS", channels);
            params.put("STATUSES", this.toStringList(statuses));
            return new SimpleJdbcTemplate(this.dataSource).queryForInt(this.getSql("selectCountBatchesPrefixSql", this.containsOnlyErrorStatus(statuses) ? "selectOutgoingBatchByChannelWithErrorSql" : "selectOutgoingBatchByChannelAndStatusSql"), params);
        }
        return 0;
    }

    @Override
    public List<OutgoingBatch> listOutgoingBatches(List<String> nodeIds, List<String> channels, List<OutgoingBatch.Status> statuses, long startAtBatchId, final int maxRowsToRetrieve) {
        if (nodeIds.size() > 0 && channels.size() > 0 && statuses.size() > 0) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("NODES", nodeIds);
            params.put("CHANNELS", channels);
            params.put("STATUSES", this.toStringList(statuses));
            String startAtBatchIdSql = null;
            if (startAtBatchId > 0L) {
                params.put("BATCH_ID", startAtBatchId);
                startAtBatchIdSql = " and batch_id < :BATCH_ID ";
            }
            NamedParameterJdbcTemplate template = new NamedParameterJdbcTemplate(this.dataSource);
            ResultSetExtractor<List<OutgoingBatch>> extractor = new ResultSetExtractor<List<OutgoingBatch>>(){
                OutgoingBatchMapper rowMapper;
                {
                    this.rowMapper = new OutgoingBatchMapper();
                }

                public List<OutgoingBatch> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<OutgoingBatch> list = new ArrayList<OutgoingBatch>(maxRowsToRetrieve);
                    int count = 0;
                    while (rs.next() && count < maxRowsToRetrieve) {
                        list.add(this.rowMapper.mapRow(rs, ++count));
                    }
                    return list;
                }
            };
            List list = (List)template.query(this.getSql("selectOutgoingBatchPrefixSql", this.containsOnlyErrorStatus(statuses) ? "selectOutgoingBatchByChannelWithErrorSql" : "selectOutgoingBatchByChannelAndStatusSql", startAtBatchIdSql, " order by batch_id desc"), (SqlParameterSource)new MapSqlParameterSource(params), (ResultSetExtractor)extractor);
            return list;
        }
        return new ArrayList<OutgoingBatch>(0);
    }

    protected boolean containsOnlyErrorStatus(List<OutgoingBatch.Status> statuses) {
        return statuses.size() == 1 && statuses.get(0) == OutgoingBatch.Status.ER;
    }

    protected List<String> toStringList(List<OutgoingBatch.Status> statuses) {
        ArrayList<String> statusStrings = new ArrayList<String>(statuses.size());
        for (OutgoingBatch.Status status : statuses) {
            statusStrings.add(status.name());
        }
        return statusStrings;
    }

    @Override
    public OutgoingBatches getOutgoingBatches(Node node) {
        long ts = System.currentTimeMillis();
        final int maxNumberOfBatchesToSelect = this.parameterService.getInt("outgoing.batches.max.to.select", 1000);
        List list = (List)this.jdbcTemplate.query(this.getSql("selectOutgoingBatchPrefixSql", "selectOutgoingBatchSql"), new Object[]{node.getNodeId(), OutgoingBatch.Status.NE.name(), OutgoingBatch.Status.QY.name(), OutgoingBatch.Status.SE.name(), OutgoingBatch.Status.LD.name(), OutgoingBatch.Status.ER.name()}, (ResultSetExtractor)new ResultSetExtractor<List<OutgoingBatch>>(){
            RowMapper<OutgoingBatch> mapper;
            {
                this.mapper = new OutgoingBatchMapper();
            }

            public List<OutgoingBatch> extractData(ResultSet rs) throws SQLException {
                ArrayList<OutgoingBatch> results = new ArrayList<OutgoingBatch>();
                int rowNum = 0;
                while (rs.next()) {
                    results.add((OutgoingBatch)this.mapper.mapRow(rs, rowNum++));
                    if (rowNum < maxNumberOfBatchesToSelect) continue;
                    break;
                }
                return results;
            }
        });
        OutgoingBatches batches = new OutgoingBatches(list);
        List<NodeChannel> channels = this.configurationService.getNodeChannels(node.getNodeId(), true);
        batches.sortChannels(channels);
        ArrayList<OutgoingBatch> keepers = new ArrayList<OutgoingBatch>();
        for (NodeChannel channel : channels) {
            if (!this.parameterService.is("dataextractor.enable") && !channel.getChannelId().equals("config")) continue;
            keepers.addAll(batches.getBatchesForChannelWindows(node, channel, this.configurationService.getNodeGroupChannelWindows(this.parameterService.getNodeGroupId(), channel.getChannelId())));
        }
        batches.setBatches(keepers);
        long executeTimeInMs = System.currentTimeMillis() - ts;
        if (executeTimeInMs > 30000L) {
            this.log.warn("LongRunningOperation", "selecting batches to extract", executeTimeInMs);
        }
        return batches;
    }

    @Override
    public OutgoingBatches getOutgoingBatchRange(String startBatchId, String endBatchId) {
        OutgoingBatches batches = new OutgoingBatches();
        batches.setBatches(this.jdbcTemplate.query(this.getSql("selectOutgoingBatchPrefixSql", "selectOutgoingBatchRangeSql"), new Object[]{Long.parseLong(startBatchId), Long.parseLong(endBatchId)}, (RowMapper)new OutgoingBatchMapper()));
        return batches;
    }

    @Override
    public OutgoingBatches getOutgoingBatchErrors(int maxRows) {
        OutgoingBatches batches = new OutgoingBatches();
        batches.setBatches(this.jdbcTemplate.query((PreparedStatementCreator)new MaxRowsStatementCreator(this.getSql("selectOutgoingBatchPrefixSql", "selectOutgoingBatchErrorsSql"), maxRows), (RowMapper)new OutgoingBatchMapper()));
        return batches;
    }

    @Override
    public boolean isInitialLoadComplete(String nodeId) {
        return this.areAllLoadBatchesComplete(nodeId) && !this.isUnsentDataOnChannelForNode("config", nodeId);
    }

    @Override
    public boolean areAllLoadBatchesComplete(String nodeId) {
        NodeSecurity security = this.nodeService.findNodeSecurity(nodeId);
        if (security == null || security.isInitialLoadEnabled()) {
            return false;
        }
        List statuses = this.jdbcTemplate.queryForList(this.getSql("initialLoadStatusSql"), new Object[]{nodeId, 1}, String.class);
        if (statuses == null || statuses.size() == 0) {
            throw new RuntimeException("The initial load has not been started for " + nodeId);
        }
        for (String status : statuses) {
            if (OutgoingBatch.Status.OK.name().equals(status)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUnsentDataOnChannelForNode(String channelId, String nodeId) {
        int unsentCount = this.jdbcTemplate.queryForInt(this.getSql("unsentBatchesForNodeIdChannelIdSql"), new Object[]{nodeId, channelId});
        return unsentCount > 0;
    }

    @Override
    public List<OutgoingBatchSummary> findOutgoingBatchSummary(OutgoingBatch.Status ... statuses) {
        ArrayList<String> statusList = new ArrayList<String>();
        for (OutgoingBatch.Status status : statuses) {
            statusList.add(status.name());
        }
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        params.put("STATUS_LIST", statusList);
        return this.getSimpleTemplate().query(this.getSql("selectOutgoingBatchSummaryByStatusSql"), (RowMapper)new OutgoingBatchSummaryMapper(), params);
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OutgoingBatchMapper
    implements RowMapper<OutgoingBatch> {
        public OutgoingBatch mapRow(ResultSet rs, int num) throws SQLException {
            OutgoingBatch batch = new OutgoingBatch();
            batch.setNodeId(rs.getString(1));
            batch.setChannelId(rs.getString(2));
            batch.setStatus(rs.getString(3));
            batch.setByteCount(rs.getLong(4));
            batch.setExtractCount(rs.getLong(5));
            batch.setSentCount(rs.getLong(6));
            batch.setLoadCount(rs.getLong(7));
            batch.setDataEventCount(rs.getLong(8));
            batch.setReloadEventCount(rs.getLong(9));
            batch.setInsertEventCount(rs.getLong(10));
            batch.setUpdateEventCount(rs.getLong(11));
            batch.setDeleteEventCount(rs.getLong(12));
            batch.setOtherEventCount(rs.getLong(13));
            batch.setRouterMillis(rs.getLong(14));
            batch.setNetworkMillis(rs.getLong(15));
            batch.setFilterMillis(rs.getLong(16));
            batch.setLoadMillis(rs.getLong(17));
            batch.setExtractMillis(rs.getLong(18));
            batch.setSqlState(rs.getString(19));
            batch.setSqlCode(rs.getInt(20));
            batch.setSqlMessage(rs.getString(21));
            batch.setFailedDataId(rs.getLong(22));
            batch.setLastUpdatedHostName(rs.getString(23));
            batch.setLastUpdatedTime(rs.getTimestamp(24));
            batch.setCreateTime(rs.getTimestamp(25));
            batch.setBatchId(rs.getLong(26));
            batch.setLoadFlag(rs.getBoolean(27));
            batch.setErrorFlag(rs.getBoolean(28));
            return batch;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OutgoingBatchSummaryMapper
    implements RowMapper<OutgoingBatchSummary> {
        OutgoingBatchSummaryMapper() {
        }

        public OutgoingBatchSummary mapRow(ResultSet rs, int rowNum) throws SQLException {
            OutgoingBatchSummary summary = new OutgoingBatchSummary();
            summary.setBatchCount(rs.getInt(1));
            summary.setDataCount(rs.getInt(2));
            summary.setStatus(OutgoingBatch.Status.valueOf(rs.getString(3)));
            summary.setNodeId(rs.getString(4));
            summary.setOldestBatchCreateTime(rs.getTimestamp(5));
            return summary;
        }
    }
}

