/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.util.AppUtils;
import org.jumpmind.symmetric.util.MaxRowsStatementCreator;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomingBatchService
extends AbstractService
implements IIncomingBatchService {
    @Override
    public IncomingBatch findIncomingBatch(long batchId, String nodeId) {
        try {
            return (IncomingBatch)this.jdbcTemplate.queryForObject(this.getSql("selectIncomingBatchPrefixSql", "findIncomingBatchSql"), new Object[]{batchId, nodeId}, (RowMapper)new IncomingBatchMapper());
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public int countIncomingBatchesInError() {
        return this.jdbcTemplate.queryForInt(this.getSql("countIncomingBatchesErrorsSql"));
    }

    @Override
    public List<IncomingBatch> findIncomingBatchErrors(int maxRows) {
        return this.jdbcTemplate.query((PreparedStatementCreator)new MaxRowsStatementCreator(this.getSql("selectIncomingBatchPrefixSql", "findIncomingBatchErrorsSql"), maxRows), (RowMapper)new IncomingBatchMapper());
    }

    @Override
    public List<Date> listIncomingBatchTimes(List<String> nodeIds, List<String> channels, List<IncomingBatch.Status> statuses, Date startAtCreateTime) {
        if (nodeIds != null && nodeIds.size() > 0 && channels != null && channels.size() > 0 && statuses != null && statuses.size() > 0) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("NODES", nodeIds);
            params.put("CHANNELS", channels);
            params.put("STATUSES", this.toStringList(statuses));
            params.put("CREATE_TIME", startAtCreateTime);
            NamedParameterJdbcTemplate template = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
            return template.query(this.getSql("selectCreateTimePrefixSql", this.containsOnlyErrorStatus(statuses) ? "listIncomingBatchesInErrorSql" : "listIncomingBatchesSql"), params, (RowMapper)new SingleColumnRowMapper());
        }
        return new ArrayList<Date>(0);
    }

    @Override
    @Transactional
    public void markIncomingBatchesOk(String nodeId) {
        List<IncomingBatch> batches = this.listIncomingBatchesInErrorFor(nodeId);
        for (IncomingBatch incomingBatch : batches) {
            incomingBatch.setErrorFlag(false);
            incomingBatch.setStatus(IncomingBatch.Status.OK);
            this.updateIncomingBatch(incomingBatch);
        }
    }

    @Override
    public List<IncomingBatch> listIncomingBatchesInErrorFor(String nodeId) {
        return this.jdbcTemplate.query(this.getSql("selectIncomingBatchPrefixSql", "listIncomingBatchesInErrorForNodeSql"), (RowMapper)new IncomingBatchMapper(), new Object[]{nodeId});
    }

    @Override
    public List<IncomingBatch> listIncomingBatches(List<String> nodeIds, List<String> channels, List<IncomingBatch.Status> statuses, Date startAtCreateTime, final int maxRowsToRetrieve) {
        if (nodeIds != null && nodeIds.size() > 0 && channels != null && channels.size() > 0 && statuses != null && statuses.size() > 0) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("NODES", nodeIds);
            params.put("CHANNELS", channels);
            params.put("STATUSES", this.toStringList(statuses));
            params.put("CREATE_TIME", startAtCreateTime);
            NamedParameterJdbcTemplate template = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
            ResultSetExtractor<List<IncomingBatch>> extractor = new ResultSetExtractor<List<IncomingBatch>>(){
                IncomingBatchMapper rowMapper;
                {
                    this.rowMapper = new IncomingBatchMapper();
                }

                public List<IncomingBatch> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    ArrayList<IncomingBatch> list = new ArrayList<IncomingBatch>(maxRowsToRetrieve);
                    int count = 0;
                    while (rs.next() && count < maxRowsToRetrieve) {
                        list.add(this.rowMapper.mapRow(rs, ++count));
                    }
                    return list;
                }
            };
            List list = (List)template.query(this.getSql("selectIncomingBatchPrefixSql", this.containsOnlyErrorStatus(statuses) ? "listIncomingBatchesInErrorSql" : "listIncomingBatchesSql"), (SqlParameterSource)new MapSqlParameterSource(params), (ResultSetExtractor)extractor);
            return list;
        }
        return new ArrayList<IncomingBatch>(0);
    }

    protected boolean containsOnlyErrorStatus(List<IncomingBatch.Status> statuses) {
        return statuses.size() == 1 && statuses.get(0) == IncomingBatch.Status.ER;
    }

    protected List<String> toStringList(List<IncomingBatch.Status> statuses) {
        ArrayList<String> statusStrings = new ArrayList<String>(statuses.size());
        for (IncomingBatch.Status status : statuses) {
            statusStrings.add(status.name());
        }
        return statusStrings;
    }

    @Override
    public boolean acquireIncomingBatch(IncomingBatch batch) {
        boolean okayToProcess = true;
        if (batch.isPersistable()) {
            IncomingBatch existingBatch = null;
            try {
                this.insertIncomingBatch(batch);
            }
            catch (DataIntegrityViolationException e) {
                batch.setRetry(true);
                existingBatch = this.findIncomingBatch(batch.getBatchId(), batch.getNodeId());
            }
            if (batch.isRetry()) {
                if (existingBatch.getStatus() == IncomingBatch.Status.ER || existingBatch.getStatus() == IncomingBatch.Status.LD || !this.parameterService.is("incoming.batches.skip.duplicates")) {
                    okayToProcess = true;
                    existingBatch.setStatus(IncomingBatch.Status.LD);
                    this.updateIncomingBatch(existingBatch);
                    this.log.warn("BatchRetrying", batch.getNodeBatchId());
                } else {
                    okayToProcess = false;
                    batch.setStatus(existingBatch.getStatus());
                    batch.setSkipCount(existingBatch.getSkipCount() + 1L);
                    this.log.warn("BatchSkipping", batch.getNodeBatchId());
                }
            }
        }
        return okayToProcess;
    }

    @Override
    public void insertIncomingBatch(IncomingBatch batch) {
        if (batch.isPersistable()) {
            batch.setLastUpdatedHostName(AppUtils.getServerId());
            batch.setLastUpdatedTime(new Date());
            this.jdbcTemplate.update(this.getSql("insertIncomingBatchSql"), new Object[]{batch.getBatchId(), batch.getNodeId(), batch.getChannelId(), batch.getStatus().name(), batch.getNetworkMillis(), batch.getFilterMillis(), batch.getDatabaseMillis(), batch.getFailedRowNumber(), batch.getByteCount(), batch.getStatementCount(), batch.getFallbackInsertCount(), batch.getFallbackUpdateCount(), batch.getMissingDeleteCount(), batch.getSkipCount(), batch.getSqlState(), batch.getSqlCode(), StringUtils.abbreviate((String)batch.getSqlMessage(), (int)1000), batch.getLastUpdatedHostName(), batch.getLastUpdatedTime()});
        }
    }

    @Override
    public int updateIncomingBatch(IncomingBatch batch) {
        return this.updateIncomingBatch(this.jdbcTemplate, batch);
    }

    @Override
    public int updateIncomingBatch(JdbcTemplate template, IncomingBatch batch) {
        int count = 0;
        if (batch.isPersistable()) {
            if (batch.getStatus() == IncomingBatch.Status.ER) {
                batch.setErrorFlag(true);
            } else if (batch.getStatus() == IncomingBatch.Status.OK) {
                batch.setErrorFlag(false);
            }
            batch.setLastUpdatedHostName(AppUtils.getServerId());
            batch.setLastUpdatedTime(new Date());
            count = template.update(this.getSql("updateIncomingBatchSql"), new Object[]{batch.getStatus().name(), batch.isErrorFlag() ? 1 : 0, batch.getNetworkMillis(), batch.getFilterMillis(), batch.getDatabaseMillis(), batch.getFailedRowNumber(), batch.getByteCount(), batch.getStatementCount(), batch.getFallbackInsertCount(), batch.getFallbackUpdateCount(), batch.getMissingDeleteCount(), batch.getSkipCount(), batch.getSqlState(), batch.getSqlCode(), StringUtils.abbreviate((String)batch.getSqlMessage(), (int)1000), batch.getLastUpdatedHostName(), batch.getLastUpdatedTime(), batch.getBatchId(), batch.getNodeId()});
        }
        return count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IncomingBatchMapper
    implements RowMapper<IncomingBatch> {
        IncomingBatchMapper() {
        }

        public IncomingBatch mapRow(ResultSet rs, int num) throws SQLException {
            IncomingBatch batch = new IncomingBatch();
            batch.setBatchId(rs.getLong(1));
            batch.setNodeId(rs.getString(2));
            batch.setChannelId(rs.getString(3));
            batch.setStatus(IncomingBatch.Status.valueOf(rs.getString(4)));
            batch.setNetworkMillis(rs.getLong(5));
            batch.setFilterMillis(rs.getLong(6));
            batch.setDatabaseMillis(rs.getLong(7));
            batch.setFailedRowNumber(rs.getLong(8));
            batch.setByteCount(rs.getLong(9));
            batch.setStatementCount(rs.getLong(10));
            batch.setFallbackInsertCount(rs.getLong(11));
            batch.setFallbackUpdateCount(rs.getLong(12));
            batch.setMissingDeleteCount(rs.getLong(13));
            batch.setSkipCount(rs.getLong(14));
            batch.setSqlState(rs.getString(15));
            batch.setSqlCode(rs.getInt(16));
            batch.setSqlMessage(rs.getString(17));
            batch.setLastUpdatedHostName(rs.getString(18));
            batch.setLastUpdatedTime(rs.getTimestamp(19));
            batch.setCreateTime(rs.getTimestamp(20));
            batch.setErrorFlag(rs.getBoolean(21));
            return batch;
        }
    }
}

