/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.io.ThresholdFileWriter;
import org.jumpmind.symmetric.load.BatchListenerAdapter;
import org.jumpmind.symmetric.load.IBatchListener;
import org.jumpmind.symmetric.load.IColumnFilter;
import org.jumpmind.symmetric.load.IDataLoader;
import org.jumpmind.symmetric.load.IDataLoaderContext;
import org.jumpmind.symmetric.load.IDataLoaderFilter;
import org.jumpmind.symmetric.load.IDataLoaderStatistics;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.RemoteNodeStatus;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.RegistrationNotOpenException;
import org.jumpmind.symmetric.service.RegistrationRequiredException;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.AuthenticationException;
import org.jumpmind.symmetric.transport.ConnectionRejectedException;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.SyncDisabledException;
import org.jumpmind.symmetric.transport.TransportException;
import org.jumpmind.symmetric.transport.file.FileIncomingTransport;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;
import org.jumpmind.symmetric.transport.internal.InternalIncomingTransport;
import org.jumpmind.symmetric.util.AppUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataLoaderService
extends AbstractService
implements IDataLoaderService,
BeanFactoryAware {
    private IDbDialect dbDialect;
    private IIncomingBatchService incomingBatchService;
    private IConfigurationService configurationService;
    private ITransportManager transportManager;
    private BeanFactory beanFactory;
    private List<IDataLoaderFilter> filters;
    private IStatisticManager statisticManager;
    private INodeService nodeService;
    private Map<String, List<IColumnFilter>> columnFilters = new HashMap<String, List<IColumnFilter>>();
    private List<IBatchListener> batchListeners;

    public DataLoaderService() {
        this.addBatchListener(new LoadBatchResultsListener());
    }

    @Override
    public RemoteNodeStatus loadDataFromPull(Node remote) throws IOException {
        RemoteNodeStatus status = new RemoteNodeStatus(remote != null ? remote.getNodeId() : null);
        this.loadDataFromPull(remote, status);
        return status;
    }

    @Override
    public void loadDataFromPull(Node remote, RemoteNodeStatus status) throws IOException {
        try {
            Node local = this.nodeService.findIdentity();
            if (local == null) {
                local = new Node(this.parameterService, this.dbDialect);
            }
            NodeSecurity localSecurity = this.nodeService.findNodeSecurity(local.getNodeId());
            IIncomingTransport transport = null;
            if (remote != null && localSecurity != null) {
                HashMap<String, String> requestProperties = new HashMap<String, String>();
                ChannelMap suspendIgnoreChannels = this.configurationService.getSuspendIgnoreChannelLists();
                requestProperties.put("Suspended-Channels", suspendIgnoreChannels.getSuspendChannelsAsString());
                requestProperties.put("Ignored-Channels", suspendIgnoreChannels.getIgnoreChannelsAsString());
                transport = this.transportManager.getPullTransport(remote, local, localSecurity.getNodePassword(), requestProperties, this.parameterService.getRegistrationUrl());
            } else {
                transport = this.transportManager.getRegisterTransport(local, this.parameterService.getRegistrationUrl());
                this.log.info("NodeRegisteringUsingUrl", transport.getUrl());
                remote = new Node();
                remote.setSyncUrl(this.parameterService.getRegistrationUrl());
            }
            List<IncomingBatch> list = this.loadDataAndReturnBatches(transport);
            if (list.size() > 0) {
                status.updateIncomingStatus(list);
                local = this.nodeService.findIdentity();
                if (local != null) {
                    localSecurity = this.nodeService.findNodeSecurity(local.getNodeId());
                    if (StringUtils.isNotBlank((String)transport.getRedirectionUrl())) {
                        String url = transport.getRedirectionUrl();
                        url = url.replace(HttpTransportManager.buildRegistrationUrl("", local), "");
                        remote.setSyncUrl(url);
                    }
                    this.sendAck(remote, local, localSecurity, list);
                }
            }
        }
        catch (RegistrationRequiredException e) {
            this.log.warn("RegistrationLost");
            this.loadDataFromPull(null, status);
            this.nodeService.findIdentity(false);
        }
        catch (MalformedURLException e) {
            this.log.error("URLConnectingFailure", remote.getNodeId(), remote.getSyncUrl());
            throw e;
        }
    }

    private void sendAck(Node remote, Node local, NodeSecurity localSecurity, List<IncomingBatch> list) throws IOException {
        Exception error = null;
        int sendAck = -1;
        int numberOfStatusSendRetries = this.parameterService.getInt("num.of.ack.retries");
        for (int i = 0; i < numberOfStatusSendRetries && sendAck != 200; ++i) {
            try {
                sendAck = this.transportManager.sendAcknowledgement(remote, list, local, localSecurity.getNodePassword(), this.parameterService.getRegistrationUrl());
            }
            catch (IOException ex) {
                this.log.warn("AckSendingFailed", i + 1, ex.getMessage());
                error = ex;
            }
            catch (RuntimeException ex) {
                this.log.warn("AckSendingFailed", i + 1, ex.getMessage());
                error = ex;
            }
            if (sendAck == 200) continue;
            if (i < numberOfStatusSendRetries - 1) {
                AppUtils.sleep(this.parameterService.getLong("time.between.ack.retries.ms"));
                continue;
            }
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            if (error instanceof IOException) {
                throw error;
            }
            throw new IOException(Integer.toString(sendAck));
        }
    }

    @Override
    public IDataLoader openDataLoader(BufferedReader reader) throws IOException {
        IDataLoader dataLoader = (IDataLoader)this.beanFactory.getBean("dataLoader");
        dataLoader.open(reader, this.dataSource, this.batchListeners, this.filters, this.columnFilters);
        return dataLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataLoaderStatistics loadDataBatch(String batchData) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(batchData));
        IDataLoader dataLoader = null;
        IDataLoaderStatistics stats = null;
        try {
            dataLoader = this.openDataLoader(reader);
            while (dataLoader.hasNext()) {
                dataLoader.load();
            }
            Object var6_5 = null;
            if (dataLoader != null) {
                stats = dataLoader.getStatistics();
                dataLoader.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (dataLoader != null) {
                stats = dataLoader.getStatistics();
                dataLoader.close();
            }
            throw throwable;
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IncomingBatch> loadDataAndReturnBatches(IIncomingTransport transport) throws IOException {
        ArrayList<IncomingBatch> batchesProcessed;
        block34: {
            batchesProcessed = new ArrayList<IncomingBatch>();
            IncomingBatch batch = null;
            IDataLoader dataLoader = null;
            try {
                try {
                    File incomingFile;
                    long totalNetworkMillis = System.currentTimeMillis();
                    if (this.parameterService.is("stream.to.file.enabled")) {
                        transport = this.writeToFile(transport);
                        totalNetworkMillis = System.currentTimeMillis() - totalNetworkMillis;
                    }
                    dataLoader = this.openDataLoader(transport.open());
                    IDataLoaderContext context = dataLoader.getContext();
                    while (dataLoader.hasNext()) {
                        batch = context.getBatch();
                        if (this.parameterService.is("dataloader.enable") || batch.getChannelId() != null && batch.getChannelId().equals("config")) {
                            this.log.debug("LoaderProcessingBatch", batch.getBatchId());
                            batchesProcessed.add(batch);
                            this.loadBatch(dataLoader, batch);
                        }
                        batch = null;
                    }
                    if (this.parameterService.is("stream.to.file.enabled")) {
                        this.estimateNetworkMillis(batchesProcessed, totalNetworkMillis);
                    }
                    for (IncomingBatch incomingBatch : batchesProcessed) {
                        if (incomingBatch.getBatchId() == -9999L || this.incomingBatchService.updateIncomingBatch(incomingBatch) != 0) continue;
                        this.log.error("LoaderFailedToUpdateBatch", incomingBatch.getBatchId());
                    }
                    if (transport instanceof FileIncomingTransport && batchesProcessed.size() == 0 && (incomingFile = ((FileIncomingTransport)transport).getFile()) != null && incomingFile.exists()) {
                        this.log.warn("LoaderNoBatchesLoadedWarning", incomingFile.length());
                    }
                }
                catch (RegistrationRequiredException ex) {
                    throw ex;
                }
                catch (ConnectException ex) {
                    throw ex;
                }
                catch (UnknownHostException ex) {
                    this.log.warn("TransportFailedUnknownHost", ex.getMessage());
                    throw ex;
                }
                catch (RegistrationNotOpenException ex) {
                    this.log.warn("RegistrationFailed");
                    Object var11_18 = null;
                    if (dataLoader != null) {
                        dataLoader.close();
                    }
                    transport.close();
                    return batchesProcessed;
                }
                catch (ConnectionRejectedException ex) {
                    this.log.warn("TransportFailedConnectionBusy");
                    throw ex;
                }
                catch (AuthenticationException ex) {
                    this.log.warn("AuthenticationFailed");
                    Object var11_19 = null;
                    if (dataLoader != null) {
                        dataLoader.close();
                    }
                    transport.close();
                    return batchesProcessed;
                }
                catch (SyncDisabledException ex) {
                    this.log.warn("SyncDisabled");
                    throw ex;
                }
                catch (Throwable e) {
                    if (dataLoader != null && dataLoader.getContext().getBatch() != null && batch == null) {
                        batch = dataLoader.getContext().getBatch();
                        batchesProcessed.add(batch);
                    }
                    if (dataLoader != null && batch != null) {
                        this.statisticManager.incrementDataLoadedErrors(batch.getChannelId(), 1L);
                        if (e instanceof IOException || e instanceof TransportException) {
                            this.log.warn("BatchLoadingFailed", batch.getNodeBatchId(), e.getMessage());
                            batch.setSqlMessage(e.getMessage());
                        } else {
                            this.log.error("BatchLoadingFailed", e, batch.getNodeBatchId(), e.getMessage());
                            SQLException se = this.unwrapSqlException(e);
                            if (se != null) {
                                batch.setSqlState(se.getSQLState());
                                batch.setSqlCode(se.getErrorCode());
                                batch.setSqlMessage(se.getMessage());
                            } else {
                                batch.setSqlMessage(e.getMessage());
                            }
                        }
                        batch.setValues(dataLoader.getStatistics(), false);
                        this.handleBatchError(batch);
                    } else if (e instanceof IOException) {
                        if (e.getMessage() != null && !e.getMessage().startsWith("http")) {
                            this.log.error("BatchReadingFailed", e.getMessage());
                        } else {
                            this.log.error("BatchReadingFailed", e.getMessage(), e);
                        }
                    } else {
                        this.log.error("BatchParsingFailed", e);
                    }
                    Object var11_20 = null;
                    if (dataLoader != null) {
                        dataLoader.close();
                    }
                    transport.close();
                    return batchesProcessed;
                }
                Object var11_17 = null;
                if (dataLoader == null) break block34;
                dataLoader.close();
            }
            catch (Throwable throwable) {
                Object var11_21 = null;
                if (dataLoader != null) {
                    dataLoader.close();
                }
                transport.close();
                throw throwable;
            }
        }
        transport.close();
        return batchesProcessed;
    }

    protected void estimateNetworkMillis(List<IncomingBatch> list, long totalNetworkMillis) {
        long totalNumberOfBytes = 0L;
        for (IncomingBatch incomingBatch : list) {
            totalNumberOfBytes += incomingBatch.getByteCount();
        }
        for (IncomingBatch incomingBatch : list) {
            if (totalNumberOfBytes <= 0L) continue;
            double ratio = (double)incomingBatch.getByteCount() / (double)totalNumberOfBytes;
            incomingBatch.setNetworkMillis((long)((double)totalNetworkMillis * ratio));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IIncomingTransport writeToFile(IIncomingTransport transport) throws IOException {
        ThresholdFileWriter writer = null;
        try {
            writer = new ThresholdFileWriter(this.parameterService.getLong("stream.to.file.threshold.bytes"), "load");
            IOUtils.copy((Reader)transport.open(), (Writer)writer);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IOUtils.closeQuietly(writer);
            transport.close();
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        transport.close();
        return new FileIncomingTransport(writer);
    }

    protected void handleBatchError(IncomingBatch batch) {
        try {
            if (batch.getStatus() != IncomingBatch.Status.OK) {
                batch.setStatus(IncomingBatch.Status.ER);
            }
            this.incomingBatchService.updateIncomingBatch(batch);
        }
        catch (Exception e) {
            this.log.error("BatchStatusRecordFailed", batch.getNodeBatchId());
        }
    }

    @Override
    public void loadData(InputStream in, OutputStream out) throws IOException {
        Node local;
        List<IncomingBatch> list = this.loadDataAndReturnBatches(new InternalIncomingTransport(in));
        NodeSecurity security = this.nodeService.findNodeSecurity((local = this.nodeService.findIdentity()).getNodeId());
        this.transportManager.writeAcknowledgement(out, list, local, security != null ? security.getNodePassword() : null);
    }

    @Override
    public void setDataLoaderFilters(List<IDataLoaderFilter> filters) {
        this.filters = filters;
    }

    @Override
    public void addDataLoaderFilter(IDataLoaderFilter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<IDataLoaderFilter>();
        }
        this.filters.add(filter);
    }

    @Override
    public void removeDataLoaderFilter(IDataLoaderFilter filter) {
        this.filters.remove(filter);
    }

    @Override
    public void setTransportManager(ITransportManager remoteService) {
        this.transportManager = remoteService;
    }

    public void setIncomingBatchService(IIncomingBatchService incomingBatchService) {
        this.incomingBatchService = incomingBatchService;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }

    @Override
    public void addColumnFilter(String tableName, IColumnFilter filter) {
        List<IColumnFilter> filters = this.columnFilters.get(tableName);
        if (filters == null) {
            filters = new ArrayList<IColumnFilter>();
            this.columnFilters.put(tableName, filters);
        }
        filters.add(filter);
    }

    @Override
    public void reRegisterColumnFilter(String[] tableNames, IColumnFilter filter) {
        Set<Map.Entry<String, List<IColumnFilter>>> entries = this.columnFilters.entrySet();
        for (Map.Entry<String, List<IColumnFilter>> entry : entries) {
            if (!entry.getValue().contains(filter)) continue;
            entry.getValue().remove(filter);
        }
        if (tableNames != null) {
            for (String name : tableNames) {
                this.addColumnFilter(name, filter);
            }
        }
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }

    @Override
    public void addBatchListener(IBatchListener batchListener) {
        if (this.batchListeners == null) {
            this.batchListeners = new ArrayList<IBatchListener>();
        }
        this.batchListeners.add(batchListener);
    }

    public void setBatchListeners(List<IBatchListener> batchListeners) {
        this.batchListeners = batchListeners;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected void loadBatch(IDataLoader dataLoader, IncomingBatch batch) {
        try {
            if (this.incomingBatchService.acquireIncomingBatch(batch)) {
                dataLoader.load();
            } else {
                dataLoader.skip();
            }
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    class LoadBatchResultsListener
    extends BatchListenerAdapter {
        LoadBatchResultsListener() {
        }

        public void batchComplete(IDataLoader loader, IncomingBatch batch) {
            loader.getContext().getBatch().setValues(loader.getStatistics(), true);
            IncomingBatch.Status oldStatus = batch.getStatus();
            try {
                batch.setStatus(IncomingBatch.Status.OK);
                DataLoaderService.this.incomingBatchService.updateIncomingBatch(batch);
            }
            catch (RuntimeException ex) {
                batch.setStatus(oldStatus);
                throw ex;
            }
        }
    }
}

