/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.ddl.model.Table;
import org.jumpmind.symmetric.extract.DataExtractorContext;
import org.jumpmind.symmetric.extract.IDataExtractor;
import org.jumpmind.symmetric.extract.IExtractorFilter;
import org.jumpmind.symmetric.io.ThresholdFileWriter;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.OutgoingBatches;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IExtractListener;
import org.jumpmind.symmetric.service.IModelRetrievalHandler;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.statistic.DataExtractorStatisticsWriter;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transform.IgnoreRowException;
import org.jumpmind.symmetric.transform.TransformDataExtractor;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.transport.TransportUtils;
import org.jumpmind.symmetric.util.CsvUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.support.JdbcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataExtractorService
extends AbstractService
implements IDataExtractorService,
BeanFactoryAware {
    static final long MS_PASSED_BEFORE_BATCH_REQUERIED = 5000L;
    private IOutgoingBatchService outgoingBatchService;
    private IRouterService routingService;
    private IDataService dataService;
    private IConfigurationService configurationService;
    private IAcknowledgeService acknowledgeService;
    private ITriggerRouterService triggerRouterService;
    private INodeService nodeService;
    private BeanFactory beanFactory;
    private DataExtractorContext clonableContext;
    private List<IExtractorFilter> extractorFilters;
    private TransformDataExtractor transformDataExtractor;
    private IStatisticManager statisticManager;
    private Map<Long, File> extractedBatchesHandle = new HashMap<Long, File>();
    private Set<String> extractingNodes = new HashSet<String>();

    @Override
    public void extractConfigurationStandalone(Node node, OutputStream out, String ... tablesToExclude) throws IOException {
        this.extractConfigurationStandalone(node, TransportUtils.toWriter(out), tablesToExclude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractConfigurationStandalone(Node node, Writer writer, String ... tablesToExclude) throws IOException {
        try {
            OutgoingBatch batch = new OutgoingBatch(node.getNodeId(), "config", OutgoingBatch.Status.NE);
            if (Version.isOlderThanVersion(node.getSymmetricVersion(), "1.6.0")) {
                this.outgoingBatchService.insertOutgoingBatch(batch);
                this.acknowledgeService.ack(batch.getBatchInfo());
            } else {
                batch.setBatchId(-9999L);
            }
            IDataExtractor dataExtractor = this.getDataExtractor(node.getSymmetricVersion());
            DataExtractorContext ctxCopy = this.clonableContext.copy(dataExtractor);
            dataExtractor.init(writer, ctxCopy);
            dataExtractor.begin(batch, writer);
            this.extractConfiguration(node, writer, ctxCopy, tablesToExclude);
            dataExtractor.commit(batch, writer);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            writer.flush();
            throw throwable;
        }
        writer.flush();
    }

    @Override
    public void extractConfiguration(Node node, Writer writer, DataExtractorContext ctx, String ... tablesToExclude) throws IOException {
        TriggerHistory triggerHistory;
        TriggerRouter triggerRouter;
        int i;
        IDataExtractor dataExtractor;
        NodeGroupLink nodeGroupLink = new NodeGroupLink(this.parameterService.getNodeGroupId(), node.getNodeGroupId());
        List<TriggerRouter> triggerRouters = this.triggerRouterService.getTriggerRoutersForRegistration(StringUtils.isBlank((String)node.getSymmetricVersion()) ? Version.version() : node.getSymmetricVersion(), nodeGroupLink, tablesToExclude);
        IDataExtractor iDataExtractor = dataExtractor = ctx != null ? ctx.getDataExtractor() : this.getDataExtractor(node.getSymmetricVersion());
        if (node.isVersionGreaterThanOrEqualTo(1, 5, 0)) {
            for (i = triggerRouters.size() - 1; i >= 0; --i) {
                triggerRouter = triggerRouters.get(i);
                triggerHistory = this.triggerRouterService.getNewestTriggerHistoryForTrigger(triggerRouter.getTrigger().getTriggerId());
                if (triggerHistory == null) {
                    triggerHistory = new TriggerHistory(this.dbDialect.getTable(triggerRouter.getTrigger(), false), triggerRouter.getTrigger());
                    triggerHistory.setTriggerHistoryId(Integer.MAX_VALUE - i);
                }
                StringBuilder sql = new StringBuilder(this.dbDialect.createPurgeSqlFor(node, triggerRouter));
                this.addPurgeCriteriaToConfigurationTables(triggerRouter.getTrigger().getSourceTableName(), sql);
                String sourceTable = triggerHistory.getSourceTableName();
                Data data = new Data(1L, null, sql.toString(), DataEventType.SQL, sourceTable, null, triggerHistory, triggerRouter.getTrigger().getChannelId(), null, null);
                dataExtractor.write(writer, data, triggerRouter.getRouter().getRouterId(), ctx);
            }
        }
        for (i = 0; i < triggerRouters.size(); ++i) {
            triggerRouter = triggerRouters.get(i);
            triggerHistory = this.triggerRouterService.getNewestTriggerHistoryForTrigger(triggerRouter.getTrigger().getTriggerId());
            if (triggerHistory == null) {
                triggerHistory = new TriggerHistory(this.dbDialect.getTable(triggerRouter.getTrigger(), false), triggerRouter.getTrigger());
                triggerHistory.setTriggerHistoryId(Integer.MAX_VALUE - i);
            }
            if (!triggerRouter.getTrigger().getSourceTableName().endsWith("node_identity")) {
                this.writeInitialLoad(node, triggerRouter, triggerHistory, writer, ctx);
                continue;
            }
            Data data = new Data(1L, null, node.getNodeId(), DataEventType.INSERT, triggerHistory.getSourceTableName(), null, triggerHistory, triggerRouter.getTrigger().getChannelId(), null, null);
            dataExtractor.write(writer, data, triggerRouter.getRouter().getRouterId(), ctx);
        }
        if (triggerRouters.size() == 0) {
            this.log.error("RegistrationEmpty", node);
        }
    }

    private void addPurgeCriteriaToConfigurationTables(String sourceTableName, StringBuilder sql) {
        Node me;
        if ((TableConstants.getTableName(this.dbDialect.getTablePrefix(), "node").equalsIgnoreCase(sourceTableName) || TableConstants.getTableName(this.dbDialect.getTablePrefix(), "node_security").equalsIgnoreCase(sourceTableName)) && (me = this.nodeService.findIdentity()) != null) {
            sql.append(String.format(" where created_at_node_id='%s'", me.getNodeId()));
        }
    }

    private IDataExtractor getDataExtractor(String version) {
        int[] versions;
        String beanName = "dataExtractor";
        if (version != null && (versions = Version.parseVersion(version))[0] == 1) {
            if (versions[1] <= 2) {
                beanName = beanName + "10";
            } else if (versions[1] <= 3) {
                beanName = beanName + "13";
            } else if (versions[1] <= 4 && !version.equals("1.4.1-appaji")) {
                beanName = beanName + "14";
            } else if (versions[1] <= 7) {
                beanName = beanName + "16";
            }
        }
        return (IDataExtractor)this.beanFactory.getBean(beanName);
    }

    @Override
    public void extractInitialLoadWithinBatchFor(Node node, TriggerRouter trigger, Writer writer, DataExtractorContext ctx, TriggerHistory triggerHistory) {
        this.writeInitialLoad(node, trigger, triggerHistory, writer, ctx);
    }

    protected void writeInitialLoad(final Node node, final TriggerRouter triggerRouter, TriggerHistory triggerHistory, final Writer writer, final DataExtractorContext ctx) {
        triggerHistory = triggerHistory != null ? triggerHistory : this.triggerRouterService.getNewestTriggerHistoryForTrigger(triggerRouter.getTrigger().getTriggerId());
        final boolean newExtractorCreated = ctx == null || ctx.getDataExtractor() == null;
        final IDataExtractor dataExtractor = !newExtractorCreated ? ctx.getDataExtractor() : this.getDataExtractor(node.getSymmetricVersion());
        Table tableForSql = this.dbDialect.getTable(triggerRouter.getTrigger().getSourceCatalogName(), triggerRouter.getTrigger().getSourceSchemaName(), dataExtractor.getLegacyTableName(triggerRouter.getTrigger().getSourceTableName()), true);
        final String sql = this.dbDialect.createInitialLoadSqlFor(node, triggerRouter, tableForSql, triggerHistory, this.configurationService.getChannel(triggerRouter.getTrigger().getChannelId()));
        this.log.debug("Sql", sql);
        if (!tableForSql.getName().equals(triggerHistory.getSourceTableName())) {
            String tableName = triggerHistory.getSourceTableName();
            triggerHistory = new TriggerHistory(tableForSql, triggerRouter.getTrigger());
            triggerHistory.setSourceTableName(tableName);
        }
        final TriggerHistory triggerHistory2Use = triggerHistory;
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object doInConnection(Connection conn) throws SQLException, DataAccessException {
                try {
                    ResultSet rs;
                    PreparedStatement st;
                    block20: {
                        OutgoingBatch batch = ctx.getBatch();
                        Table table = DataExtractorService.this.dbDialect.getTable(triggerRouter.getTrigger(), true);
                        NodeChannel channel = batch != null ? DataExtractorService.this.configurationService.getNodeChannel(batch.getChannelId(), false) : new NodeChannel(triggerRouter.getTrigger().getChannelId());
                        HashSet<Node> oneNodeSet = new HashSet<Node>();
                        oneNodeSet.add(node);
                        boolean autoCommitFlag = conn.getAutoCommit();
                        st = null;
                        rs = null;
                        try {
                            DataExtractorContext ctxCopy;
                            if (DataExtractorService.this.dbDialect.requiresAutoCommitFalseToSetFetchSize()) {
                                conn.setAutoCommit(false);
                            }
                            st = conn.prepareStatement(sql, 1003, 1007);
                            st.setQueryTimeout(DataExtractorService.this.jdbcTemplate.getQueryTimeout());
                            st.setFetchSize(DataExtractorService.this.dbDialect.getStreamingResultsFetchSize());
                            long ts = System.currentTimeMillis();
                            rs = st.executeQuery();
                            long executeTimeInMs = System.currentTimeMillis() - ts;
                            if (executeTimeInMs > 30000L) {
                                DataExtractorService.this.log.warn("LongRunningOperation", "selecting initial load to extract for batch " + batch.getBatchId(), executeTimeInMs);
                            }
                            DataExtractorContext dataExtractorContext = ctxCopy = ctx == null ? DataExtractorService.this.clonableContext.copy(dataExtractor) : ctx;
                            if (newExtractorCreated) {
                                dataExtractor.init(writer, ctxCopy);
                                dataExtractor.begin(batch, writer);
                            }
                            SimpleRouterContext routingContext = new SimpleRouterContext(node.getNodeId(), DataExtractorService.this.jdbcTemplate, channel);
                            int dataNotRouted = 0;
                            int dataRouted = 0;
                            ts = System.currentTimeMillis();
                            boolean useReloadChannel = DataExtractorService.this.parameterService.is("initial.load.use.reload.channel");
                            while (rs.next()) {
                                Data data = new Data(0L, null, rs.getString(1), DataEventType.INSERT, triggerHistory2Use.getSourceTableName(), null, triggerHistory2Use, useReloadChannel ? "reload" : triggerRouter.getTrigger().getChannelId(), null, null);
                                boolean writeData = true;
                                String routerId = triggerRouter.getRouter().getRouterId();
                                if (DataExtractorService.this.extractorFilters != null) {
                                    for (IExtractorFilter filter : DataExtractorService.this.extractorFilters) {
                                        if (filter.filterData(data, routerId, ctx)) continue;
                                        writeData = false;
                                        break;
                                    }
                                }
                                DataMetaData dataMetaData = new DataMetaData(data, table, triggerRouter, channel);
                                if (writeData &= !StringUtils.isBlank((String)triggerRouter.getInitialLoadSelect()) || DataExtractorService.this.routingService.shouldDataBeRouted(routingContext, dataMetaData, oneNodeSet, true)) {
                                    List<Data> transformedData = DataExtractorService.this.transformDataExtractor.transformData(data, routerId, ctx);
                                    if (transformedData != null) {
                                        for (Data data2 : transformedData) {
                                            dataExtractor.write(writer, data2, routerId, ctxCopy);
                                            ++dataRouted;
                                        }
                                    } else {
                                        dataExtractor.write(writer, data, routerId, ctxCopy);
                                        ++dataRouted;
                                    }
                                } else {
                                    ++dataNotRouted;
                                }
                                if ((executeTimeInMs = System.currentTimeMillis() - ts) <= 600000L) continue;
                                DataExtractorService.this.log.warn("LongRunningOperation", "initial load extracted " + (dataRouted + dataNotRouted) + " data so far for batch " + batch.getBatchId(), executeTimeInMs);
                                ts = System.currentTimeMillis();
                            }
                            if (dataNotRouted > 0) {
                                DataExtractorService.this.log.info("RouterInitialLoadNotRouted", dataNotRouted, triggerRouter.getTrigger().getSourceTableName());
                            }
                            if (newExtractorCreated) {
                                dataExtractor.commit(batch, writer);
                            }
                            Object var26_25 = null;
                            if (!DataExtractorService.this.dbDialect.requiresAutoCommitFalseToSetFetchSize()) break block20;
                        }
                        catch (Throwable throwable) {
                            Object var26_26 = null;
                            if (DataExtractorService.this.dbDialect.requiresAutoCommitFalseToSetFetchSize()) {
                                conn.commit();
                                conn.setAutoCommit(autoCommitFlag);
                            }
                            JdbcUtils.closeResultSet(rs);
                            JdbcUtils.closeStatement((Statement)st);
                            throw throwable;
                        }
                        conn.commit();
                        conn.setAutoCommit(autoCommitFlag);
                    }
                    JdbcUtils.closeResultSet((ResultSet)rs);
                    JdbcUtils.closeStatement((Statement)st);
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e.getSQLState() + "Error during SQL: " + sql, e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error during SQL: " + sql, e);
                }
            }
        });
    }

    private ExtractStreamHandler createExtractStreamHandler(IDataExtractor dataExtractor, Writer extractWriter) throws IOException {
        return new ExtractStreamHandler(dataExtractor, new DataExtractorStatisticsWriter(this.statisticManager, extractWriter, 1024, 512));
    }

    private List<OutgoingBatch> filterBatchesForExtraction(OutgoingBatches batches, ChannelMap suspendIgnoreChannelsList) {
        List<OutgoingBatch> ignoredBatches = batches.filterBatchesForChannels(suspendIgnoreChannelsList.getIgnoreChannels());
        for (OutgoingBatch batch : ignoredBatches) {
            batch.setStatus(OutgoingBatch.Status.IG);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("BatchIgnored", batch.getBatchId());
        }
        this.outgoingBatchService.updateOutgoingBatches(ignoredBatches);
        batches.filterBatchesForChannels(suspendIgnoreChannelsList.getSuspendChannels());
        if (!batches.containsBatchesInError() && batches.containsLoadBatches()) {
            batches.removeNonLoadBatches();
        }
        return batches.getBatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public List<OutgoingBatch> extract(Node node, IOutgoingTransport targetTransport) throws IOException {
        List<Object> activeBatches = null;
        if (!this.extractingNodes.contains(node.getNodeId())) {
            try {
                this.extractingNodes.add(node.getNodeId());
                IDataExtractor dataExtractor = this.getDataExtractor(node.getSymmetricVersion());
                if (!this.parameterService.is("start.route.job")) {
                    this.routingService.routeData();
                }
                OutgoingBatches batches = this.outgoingBatchService.getOutgoingBatches(node);
                long batchesSelectedAtMs = System.currentTimeMillis();
                if (batches.containsBatches() && (activeBatches = this.filterBatchesForExtraction(batches, targetTransport.getSuspendIgnoreChannelLists(this.configurationService))).size() > 0) {
                    BufferedWriter extractWriter = null;
                    BufferedWriter networkWriter = null;
                    boolean streamToFileEnabled = this.parameterService.is("stream.to.file.enabled");
                    ThresholdFileWriter fileWriter = new ThresholdFileWriter(this.parameterService.getLong("stream.to.file.threshold.bytes"), "extract");
                    if (streamToFileEnabled) {
                        extractWriter = new BufferedWriter(fileWriter);
                        networkWriter = targetTransport.open();
                    } else {
                        extractWriter = targetTransport.open();
                    }
                    ExtractStreamHandler handler = this.createExtractStreamHandler(dataExtractor, extractWriter);
                    handler.init();
                    OutgoingBatch currentBatch = null;
                    try {
                        try {
                            long maxBytesToSync = this.parameterService.getLong("transport.max.bytes.to.sync");
                            long bytesSentCount = 0L;
                            int batchesSentCount = 0;
                            for (OutgoingBatch outgoingBatch : activeBatches) {
                                Object var24_31;
                                block28: {
                                    try {
                                        void var20_20;
                                        void var20_25;
                                        void var20_23;
                                        if (System.currentTimeMillis() - batchesSelectedAtMs > 5000L) {
                                            OutgoingBatch outgoingBatch2 = this.outgoingBatchService.findOutgoingBatch(outgoingBatch.getBatchId());
                                        }
                                        currentBatch = var20_23;
                                        if (var20_23.getStatus() == OutgoingBatch.Status.OK) break block28;
                                        fileWriter.reset();
                                        File previouslyExtracted = this.extractedBatchesHandle.get(currentBatch.getBatchId());
                                        if (previouslyExtracted != null && previouslyExtracted.exists()) {
                                            this.log.info("DataExtractorUsingAlreadyExtractedBatch", currentBatch.getBatchId());
                                            fileWriter.setFile(previouslyExtracted);
                                        } else {
                                            var20_23.setStatus(OutgoingBatch.Status.QY);
                                            var20_23.setExtractCount(var20_23.getExtractCount() + 1L);
                                            this.outgoingBatchService.updateOutgoingBatch((OutgoingBatch)var20_23);
                                            this.databaseExtract(node, (OutgoingBatch)var20_23, handler, networkWriter);
                                        }
                                        if (System.currentTimeMillis() - var20_23.getLastUpdatedTime().getTime() > 5000L) {
                                            OutgoingBatch outgoingBatch3 = this.outgoingBatchService.findOutgoingBatch(currentBatch.getBatchId());
                                            outgoingBatch3.setExtractMillis(currentBatch.getExtractMillis());
                                            currentBatch = outgoingBatch3;
                                        }
                                        if (var20_25.getStatus() == OutgoingBatch.Status.OK) break block28;
                                        var20_25.setStatus(OutgoingBatch.Status.SE);
                                        var20_25.setSentCount(var20_25.getSentCount() + 1L);
                                        this.outgoingBatchService.updateOutgoingBatch((OutgoingBatch)var20_25);
                                        File file = fileWriter.getFile();
                                        if (file != null) {
                                            this.extractedBatchesHandle.put(currentBatch.getBatchId(), file);
                                        }
                                        fileWriter.close();
                                        this.networkTransfer(fileWriter.getReader(), networkWriter);
                                        if (System.currentTimeMillis() - var20_25.getLastUpdatedTime().getTime() > 5000L) {
                                            OutgoingBatch outgoingBatch4;
                                            currentBatch = outgoingBatch4 = this.outgoingBatchService.findOutgoingBatch(currentBatch.getBatchId());
                                        }
                                        if (var20_20.getStatus() == OutgoingBatch.Status.OK) break block28;
                                        var20_20.setStatus(OutgoingBatch.Status.LD);
                                        var20_20.setLoadCount(var20_20.getLoadCount() + 1L);
                                        this.outgoingBatchService.updateOutgoingBatch((OutgoingBatch)var20_20);
                                        ++batchesSentCount;
                                        if ((bytesSentCount += var20_20.getByteCount()) < maxBytesToSync) break block28;
                                        this.log.info("DataExtractorReachedMaxNumberOfBytesToSync", batchesSentCount, bytesSentCount);
                                        var24_31 = null;
                                    }
                                    catch (Throwable throwable) {
                                        var24_31 = null;
                                        fileWriter.close();
                                        throw throwable;
                                    }
                                    fileWriter.close();
                                    {
                                        break;
                                    }
                                }
                                var24_31 = null;
                                fileWriter.close();
                                {
                                }
                            }
                            for (OutgoingBatch outgoingBatch : activeBatches) {
                                File file = this.extractedBatchesHandle.remove(outgoingBatch.getBatchId());
                                if (file == null || !file.exists()) continue;
                                fileWriter.delete();
                            }
                            Object var26_33 = null;
                        }
                        catch (Exception e) {
                            SQLException se = this.unwrapSqlException(e);
                            if (currentBatch != null) {
                                this.statisticManager.incrementDataExtractedErrors(currentBatch.getChannelId(), 1L);
                                if (se != null) {
                                    currentBatch.setSqlState(se.getSQLState());
                                    currentBatch.setSqlCode(se.getErrorCode());
                                    currentBatch.setSqlMessage(se.getMessage());
                                } else {
                                    currentBatch.setSqlMessage(e.getMessage());
                                }
                                currentBatch.revertStatsOnError();
                                currentBatch.setStatus(OutgoingBatch.Status.ER);
                                currentBatch.setErrorFlag(true);
                                this.outgoingBatchService.updateOutgoingBatch(currentBatch);
                            } else {
                                this.log.error("BatchStatusLoggingFailed", e);
                            }
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            if (e instanceof IOException) {
                                throw (IOException)e;
                            }
                            throw new RuntimeException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var26_34 = null;
                        handler.done();
                        throw throwable;
                    }
                    handler.done();
                    Calendar now = Calendar.getInstance();
                    for (NodeChannel nodeChannel : batches.getActiveChannels()) {
                        nodeChannel.setLastExtractedTime(now.getTime());
                        this.configurationService.saveNodeChannelControl(nodeChannel, false);
                    }
                }
                Object var28_38 = null;
                this.extractingNodes.remove(node.getNodeId());
            }
            catch (Throwable throwable) {
                Object var28_39 = null;
                this.extractingNodes.remove(node.getNodeId());
                throw throwable;
            }
            {
            }
        }
        return activeBatches != null ? activeBatches : new ArrayList(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void networkTransfer(BufferedReader reader, BufferedWriter writer) throws IOException {
        block11: {
            if (reader == null || writer == null) break block11;
            CsvReader csvReader = CsvUtils.getCsvReader(reader);
            String channelId = null;
            long lineCount = 0L;
            long byteCount = 0L;
            try {
                String nextLine = null;
                while (csvReader.readRecord()) {
                    String[] csv;
                    nextLine = csvReader.getRawRecord();
                    if (nextLine == null) continue;
                    ++lineCount;
                    byteCount += (long)nextLine.length();
                    if (nextLine.startsWith("channel") && (csv = StringUtils.split((String)nextLine, (String)",")).length > 1) {
                        if (channelId != null) {
                            this.statisticManager.incrementDataBytesSent(channelId, byteCount);
                            this.statisticManager.incrementDataSent(channelId, lineCount);
                        }
                        channelId = csv[1].trim();
                        byteCount = 0L;
                        lineCount = 0L;
                    }
                    writer.write(nextLine);
                    CsvUtils.writeLineFeed(writer);
                    if (StringUtils.isBlank(channelId)) continue;
                    if (byteCount > 1024L) {
                        this.statisticManager.incrementDataBytesSent(channelId, byteCount);
                        byteCount = 0L;
                    }
                    if (lineCount <= 512L) continue;
                    this.statisticManager.incrementDataSent(channelId, lineCount);
                    lineCount = 0L;
                }
                writer.flush();
                Object var12_9 = null;
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                csvReader.close();
                IOUtils.closeQuietly((Reader)reader);
                if (!StringUtils.isBlank(channelId)) {
                    if (byteCount > 0L) {
                        this.statisticManager.incrementDataBytesSent(channelId, byteCount);
                    }
                    if (lineCount > 0L) {
                        this.statisticManager.incrementDataSent(channelId, lineCount);
                    }
                }
                throw throwable;
            }
            csvReader.close();
            IOUtils.closeQuietly((Reader)reader);
            if (StringUtils.isBlank(channelId)) break block11;
            if (byteCount > 0L) {
                this.statisticManager.incrementDataBytesSent(channelId, byteCount);
            }
            if (lineCount > 0L) {
                this.statisticManager.incrementDataSent(channelId, lineCount);
            }
        }
    }

    protected void databaseExtract(Node node, OutgoingBatch batch, IExtractListener handler, BufferedWriter keepaliveWriter) throws IOException {
        batch.resetStats();
        long ts = System.currentTimeMillis();
        handler.startBatch(batch);
        this.selectEventDataToExtract(handler, batch, keepaliveWriter);
        handler.endBatch(batch);
        batch.setExtractMillis(System.currentTimeMillis() - ts);
    }

    @Override
    public boolean extractBatchRange(IOutgoingTransport transport, String startBatchId, String endBatchId) throws IOException {
        IDataExtractor dataExtractor = this.getDataExtractor(null);
        ExtractStreamHandler handler = this.createExtractStreamHandler(dataExtractor, transport.open());
        return this.extractBatchRange(handler, startBatchId, endBatchId);
    }

    private boolean areNumeric(String ... data) {
        if (data != null) {
            for (String string : data) {
                try {
                    Long.parseLong(string);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean extractBatchRange(IExtractListener handler, String startBatchId, String endBatchId) throws IOException {
        OutgoingBatches batches;
        if (this.areNumeric(startBatchId, endBatchId) && (batches = this.outgoingBatchService.getOutgoingBatchRange(startBatchId, endBatchId)) != null && batches.getBatches() != null && batches.getBatches().size() > 0) {
            try {
                handler.init();
                for (OutgoingBatch batch : batches.getBatches()) {
                    handler.startBatch(batch);
                    this.selectEventDataToExtract(handler, batch, null);
                    handler.endBatch(batch);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                handler.done();
                throw throwable;
            }
            handler.done();
            return true;
        }
        return false;
    }

    private void selectEventDataToExtract(final IExtractListener handler, OutgoingBatch batch, final BufferedWriter keepAliveWriter) {
        final long flushForKeepAliveInMs = this.parameterService.getLong("dataextractor.keepalive.period.ms", -1L);
        this.dataService.handleDataSelect(batch.getBatchId(), -1L, batch.getChannelId(), false, new IModelRetrievalHandler<Data, String>(){
            long lastKeepAliveFlush = System.currentTimeMillis();
            String nodeId = DataExtractorService.access$500(DataExtractorService.this).findIdentityNodeId();

            @Override
            public boolean retrieved(Data data, String routerId, int count) throws IOException {
                handler.dataExtracted(data, routerId);
                if (flushForKeepAliveInMs > 0L && System.currentTimeMillis() - this.lastKeepAliveFlush > flushForKeepAliveInMs && keepAliveWriter != null) {
                    CsvUtils.write(keepAliveWriter, "nodeid", ", ", this.nodeId);
                    CsvUtils.writeLineFeed(keepAliveWriter);
                    keepAliveWriter.flush();
                    this.lastKeepAliveFlush = System.currentTimeMillis();
                }
                return true;
            }
        });
    }

    public void setOutgoingBatchService(IOutgoingBatchService batchBuilderService) {
        this.outgoingBatchService = batchBuilderService;
    }

    public void setContext(DataExtractorContext context) {
        this.clonableContext = context;
    }

    public void setConfigurationService(IConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public void addExtractorFilter(IExtractorFilter extractorFilter) {
        if (this.extractorFilters == null) {
            this.extractorFilters = new ArrayList<IExtractorFilter>();
        }
        this.extractorFilters.add(extractorFilter);
    }

    public void setExtractorFilters(List<IExtractorFilter> extractorFilters) {
        this.extractorFilters = extractorFilters;
    }

    public void setAcknowledgeService(IAcknowledgeService acknowledgeService) {
        this.acknowledgeService = acknowledgeService;
    }

    public void setNodeService(INodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRoutingService(IRouterService routingService) {
        this.routingService = routingService;
    }

    public void setDataService(IDataService dataService) {
        this.dataService = dataService;
    }

    public void setTriggerRouterService(ITriggerRouterService triggerService) {
        this.triggerRouterService = triggerService;
    }

    public void setStatisticManager(IStatisticManager statisticManager) {
        this.statisticManager = statisticManager;
    }

    public void setTransformDataExtractor(TransformDataExtractor transformDataExtractor) {
        this.transformDataExtractor = transformDataExtractor;
    }

    static /* synthetic */ INodeService access$500(DataExtractorService x0) {
        return x0.nodeService;
    }

    class ExtractStreamHandler
    implements IExtractListener {
        IDataExtractor dataExtractor;
        DataExtractorContext context;
        DataExtractorStatisticsWriter writer;

        ExtractStreamHandler(IDataExtractor dataExtractor, DataExtractorStatisticsWriter writer) throws IOException {
            this.dataExtractor = dataExtractor;
            this.writer = writer;
        }

        public void dataExtracted(Data data, String routerId) throws IOException {
            if (DataExtractorService.this.extractorFilters != null) {
                for (IExtractorFilter filter : DataExtractorService.this.extractorFilters) {
                    if (filter.filterData(data, routerId, this.context)) continue;
                    return;
                }
            }
            try {
                List<Data> transformedData = DataExtractorService.this.transformDataExtractor.transformData(data, routerId, this.context);
                if (transformedData != null) {
                    for (Data data2 : transformedData) {
                        this.dataExtractor.write(this.writer, data2, routerId, this.context);
                    }
                } else {
                    this.dataExtractor.write(this.writer, data, routerId, this.context);
                }
            }
            catch (IgnoreRowException ignoreRowException) {
                // empty catch block
            }
        }

        public void done() throws IOException {
        }

        public void endBatch(OutgoingBatch batch) throws IOException {
            this.dataExtractor.commit(batch, this.writer);
            this.writer.flush();
        }

        public void init() throws IOException {
            this.context = DataExtractorService.this.clonableContext.copy(this.dataExtractor);
            this.dataExtractor.init(this.writer, this.context);
        }

        public void startBatch(OutgoingBatch batch) throws IOException {
            this.context.setBatch(batch);
            this.writer.setChannelId(batch.getChannelId());
            this.dataExtractor.begin(batch, this.writer);
        }
    }
}

