/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.common.logging.LogFactory;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IService;
import org.jumpmind.symmetric.service.ISqlProvider;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractService
implements IService,
ISqlProvider {
    protected ILog log = LogFactory.getLog(this.getClass());
    protected IParameterService parameterService;
    protected JdbcTemplate jdbcTemplate;
    protected TransactionTemplate newTransactionTemplate;
    protected DataSource dataSource;
    protected IDbDialect dbDialect;
    protected String tablePrefix;
    private Map<String, String> sql;

    public void setJdbcTemplate(JdbcTemplate jdbc) {
        this.jdbcTemplate = jdbc;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected SimpleJdbcTemplate getSimpleTemplate() {
        return new SimpleJdbcTemplate((JdbcOperations)this.jdbcTemplate);
    }

    @Override
    public synchronized void synchronize(Runnable runnable) {
        runnable.run();
    }

    protected boolean isSet(Object value) {
        return value != null && value.toString().equals("1");
    }

    protected SQLException unwrapSqlException(Throwable e) {
        List exs = ExceptionUtils.getThrowableList((Throwable)e);
        for (Throwable throwable : exs) {
            if (!(throwable instanceof SQLException)) continue;
            return (SQLException)throwable;
        }
        return null;
    }

    public void setSql(Map<String, String> sql) {
        this.sql = sql;
    }

    @Override
    public String getSql(String ... keys) {
        StringBuilder sqlBuffer = new StringBuilder();
        if (keys != null) {
            for (String key : keys) {
                if (key == null) continue;
                String value = this.sql.get(key);
                sqlBuffer.append(value == null ? key : value);
            }
            if (this.dbDialect != null) {
                sqlBuffer = this.dbDialect.scrubSql(sqlBuffer);
            }
        }
        return sqlBuffer.toString();
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
        this.log = LogFactory.getLog(parameterService);
    }

    public IParameterService getParameterService() {
        return this.parameterService;
    }

    public void setNewTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.newTransactionTemplate = transactionTemplate;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDbDialect(IDbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }

    public IDbDialect getDbDialect() {
        return this.dbDialect;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }
}

