/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.db.IDbDialect;
import org.jumpmind.symmetric.ext.IHeartbeatListener;
import org.jumpmind.symmetric.load.IReloadListener;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataEvent;
import org.jumpmind.symmetric.model.DataEventType;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.model.DataRef;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IModelRetrievalHandler;
import org.jumpmind.symmetric.service.IParameterService;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IDataService {
    public String reloadNode(String var1);

    public String reloadTable(String var1, String var2, String var3, String var4);

    public String reloadTable(String var1, String var2, String var3, String var4, String var5);

    public String sendSQL(String var1, String var2, String var3, String var4, String var5, boolean var6);

    public void insertReloadEvents(Node var1);

    public void insertReloadEvent(Node var1, TriggerRouter var2);

    public void sendScript(String var1, String var2, boolean var3);

    public void heartbeat(boolean var1);

    public void insertHeartbeatEvent(Node var1, boolean var2);

    public long insertData(Data var1);

    public void insertDataEvent(long var1, long var3, String var5);

    public void insertDataEvent(JdbcTemplate var1, long var2, long var4, String var6);

    public void insertDataEvents(JdbcTemplate var1, List<DataEvent> var2);

    public void insertDataEventAndOutgoingBatch(long var1, String var3, String var4, DataEventType var5, String var6, boolean var7);

    public void insertDataAndDataEventAndOutgoingBatch(Data var1, String var2, List<Node> var3, String var4, boolean var5);

    public void insertDataAndDataEventAndOutgoingBatch(Data var1, String var2, String var3, boolean var4);

    public void insertPurgeEvent(Node var1, TriggerRouter var2, boolean var3);

    public void insertSqlEvent(Node var1, Trigger var2, String var3, boolean var4);

    public void insertSqlEvent(Node var1, String var2, boolean var3);

    public void insertCreateEvent(Node var1, TriggerRouter var2, String var3, boolean var4);

    public int countDataInRange(long var1, long var3);

    public void checkForAndUpdateMissingChannelIds(long var1, long var3);

    public void saveDataRef(DataRef var1);

    public DataRef getDataRef();

    public List<DataGap> findDataGapsByStatus(DataGap.Status var1);

    public List<DataGap> findDataGaps();

    public Date findCreateTimeOfEvent(long var1);

    public Date findCreateTimeOfData(long var1);

    public Data createData(String var1, String var2, String var3);

    public Data createData(String var1, String var2, String var3, String var4);

    public Map<String, String> getRowDataAsMap(Data var1);

    public void setRowDataFromMap(Data var1, Map<String, String> var2);

    public void addReloadListener(IReloadListener var1);

    public void addHeartbeatListener(IHeartbeatListener var1);

    public void setReloadListeners(List<IReloadListener> var1);

    public boolean removeReloadListener(IReloadListener var1);

    public Data readData(ResultSet var1) throws SQLException;

    public List<Number> listDataIds(long var1, boolean var3);

    public List<Data> listData(long var1, long var3, String var5, boolean var6, int var7);

    public void handleDataSelect(long var1, long var3, String var5, boolean var6, IModelRetrievalHandler<Data, String> var7);

    public void insertDataGap(DataGap var1);

    public void updateDataGap(DataGap var1, DataGap.Status var2);

    public long findMaxDataId();

    public IParameterService getParameterService();

    public IDbDialect getDbDialect();

    public JdbcTemplate getJdbcTemplate();
}

