/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.jumpmind.symmetric.common.logging.ILog;
import org.jumpmind.symmetric.db.BinaryEncoding;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.route.IRouterContext;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRouterContext
implements IRouterContext {
    protected NodeChannel channel;
    protected JdbcTemplate jdbcTemplate;
    protected boolean encountedTransactionBoundary = false;
    protected Map<String, Object> contextCache = new HashMap<String, Object>();
    protected Map<String, Long> stats = new HashMap<String, Long>();
    protected String nodeId;

    public SimpleRouterContext(String nodeId, JdbcTemplate jdbcTemplate, NodeChannel channel) {
        this.init(jdbcTemplate, channel, nodeId);
    }

    protected SimpleRouterContext() {
    }

    protected void init(JdbcTemplate jdbcTemplate, NodeChannel channel, String nodeId) {
        this.channel = channel;
        this.jdbcTemplate = jdbcTemplate;
        this.nodeId = nodeId;
    }

    @Override
    public BinaryEncoding getBinaryEncoding() {
        return null;
    }

    @Override
    public long getBatchId() {
        return -1L;
    }

    @Override
    public String getSourceNodeId() {
        return this.nodeId;
    }

    @Override
    public NodeChannel getChannel() {
        return this.channel;
    }

    @Override
    public Map<String, Object> getContextCache() {
        return this.contextCache;
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setEncountedTransactionBoundary(boolean encountedTransactionBoundary) {
        this.encountedTransactionBoundary = encountedTransactionBoundary;
    }

    @Override
    public boolean isEncountedTransactionBoundary() {
        return this.encountedTransactionBoundary;
    }

    @Override
    public synchronized void incrementStat(long amount, String name) {
        Long val = this.stats.get(name);
        if (val == null) {
            val = 0L;
        }
        val = val + amount;
        this.stats.put(name, val);
    }

    public synchronized long getStat(String name) {
        Long val = this.stats.get(name);
        if (val == null) {
            val = 0L;
        }
        return val;
    }

    public synchronized void logStats(ILog log, long totalTimeInMs) {
        boolean infoLevel = totalTimeInMs > 30000L;
        TreeSet<String> keys = new TreeSet<String>(this.stats.keySet());
        StringBuilder statsPrintout = new StringBuilder(this.channel.getChannelId());
        for (String key : keys) {
            statsPrintout.append(", " + key + "=" + this.stats.get(key));
        }
        if (infoLevel) {
            log.info("RouterStats", statsPrintout);
        } else {
            log.debug("RouterStats", statsPrintout);
        }
    }

    public synchronized void transferStats(SimpleRouterContext ctx) {
        HashSet<String> keys = new HashSet<String>(ctx.stats.keySet());
        for (String key : keys) {
            Long value = this.stats.get(key);
            if (value == null) {
                value = 0L;
            }
            this.incrementStat(value, key);
        }
    }
}

