/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import org.jumpmind.symmetric.route.ChannelRouterContext;
import org.jumpmind.symmetric.route.DataGapDetector;
import org.jumpmind.symmetric.route.DataGapRouteReader;
import org.jumpmind.symmetric.route.DataRefGapDetector;
import org.jumpmind.symmetric.route.DataRefRouteReader;
import org.jumpmind.symmetric.route.IDataToRouteGapDetector;
import org.jumpmind.symmetric.route.IDataToRouteReader;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.ISqlProvider;
import org.jumpmind.symmetric.service.impl.AbstractService;

public class DataToRouteReaderFactory
extends AbstractService
implements ISqlProvider {
    public static final String GAP_DETECTOR_TYPE_GAP = "gap";
    public static final String GAP_DETECTOR_TYPE_REF = "ref";
    private IDataService dataService;

    public IDataToRouteReader getDataToRouteReader(ChannelRouterContext context) {
        String type = this.parameterService.getString("routing.data.reader.type");
        if (type == null || type.equals(GAP_DETECTOR_TYPE_REF)) {
            return new DataRefRouteReader(this.log, this, context, this.dataService);
        }
        if (type == null || type.equals(GAP_DETECTOR_TYPE_GAP)) {
            return new DataGapRouteReader(this.log, this, context, this.dataService);
        }
        throw this.unsupportedType(type);
    }

    public IDataToRouteGapDetector getDataToRouteGapDetector() {
        String type = this.parameterService.getString("routing.data.reader.type");
        if (type == null || type.equals(GAP_DETECTOR_TYPE_REF)) {
            return new DataRefGapDetector(this.dataService, this.parameterService, this.jdbcTemplate, this.dbDialect, this);
        }
        if (type == null || type.equals(GAP_DETECTOR_TYPE_GAP)) {
            return new DataGapDetector(this.dataService, this.parameterService, this.jdbcTemplate, this.dbDialect, this);
        }
        throw this.unsupportedType(type);
    }

    public boolean isUsingDataRef() {
        String type = this.parameterService.getString("routing.data.reader.type");
        return type == null || type.equals(GAP_DETECTOR_TYPE_REF);
    }

    private RuntimeException unsupportedType(String type) {
        return new UnsupportedOperationException("The data to route type of '" + type + "' is not supported");
    }

    public void setDataService(IDataService dataService) {
        this.dataService = dataService;
    }
}

